/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.lib;

import com.sun.jade.cim.bean.CIM_DiagnosticTest;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestContext;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.diag.TestTemplateImpl;
import com.sun.jade.cim.diag.TestableElement;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.UnsignedInt16;
import java.io.Serializable;
import java.util.Locale;

public class DiagnosticTestInfo
implements Serializable {
    private static final String sccs_id = "@(#)DiagnosticTestInfo.java\t1.17 02/26/03 SMI";
    private String testName;
    private String testClassName;
    private String testDescription;
    private String mseClassName;
    private int[] symptoms;
    private int[] testResources;
    private int[] testCharacteristics;
    private CIMObjectPath mse;
    private DiagnosticSetting settingsForTest;
    private TestableElement[] testableElements;
    private TestTemplate template;

    public DiagnosticTestInfo(TestTemplate testTemplate, ReferenceForMSE referenceForMSE) {
        this.useTemplate(testTemplate);
        this.template = testTemplate;
        this.mse = referenceForMSE.getCIMObjectPath();
        this.mseClassName = this.mse.getObjectName();
    }

    public DiagnosticTestInfo(TestTemplate testTemplate, CIMObjectPath cIMObjectPath) {
        this.mse = cIMObjectPath;
        this.template = testTemplate;
        this.useTemplate(testTemplate);
    }

    public DiagnosticTestInfo(CIM_DiagnosticTest cIM_DiagnosticTest, CIMObjectPath cIMObjectPath, DiagnosticSetting diagnosticSetting) {
        int n;
        this.mse = cIMObjectPath;
        this.testName = cIM_DiagnosticTest.getName();
        this.testClassName = cIM_DiagnosticTest.getCreationClassName();
        this.testDescription = cIM_DiagnosticTest.getDescription();
        UnsignedInt16[] unsignedInt16Array = cIM_DiagnosticTest.getCharacteristics();
        if (unsignedInt16Array != null) {
            this.testCharacteristics = new int[unsignedInt16Array.length];
            n = 0;
            while (n < unsignedInt16Array.length) {
                this.testCharacteristics[n] = unsignedInt16Array[n].intValue();
                ++n;
            }
        }
        this.symptoms = new int[0];
        UnsignedInt16[] unsignedInt16Array2 = cIM_DiagnosticTest.getResourcesUsed();
        if (unsignedInt16Array2 != null) {
            this.testResources = new int[unsignedInt16Array2.length];
            n = 0;
            while (n < unsignedInt16Array2.length) {
                this.testResources[n] = unsignedInt16Array2[n].intValue();
                ++n;
            }
        }
        this.settingsForTest = diagnosticSetting;
    }

    public DiagnosticTestInfo(String string, String string2, String string3, DiagnosticSetting diagnosticSetting) {
        this.testName = string;
        this.testClassName = string2;
        this.mse = new CIMObjectPath(string3);
        this.settingsForTest = diagnosticSetting;
    }

    public String getTestName() {
        return this.getTestName(Locale.getDefault());
    }

    public String getTestName(Locale locale) {
        if (this.template != null) {
            return this.template.getTestCaption(locale);
        }
        return this.testName;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public String getMSEClassName() {
        return this.mse.getObjectName();
    }

    public CIMObjectPath getMSE() {
        return this.mse;
    }

    public void setMSE(ReferenceForMSE referenceForMSE) {
        this.mse = referenceForMSE.getCIMObjectPath();
    }

    public DiagnosticSetting getSettingsForTest(Locale locale) {
        if (this.template != null) {
            this.settingsForTest = this.template.getDefaultSetting(locale);
        }
        return this.getSettingsForTest();
    }

    public DiagnosticSetting getSettingsForTest() {
        return this.settingsForTest;
    }

    public TestContext getTestContext() {
        return null;
    }

    public String toString() {
        return this.getTestName();
    }

    public String getTestDescription() {
        return this.getTestDescription(Locale.getDefault());
    }

    public String getTestDescription(Locale locale) {
        if (this.template != null) {
            return this.template.getTestDescription(locale);
        }
        return this.testDescription;
    }

    public int[] getTestCharacteristics() {
        return this.testCharacteristics;
    }

    public String getTestCharacteristicsString() {
        int[] nArray = this.getTestCharacteristics();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(nArray[n] + ",");
            ++n;
        }
        String string = stringBuffer.toString();
        return string;
    }

    public int[] getTestResources() {
        return this.testResources;
    }

    public String getTestResourcesString() {
        int[] nArray = this.getTestResources();
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append(nArray[n] + ",");
                ++n;
            }
        }
        String string = stringBuffer.toString();
        return string;
    }

    public int[] getSymptoms() {
        return this.symptoms;
    }

    public String getSymptomsString() {
        int[] nArray = this.getSymptoms();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(nArray[n] + ",");
            ++n;
        }
        String string = stringBuffer.toString();
        return string;
    }

    public TestableElement[] getTestableElements() {
        return this.testableElements;
    }

    public String getTestableElementsString() {
        TestableElement[] testableElementArray = this.getTestableElements();
        StringBuffer stringBuffer = new StringBuffer();
        if (testableElementArray != null) {
            int n = 0;
            while (n < testableElementArray.length) {
                stringBuffer.append(testableElementArray[n] + ",");
                ++n;
            }
        }
        String string = stringBuffer.toString();
        return string;
    }

    private void useTemplate(TestTemplate testTemplate) {
        this.testClassName = testTemplate.getTestName();
        this.testableElements = testTemplate.getTestableElements();
        this.testCharacteristics = testTemplate.getTestCharacteristics();
        this.symptoms = testTemplate.getSymptoms();
        this.settingsForTest = testTemplate.getDefaultSetting(Locale.getDefault());
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            ReferenceForMSE referenceForMSE = new ReferenceForMSE("CIM_Void", "DeviceID", "0");
            TestableElement testableElement = new TestableElement("CIM_Device", 0, false);
            TestTemplateImpl testTemplateImpl = new TestTemplateImpl("Fake_Test", "Fake", "A fake test", null, null, testableElement, null);
            DiagnosticTestInfo diagnosticTestInfo = new DiagnosticTestInfo((TestTemplate)testTemplateImpl, referenceForMSE);
            this.assertEquals("Fake_Test", diagnosticTestInfo.getTestClassName());
            this.assertEquals("Fake", diagnosticTestInfo.getTestName());
        }
    }
}

