/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.lib;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.apps.diags.lib.DiagnosticResultEvent;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.TestException;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;

public class DiagnosticMonitor {
    private static int testExecID = 1;
    private static LinkedList runList = new LinkedList();
    public static final String sccs_id = "@(#)DiagnosticMonitor.java\t1.6 11/14/02 SMI";

    public static synchronized boolean abortTest(DiagnosticResult diagnosticResult) {
        String string = diagnosticResult.getExecutionID();
        Iterator iterator = runList.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            DiagItem diagItem = (DiagItem)iterator.next();
            DiagnosticResult diagnosticResult2 = diagItem.getDiagnosticResult();
            if (!string.equals(diagnosticResult2.getExecutionID())) continue;
            TestExecutable testExecutable = diagItem.getTestExecutable();
            try {
                bl = testExecutable.abortTest();
            }
            catch (TestException testException) {
                diagnosticResult2.addTestResults(testException.getLocalizedMessage());
                return false;
            }
            return bl;
        }
        return false;
    }

    public static synchronized void addTest(TestExecutable testExecutable, DiagnosticResult diagnosticResult, DiagnosticResultListener diagnosticResultListener) {
        DiagItem diagItem = new DiagItem(testExecutable, diagnosticResult, diagnosticResultListener);
        runList.add(diagItem);
        ResultMonitor resultMonitor = new ResultMonitor(diagItem);
        TestRunner testRunner = new TestRunner(diagItem);
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob(resultMonitor);
        threadPool.runJob(testRunner);
    }

    public static synchronized DiagnosticResult getResult(String string) {
        Iterator iterator = runList.iterator();
        while (iterator.hasNext()) {
            DiagItem diagItem = (DiagItem)iterator.next();
            DiagnosticResult diagnosticResult = diagItem.getDiagnosticResult();
            if (!string.equals(diagnosticResult.getExecutionID())) continue;
            return diagnosticResult;
        }
        return null;
    }

    public static synchronized int getExecID() {
        return testExecID++;
    }

    private static synchronized void removeItem(DiagItem diagItem) {
        runList.remove(diagItem);
    }

    private static class TestRunner
    implements Runnable {
        private TestExecutable test;
        private DiagnosticResult result;
        private DiagnosticResultListener listener;
        private DiagItem item;

        TestRunner(DiagItem diagItem) {
            this.item = diagItem;
            this.test = diagItem.getTestExecutable();
            this.result = diagItem.getDiagnosticResult();
            this.listener = diagItem.getListener();
        }

        public void run() {
            Serializable serializable;
            try {
                this.result.setTestState(TestState.IN_PROGRESS);
                this.test.runTest(this.result);
            }
            catch (TestException testException) {
                this.result.setFinalResults(TestState.FAILED, testException.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                LocalizedString localizedString = new DiagnosticException().getLocalizedString();
                this.result.addTestResults(localizedString.toString());
                this.result.setFinalResults(TestState.FAILED);
            }
            if (this.result.getTestCompletionTime() == null) {
                serializable = new DiagnosticException().getLocalizedString();
                this.result.addTestResults(serializable.toString());
                this.result.setFinalResults(TestState.FAILED);
            }
            serializable = new DiagnosticResultEvent((DiagnosticResult)this.result.clone());
            try {
                this.listener.notify((DiagnosticResultEvent)serializable);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            DiagnosticMonitor.removeItem(this.item);
        }
    }

    private static class ResultMonitor
    implements Runnable {
        private DiagItem item;
        private TestExecutable test;
        private DiagnosticResult result;
        private DiagnosticResultListener listener;

        ResultMonitor(DiagItem diagItem) {
            this.test = diagItem.getTestExecutable();
            this.result = diagItem.getDiagnosticResult();
            this.listener = diagItem.getListener();
        }

        public void run() {
            try {
                do {
                    this.result.waitForUpdate();
                    if (this.listener != null) {
                        DiagnosticResultEvent diagnosticResultEvent = new DiagnosticResultEvent((DiagnosticResult)this.result.clone());
                        this.listener.notify(diagnosticResultEvent);
                        continue;
                    }
                    Report.info.log("Updated Result: " + this.result);
                } while (this.result.getTestCompletionTime() == null);
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)("Result Monitor " + exception.toString()));
            }
        }
    }

    private static class DiagItem {
        private TestExecutable te;
        private DiagnosticResult dr;
        private DiagnosticResultListener drl;

        DiagItem(TestExecutable testExecutable, DiagnosticResult diagnosticResult, DiagnosticResultListener diagnosticResultListener) {
            this.te = testExecutable;
            this.dr = diagnosticResult;
            this.drl = diagnosticResultListener;
        }

        TestExecutable getTestExecutable() {
            return this.te;
        }

        DiagnosticResult getDiagnosticResult() {
            return this.dr;
        }

        DiagnosticResultListener getListener() {
            return this.drl;
        }
    }
}

