/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.lib;

import com.sun.jade.apps.diags.lib.Diagnosable;
import com.sun.jade.apps.diags.lib.DiagnosticResultEvent;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.bean.CIM_DiagnosticTest;
import com.sun.jade.cim.bean.CIM_DiagnosticTestForMSE;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.CIMReference;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.logic.mf.ServiceException;
import com.sun.jade.logic.wbem.CIMClientInterface;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class DiagnosticHelper
implements Diagnosable {
    private static final String TAG = "diags";
    private CIMClientInterface mf;

    public DiagnosticHelper(CIMClientInterface cIMClientInterface) throws DiagnosticException {
        this.mf = cIMClientInterface;
    }

    public DiagnosticTestInfo[] getDiagnosticTests() throws DiagnosticException {
        DiagnosticTestInfo[] diagnosticTestInfoArray;
        ArrayList<DiagnosticTestInfo> arrayList = new ArrayList<DiagnosticTestInfo>();
        try {
            diagnosticTestInfoArray = new CIMReference("CIM_DiagnosticTestForMSE");
            CIMInstance[] cIMInstanceArray = this.mf.enumerateInstances((CIMObjectPath)diagnosticTestInfoArray);
            int n = 0;
            while (n < cIMInstanceArray.length) {
                CIM_DiagnosticTestForMSE cIM_DiagnosticTestForMSE = new CIM_DiagnosticTestForMSE();
                cIM_DiagnosticTestForMSE.readCIMInstance(cIMInstanceArray[n]);
                CIMObjectPath cIMObjectPath = cIM_DiagnosticTestForMSE.getDependent();
                CIMObjectPath cIMObjectPath2 = cIM_DiagnosticTestForMSE.getAntecedent();
                if (this.isInSystem(cIMObjectPath)) {
                    CIMInstance cIMInstance = this.mf.getInstance(CIMReference.getRelativeObjectPath(cIMObjectPath2));
                    CIM_DiagnosticTest cIM_DiagnosticTest = new CIM_DiagnosticTest();
                    cIM_DiagnosticTest.readCIMInstance(cIMInstance);
                    DiagnosticSetting diagnosticSetting = this.getTestSetting(cIM_DiagnosticTest);
                    DiagnosticTestInfo diagnosticTestInfo = new DiagnosticTestInfo(cIM_DiagnosticTest, cIMObjectPath, diagnosticSetting);
                    arrayList.add(diagnosticTestInfo);
                }
                ++n;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new DiagnosticException(remoteException, "Service Error");
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            new DiagnosticException((Exception)((Object)cIMException), "CIM error");
        }
        diagnosticTestInfoArray = new DiagnosticTestInfo[arrayList.size()];
        arrayList.toArray(diagnosticTestInfoArray);
        return diagnosticTestInfoArray;
    }

    public boolean validateTest(DiagnosticTestInfo diagnosticTestInfo) throws DiagnosticException {
        DiagnosticSetting diagnosticSetting = diagnosticTestInfo.getSettingsForTest();
        Vector vector = diagnosticSetting.getTestParameters();
        int n = 0;
        while (n < vector.size()) {
            if (!((TestParameter)vector.get(n)).isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public DiagnosticResult runTest(DiagnosticTestInfo diagnosticTestInfo, DiagnosticResultListener diagnosticResultListener) throws DiagnosticException {
        Object object;
        Object object2;
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        CIMObjectPath cIMObjectPath = diagnosticTestInfo.getMSE();
        diagnosticResult.setMse(new ReferenceForMSE(cIMObjectPath));
        try {
            object2 = new CIMObjectPath(diagnosticTestInfo.getTestClassName());
            object2.addKey("Name", new CIMValue((Object)diagnosticTestInfo.getTestName()));
            object2.addKey("CreationClassName", new CIMValue((Object)diagnosticTestInfo.getTestClassName()));
            object = diagnosticTestInfo.getSettingsForTest();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(object.getCreationClassName());
            String string = diagnosticTestInfo.getTestClassName() + ":" + diagnosticTestInfo.getTestName();
            cIMObjectPath2.addKey("SettingID", new CIMValue((Object)string));
            object.setSettingID(string);
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(object.getCreationClassName());
            CIMClass cIMClass = this.mf.getClass(cIMObjectPath3);
            CIMInstance cIMInstance = cIMClass.newInstance();
            object.setSettingID(string);
            ((DiagnosticSetting)((Object)object)).writeCIMInstance(cIMInstance);
            Report.debug.log(TAG, (Object)cIMInstance);
            Report.debug.log(TAG, (Object)cIMObjectPath2);
            try {
                this.mf.setInstance(cIMObjectPath2, cIMInstance);
            }
            catch (ServiceException serviceException) {
                this.mf.createInstance(cIMObjectPath2, cIMInstance);
            }
            Vector<CIMValue> vector = new Vector<CIMValue>(2);
            Vector vector2 = new Vector(1);
            CIMValue cIMValue = new CIMValue((Object)cIMObjectPath);
            vector.add(cIMValue);
            cIMValue = new CIMValue((Object)cIMObjectPath2);
            vector.add(cIMValue);
            Report.debug.log(TAG, (Object)"runTest: invoke method:");
            Report.debug.log(TAG, (Object)("   copTest= " + object2));
            Report.debug.log(TAG, (Object)"   name   = RunTest");
            Report.debug.log(TAG, (Object)("   inParams = " + vector));
            Report.debug.log(TAG, (Object)("   outParams = " + vector2));
            CIMInstance cIMInstance2 = this.mf.getInstance((CIMObjectPath)object2);
            Report.debug.log(TAG, (Object)("Invoke Method on test = " + cIMInstance2));
            CIMValue cIMValue2 = this.mf.invokeMethod((CIMObjectPath)object2, "RunTest", vector, vector2);
            if (vector2.size() != 1) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            CIMValue cIMValue3 = (CIMValue)vector2.get(0);
            CIMObjectPath cIMObjectPath4 = (CIMObjectPath)cIMValue3.getValue();
            CIMInstance cIMInstance3 = this.mf.getInstance(cIMObjectPath4);
            Report.debug.log(TAG, (Object)("Result = " + cIMObjectPath4));
            if (cIMInstance3 != null) {
                diagnosticResult.readCIMInstance(this.mf.getInstance(cIMObjectPath4));
            } else {
                diagnosticResult.setTestState(TestState.FAILED);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new DiagnosticException(remoteException, "Remote Service Error");
        }
        catch (CIMException cIMException) {
            Report.error.log("DiagnosticClient.runTest FAILED");
            diagnosticResult.setTestState(TestState.FAILED);
            return diagnosticResult;
        }
        object2 = new MonitorTest(diagnosticTestInfo, this, new ElementKey(diagnosticResult.getExecutionID()), diagnosticResultListener);
        object = new Thread((Runnable)object2);
        ((Thread)object).start();
        return diagnosticResult;
    }

    public DiagnosticResult getTestResults(ElementKey elementKey) throws DiagnosticException {
        return null;
    }

    public boolean abortTest(ElementKey elementKey) throws DiagnosticException {
        boolean bl = false;
        try {
            CIMValue cIMValue;
            Object object;
            Object object2;
            Object object3;
            CIMReference cIMReference = new CIMReference("CIM_DiagnosticResultForTest", this.mf.getManagedSystem().getNameSpace());
            CIMReference cIMReference2 = new CIMReference("CIM_DiagnosticResult");
            CIMObjectPath cIMObjectPath = null;
            CIMObjectPath cIMObjectPath2 = null;
            CIMInstance[] cIMInstanceArray = this.mf.enumerateInstances(cIMReference);
            int n = 0;
            while (n < cIMInstanceArray.length) {
                object3 = cIMInstanceArray[n];
                CIMProperty cIMProperty = object3.getProperty("DiagnosticResult");
                cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
                object2 = cIMObjectPath2.getKeys().elements();
                while (object2.hasMoreElements()) {
                    cIMProperty = (CIMProperty)object2.nextElement();
                    Report.debug.log(TAG, (Object)("Result Key :" + cIMProperty));
                    if (!cIMProperty.getName().equalsIgnoreCase("ExecutionID") || !((String)(object = (String)(cIMValue = cIMProperty.getValue()).getValue())).equals(elementKey.toString())) continue;
                    cIMProperty = object3.getProperty("DiagnosticTest");
                    cIMObjectPath = (CIMObjectPath)cIMProperty.getValue().getValue();
                }
                ++n;
            }
            if (cIMObjectPath == null) {
                Report.debug.log(TAG, (Object)("No test for id = " + elementKey));
                throw new CIMException("CIM_ERR_FAILED");
            }
            object3 = new Vector();
            object2 = new Vector();
            cIMValue = new CIMValue((Object)"copMSE");
            ((Vector)object3).add(cIMValue);
            cIMValue = new CIMValue((Object)cIMObjectPath2);
            ((Vector)object3).add(cIMValue);
            object = this.mf.invokeMethod(new CIMReference(cIMObjectPath), "DiscontinueTest", (Vector)object3, (Vector)object2);
            switch (((UnsignedInt32)object.getValue()).intValue()) {
                case 0: {
                    if (((Vector)object2).size() == 1) break;
                    Report.debug.log(TAG, (Object)"No value returned from abort method.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                case 1: {
                    Report.debug.log(TAG, (Object)"ERROR aborting test.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                case 2: {
                    Report.debug.log(TAG, (Object)"Abort Test not implemented for this test.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                case 3: {
                    Report.debug.log(TAG, (Object)"Abort failed: out of resources.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
                default: {
                    Report.debug.log(TAG, (Object)"Abort : Unknown return code.");
                    throw new CIMException("CIM_ERR_FAILED");
                }
            }
            CIMValue cIMValue2 = (CIMValue)((Vector)object2).get(0);
            bl = (Boolean)cIMValue2.getValue();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        return bl;
    }

    public String getSystemClassName() throws DiagnosticException {
        try {
            return this.mf.getManagedSystem().getObjectName();
        }
        catch (RemoteException remoteException) {
            throw new DiagnosticException(remoteException, "Service Error");
        }
    }

    public String getSystemName() throws DiagnosticException {
        try {
            CIMReference cIMReference = this.mf.getManagedSystem();
            CIMValue cIMValue = cIMReference.getKeyValue("Name");
            if (cIMValue != null) {
                return (String)cIMValue.getValue();
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new DiagnosticException(remoteException, "Service Error");
        }
    }

    private boolean isInSystem(CIMObjectPath cIMObjectPath) {
        return true;
    }

    DiagnosticSetting getTestSetting(CIM_DiagnosticTest cIM_DiagnosticTest) throws DiagnosticException {
        DiagnosticSetting diagnosticSetting;
        try {
            Object object;
            String string = null;
            String string2 = cIM_DiagnosticTest.getName() + "Setting";
            CIMReference[] cIMReferenceArray = this.mf.enumerateClassNames(new CIMObjectPath("CIM_DiagnosticSetting"), true);
            int n = 0;
            while (n < cIMReferenceArray.length) {
                if (string2.equalsIgnoreCase(cIMReferenceArray[n].getObjectName())) {
                    string = cIMReferenceArray[n].getObjectName();
                }
                ++n;
            }
            if (string == null) {
                string = "CIM_DiagnosticSetting";
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            CIMClass cIMClass = this.mf.getClass(cIMObjectPath);
            Vector vector = cIMClass.getProperties();
            diagnosticSetting = new DiagnosticSetting(string);
            int n2 = 0;
            while (n2 < vector.size()) {
                block9: {
                    object = new TestParameter();
                    Report.debug.log(TAG, (Object)("Adding param " + n2 + " = \n" + vector.get(n2)));
                    try {
                        ((TestParameter)object).readCIMProperty((CIMProperty)vector.get(n2));
                    }
                    catch (Exception exception) {
                        Report.error.log("Error adding param" + exception.toString());
                        break block9;
                    }
                    diagnosticSetting.addParameter((TestParameter)object);
                }
                ++n2;
            }
            object = cIMClass.newInstance();
            diagnosticSetting.readCIMInstance((CIMInstance)object);
            diagnosticSetting.setCreationClassName(object.getClassName());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new DiagnosticException(remoteException, "Service Error");
        }
        catch (CIMException cIMException) {
            throw new DiagnosticException((Exception)((Object)cIMException), "CIM error");
        }
        diagnosticSetting.pruneUnsupportedSettings(cIM_DiagnosticTest.getCharacteristics());
        return diagnosticSetting;
    }

    class MonitorTest
    implements Runnable {
        static final int pollQuantum = 5000;
        DiagnosticTestInfo testInfo;
        DiagnosticHelper helper;
        ElementKey testKey;
        DiagnosticResultListener listener;

        MonitorTest(DiagnosticTestInfo diagnosticTestInfo, DiagnosticHelper diagnosticHelper2, ElementKey elementKey, DiagnosticResultListener diagnosticResultListener) {
            this.testInfo = diagnosticTestInfo;
            this.helper = diagnosticHelper2;
            this.testKey = elementKey;
            this.listener = diagnosticResultListener;
        }

        public void run() {
            TestState testState;
            Thread thread = Thread.currentThread();
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    DiagnosticResult diagnosticResult = this.helper.getTestResults(this.testKey);
                    diagnosticResult.setMse(new ReferenceForMSE(this.testInfo.getMSE()));
                    DiagnosticResultEvent diagnosticResultEvent = new DiagnosticResultEvent(diagnosticResult);
                    try {
                        this.listener.notify(diagnosticResultEvent);
                    }
                    catch (Exception exception) {
                        Report.debug.log(DiagnosticHelper.TAG, (Object)("Error calling notify: " + exception));
                        Report.debug.log(DiagnosticHelper.TAG, (Object)("\tListener = " + this.listener));
                        Report.debug.log(DiagnosticHelper.TAG, (Object)("\tEvent    = " + diagnosticResultEvent));
                        Report.error.log(exception, (Object)"");
                    }
                    testState = diagnosticResult.getTestStateValueMap();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    testState = TestState.FAILED;
                }
            } while (testState.equals(TestState.IN_PROGRESS));
        }
    }
}

