/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.lib;

import com.sun.jade.apps.diags.lib.Diagnosable;
import com.sun.jade.apps.diags.lib.DiagnosticMonitor;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.apps.diags.lib.TestTemplateProvider;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.diag.TestableElement;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class DiagTemplateImpl
implements Diagnosable {
    private TestTemplateProvider provider;
    private String systemClassName;
    private String systemName;
    private CIMObjectPath systemObjectPath;
    private Object service;
    public static final String sccs_id = "@(#)DiagTemplateImpl.java\t1.15 02/20/03 SMI";

    public DiagTemplateImpl(String string, String string2, TestTemplateProvider testTemplateProvider) {
        this.systemClassName = string;
        this.systemName = string2;
        this.provider = testTemplateProvider;
    }

    public DiagTemplateImpl(String string, String string2, ReferenceForMSE[] referenceForMSEArray, TestTemplate[] testTemplateArray) {
        int n;
        this.systemClassName = string;
        this.systemName = string2;
        ArrayList<ReferenceForMSE> arrayList = new ArrayList<ReferenceForMSE>();
        ArrayList<TestTemplate> arrayList2 = new ArrayList<TestTemplate>();
        if (referenceForMSEArray != null) {
            arrayList.ensureCapacity(referenceForMSEArray.length);
            n = 0;
            while (n < referenceForMSEArray.length) {
                arrayList.add(referenceForMSEArray[n]);
                ++n;
            }
        }
        if (testTemplateArray != null) {
            arrayList2.ensureCapacity(testTemplateArray.length);
            n = 0;
            while (n < testTemplateArray.length) {
                arrayList2.add(testTemplateArray[n]);
                ++n;
            }
        }
        this.provider = new InternalTestProvider(arrayList2, arrayList);
        this.systemObjectPath = new CIMObjectPath(string);
        this.systemObjectPath.addKey("Name", new CIMValue((Object)string2));
    }

    public DiagTemplateImpl(String string, String string2, ReferenceForMSE[] referenceForMSEArray, String[] stringArray) {
        this.systemClassName = string;
        this.systemName = string2;
        ArrayList<ReferenceForMSE> arrayList = new ArrayList<ReferenceForMSE>();
        if (referenceForMSEArray != null) {
            arrayList.ensureCapacity(referenceForMSEArray.length);
            int n = 0;
            while (n < referenceForMSEArray.length) {
                arrayList.add(referenceForMSEArray[n]);
                ++n;
            }
        }
        ArrayList arrayList2 = new ArrayList(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            block8: {
                Class<?> clazz;
                Report.debug.log("DiagnosableImpl:test=" + stringArray[n]);
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    clazz = classLoader.loadClass(stringArray[n]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Report.warning.log(classNotFoundException.toString());
                    break block8;
                }
                try {
                    arrayList2.add(clazz.newInstance());
                }
                catch (IllegalAccessException illegalAccessException) {
                    Report.warning.log(illegalAccessException.toString());
                }
                catch (InstantiationException instantiationException) {
                    Report.warning.log(instantiationException.toString());
                }
            }
            ++n;
        }
        this.provider = new InternalTestProvider(arrayList2, arrayList);
        this.systemObjectPath = new CIMObjectPath(string);
        this.systemObjectPath.addKey("Name", new CIMValue((Object)string2));
    }

    public String getSystemClassName() {
        return this.systemClassName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public DiagnosticTestInfo[] getDiagnosticTests() {
        Object object;
        Collection collection = this.provider.getTemplates();
        Collection collection2 = this.provider.getMSEs();
        if (collection == null) {
            return new DiagnosticTestInfo[0];
        }
        ArrayList<DiagnosticTestInfo> arrayList = new ArrayList<DiagnosticTestInfo>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (TestTemplate)iterator.next();
            TestableElement[] testableElementArray = object.getTestableElements();
            if (testableElementArray == null) continue;
            int n = 0;
            while (n < testableElementArray.length) {
                if (testableElementArray[n].getCreationClassName().equals(this.systemClassName)) {
                    arrayList.add(new DiagnosticTestInfo((TestTemplate)object, this.systemObjectPath));
                }
                if (collection2 != null) {
                    Iterator iterator2 = collection2.iterator();
                    String string = testableElementArray[n].getCreationClassName();
                    while (iterator2.hasNext()) {
                        ReferenceForMSE referenceForMSE = (ReferenceForMSE)iterator2.next();
                        if (!string.equals(referenceForMSE.getCreationClassName())) continue;
                        arrayList.add(new DiagnosticTestInfo((TestTemplate)object, referenceForMSE));
                    }
                }
                ++n;
            }
        }
        object = new DiagnosticTestInfo[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public boolean validateTest(DiagnosticTestInfo diagnosticTestInfo) {
        if (diagnosticTestInfo == null) {
            return false;
        }
        DiagnosticSetting diagnosticSetting = diagnosticTestInfo.getSettingsForTest();
        Vector vector = diagnosticSetting.getTestParameters();
        int n = 0;
        while (n < vector.size()) {
            if (!((TestParameter)vector.get(n)).isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized DiagnosticResult runTest(DiagnosticTestInfo diagnosticTestInfo, DiagnosticResultListener diagnosticResultListener) {
        Object object;
        Collection collection = this.provider.getTemplates();
        Iterator iterator = collection.iterator();
        Object object2 = null;
        while (iterator.hasNext()) {
            object = (TestTemplate)iterator.next();
            if (!object.getTestName().equals(diagnosticTestInfo.getTestClassName())) continue;
            object2 = object;
            break;
        }
        object = new DiagnosticResult();
        object.setDiagnosticName(diagnosticTestInfo.getTestClassName());
        ((DiagnosticResult)object).setMse(new ReferenceForMSE(diagnosticTestInfo.getMSE()));
        ((DiagnosticResult)object).setExecutionID(diagnosticTestInfo.getTestClassName() + ":" + DiagnosticMonitor.getExecID());
        ((DiagnosticResult)object).setPercentComplete((short)0);
        if (object2 == null) {
            ((DiagnosticResult)object).setFinalResults(TestState.FAILED, "Unknown Test");
            return (DiagnosticResult)((DiagnosticResult)object).clone();
        }
        CIMObjectPath cIMObjectPath = diagnosticTestInfo.getMSE();
        if (cIMObjectPath == null) {
            ((DiagnosticResult)object).setFinalResults(TestState.FAILED, "Undefined test element.");
            return (DiagnosticResult)((DiagnosticResult)object).clone();
        }
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(diagnosticTestInfo.getMSE());
        referenceForMSE.setDeviceService(this.service);
        try {
            TestExecutable testExecutable = object2.getTestExec(referenceForMSE, diagnosticTestInfo.getSettingsForTest());
            if (testExecutable == null) {
                ((DiagnosticResult)object).setFinalResults(TestState.FAILED, "Test failed to Execute");
                return (DiagnosticResult)((DiagnosticResult)object).clone();
            }
            int[] nArray = object2.getTestCharacteristics();
            boolean bl = false;
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] == 2) {
                    bl = true;
                }
                ++n;
            }
            boolean bl2 = true;
            TestableElement[] testableElementArray = object2.getTestableElements();
            int n2 = 0;
            while (n2 < testableElementArray.length) {
                if (testableElementArray[n2].getCreationClassName().equals(referenceForMSE.getCreationClassName())) {
                    bl2 = testableElementArray[n2].getIsExclusiveForDevice();
                }
                ++n2;
            }
            DiagnosticMonitor.addTest(testExecutable, (DiagnosticResult)object, diagnosticResultListener);
        }
        catch (Exception exception) {
            ((DiagnosticResult)object).setFinalResults(TestState.FAILED, "Test failed to Execute");
        }
        return (DiagnosticResult)((DiagnosticResult)object).clone();
    }

    public synchronized DiagnosticResult getTestResults(ElementKey elementKey) {
        if (elementKey == null) {
            throw new IllegalArgumentException();
        }
        DiagnosticResult diagnosticResult = DiagnosticMonitor.getResult(elementKey.toString());
        return (DiagnosticResult)diagnosticResult.clone();
    }

    public synchronized boolean abortTest(ElementKey elementKey) {
        if (elementKey == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        diagnosticResult.setExecutionID(elementKey.toString());
        return DiagnosticMonitor.abortTest(diagnosticResult);
    }

    protected void setDeviceService(Object object) {
        this.service = object;
    }

    public static class Test
    extends UnitTest {
        public void testDefault() throws Exception {
            DiagTemplateImpl diagTemplateImpl = new DiagTemplateImpl("a", "b", null, new TestTemplate[0]);
            this.assertEquals(diagTemplateImpl.getSystemClassName(), "a");
            this.assertEquals(diagTemplateImpl.getSystemName(), "b");
            this.assertCondition(diagTemplateImpl.getDiagnosticTests().length == 0);
            this.assertCondition(!diagTemplateImpl.validateTest(null));
            this.assertCondition(!diagTemplateImpl.abortTest(new ElementKey()));
            try {
                this.assertNull(diagTemplateImpl.getTestResults(null));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.fail("IllegalArgumentException not thrown");
        }

        private class TestExecUnitTest
        implements TestExecutable {
            boolean running = false;
            ReferenceForMSE mse;
            DiagnosticSetting s;

            TestExecUnitTest(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
                this.mse = referenceForMSE;
                this.s = diagnosticSetting;
            }

            public DiagnosticSetting getDiagnosticSetting() {
                return this.s;
            }

            public ReferenceForMSE getMSE() {
                return this.mse;
            }

            public ReferenceForMSE getExclusiveMSE() {
                return this.mse;
            }

            public void runTest(DiagnosticResult diagnosticResult) {
                Thread thread = Thread.currentThread();
                this.running = true;
                short s = 1;
                diagnosticResult.setTestState(TestState.IN_PROGRESS);
                while (this.running & s < 100) {
                    diagnosticResult.setPercentComplete(s);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    s = (short)(s + 1);
                }
                diagnosticResult.setFinalResults(TestState.STOPPED);
            }

            public boolean abortTest() {
                this.running = false;
                return true;
            }

            public boolean pauseTest() {
                return false;
            }

            public boolean continueTest() {
                return false;
            }
        }

        private class TestTemplateUnitTest
        implements TestTemplate {
            private TestTemplateUnitTest() {
            }

            public String getTestName() {
                return "TestTemplateUnitTest";
            }

            public String getTestCaption(Locale locale) {
                return "Unit Test Template";
            }

            public String getTestDescription(Locale locale) {
                return "Desc";
            }

            public String[] getTestPackageNames() {
                return new String[0];
            }

            public DiagnosticSetting getDefaultSetting(Locale locale) {
                return new DiagnosticSetting();
            }

            public String[] getDependancies() {
                return new String[0];
            }

            public int[] getSymptoms() {
                return new int[0];
            }

            public int[] getTestCharacteristics() {
                int[] nArray = new int[]{101, 2};
                return nArray;
            }

            public int[] getTestResources() {
                return new int[0];
            }

            public TestableElement[] getTestableElements() {
                TestableElement[] testableElementArray = new TestableElement[]{new TestableElement("Class", 10, true)};
                return testableElementArray;
            }

            public TestExecutable getTestExec(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
                return new TestExecUnitTest(referenceForMSE, diagnosticSetting);
            }
        }
    }

    private class InternalTestProvider
    implements TestTemplateProvider {
        private Collection tests;
        private Collection mses;

        InternalTestProvider(Collection collection, Collection collection2) {
            this.tests = collection;
            this.mses = collection2;
        }

        public Collection getTemplates() {
            return this.tests;
        }

        public Collection getMSEs() {
            return this.mses;
        }
    }
}

