/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.exec;

import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class DiagnosticTestRegistry {
    private static DiagnosticTestRegistry registry = new DiagnosticTestRegistry();
    private HashMap testList = new HashMap();

    private DiagnosticTestRegistry() {
    }

    public static DiagnosticTestRegistry getInstance() {
        return registry;
    }

    public void registerTests(String string, DiagnosticTestInfo[] diagnosticTestInfoArray) {
        if (this.testList.get(string) == null) {
            Report.debug.log("DiagnosticTestRegistry", (Object)"Adding a tests to the registry map.");
            this.testList.put(string, diagnosticTestInfoArray);
        } else {
            Report.debug.log("DiagnosticTestRegistry", (Object)("Tests for " + string + " already registered."));
        }
    }

    public DiagnosticTestInfo[] getTestsForMF(MF mF) throws RemoteException {
        return this.getMseTestsForMF(mF, new ReferenceForMSE(mF.getClassName(), mF.getName()));
    }

    public DiagnosticTestInfo[] getMseTestsForMF(MF mF, ReferenceForMSE referenceForMSE) throws RemoteException {
        Object[] objectArray;
        DiagnosableHelper diagnosableHelper = (DiagnosableHelper)mF.getServiceHelper("com.sun.jade.apps.diags.lib.DiagnosableHelper");
        if (diagnosableHelper == null) {
            Report.debug.log("DiagnosticTestRegistry", (Object)("No DiagnosableHelper for Device " + mF.getClassName() + ":" + mF.getName()));
            return null;
        }
        DiagnosticTestInfo[] diagnosticTestInfoArray = null;
        try {
            diagnosticTestInfoArray = diagnosableHelper.getDiagnosticTests();
        }
        catch (DiagnosticException diagnosticException) {
            Report.error.log(diagnosticException);
        }
        if (diagnosticTestInfoArray == null) {
            Report.debug.log("DiagnosticTestRegistry", (Object)("No tests registered for Device " + mF.getClassName() + ":" + mF.getName()));
            return null;
        }
        Vector<DiagnosticTestInfo> vector = new Vector<DiagnosticTestInfo>();
        int n = 0;
        while (n < diagnosticTestInfoArray.length) {
            objectArray = diagnosticTestInfoArray[n].getMSEClassName();
            CIMObjectPath cIMObjectPath = diagnosticTestInfoArray[n].getMSE();
            ReferenceForMSE referenceForMSE2 = new ReferenceForMSE(cIMObjectPath);
            if (objectArray.equals(referenceForMSE.getCreationClassName()) && referenceForMSE2.equals(referenceForMSE)) {
                Report.debug.log("DiagnosticTestRegistry", (Object)"Found a Test for the MSE reference.");
                vector.addElement(diagnosticTestInfoArray[n]);
            }
            ++n;
        }
        objectArray = new DiagnosticTestInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public HashMap getTestList() {
        return this.testList;
    }
}

