/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.diags.exec;

import com.sun.jade.apps.diags.exec.ContextManager;
import com.sun.jade.apps.diags.exec.SessionTestQue;
import com.sun.jade.apps.diags.exec.TestRunEntry;
import com.sun.jade.apps.diags.lib.DiagnosticResultEvent;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.util.log.Report;

class DiagnosticHandler
implements Runnable {
    private ContextManager manager;
    private TestRunEntry testRun;
    private SessionTestQue sessionQue;

    public DiagnosticHandler(TestRunEntry testRunEntry, SessionTestQue sessionTestQue) {
        this.manager = new ContextManager(testRunEntry, sessionTestQue);
        this.testRun = testRunEntry;
        this.sessionQue = sessionTestQue;
        this.run();
    }

    public void run() {
        Report.debug.log("run test");
        DiagnosticResult diagnosticResult = null;
        try {
            if (this.manager.getContext()) {
                diagnosticResult = this.manager.runTest();
            } else {
                Report.warning.log("Test failed to start.");
                this.testRun.setState(3);
                diagnosticResult = this.manager.getFailedResult();
                Report.warning.log(diagnosticResult.toString());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.testRun.setDiagnosticResult(diagnosticResult);
        ElementKey elementKey = this.testRun.getElementKey();
        Report.debug.log("Map key " + elementKey + " to " + diagnosticResult.getExecutionID());
        this.sessionQue.putTestInQue(diagnosticResult.getElementKey(), this.testRun);
        this.sessionQue.notify(new DiagnosticResultEvent(diagnosticResult));
    }
}

