/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.util.LinkedList;

public class ThreadPool {
    private static ThreadPool mainPool;
    private HandlerList handlers = new HandlerList();
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long IDLE_TIME_INTERVAL = 1200000L;
    private static final int MAX_THREADS = 50;
    public static final String sccs_id = "@(#)ThreadPool.java\t1.4 11/27/02 SMI";

    public static ThreadPool getThreadPool() {
        if (mainPool == null) {
            mainPool = new ThreadPool();
        }
        return mainPool;
    }

    private ThreadPool() {
    }

    public synchronized Thread runJob(Runnable runnable) {
        Handler handler = this.handlers.getHandler();
        handler.runJob(runnable);
        return handler;
    }

    public static class Test
    extends UnitTest {
        public static void main(String[] stringArray) {
            try {
                int n = 0;
                while (n < 4) {
                    CommandExec commandExec = new CommandExec("sleep 30");
                    commandExec.exec();
                    ++n;
                }
                int n2 = 0;
                while (n2 < 30) {
                    CommandExec commandExec = new CommandExec("sleep 60");
                    System.out.println("sleep 60");
                    commandExec.run();
                    System.out.println("done");
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class HandlerList {
        private LinkedList list = new LinkedList();
        private LinkedList active = new LinkedList();
        private long idleTime = System.currentTimeMillis();
        private int numIdle;

        private HandlerList() {
        }

        synchronized Handler getHandler() {
            if (this.list.size() == 0) {
                if (this.active.size() < 50) {
                    Handler handler = new Handler();
                    handler.start();
                    this.active.add(handler);
                    return handler;
                }
                Report.warning.log("Too many threads.  Job must wait.");
            }
            while (this.list.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Handler handler = (Handler)this.list.removeFirst();
            this.active.add(handler);
            return handler;
        }

        synchronized void returnHandler(Handler handler) {
            if (this.active.remove(handler)) {
                this.list.add(handler);
                this.notifyAll();
            }
            this.checkIdle();
        }

        synchronized void removeHandler(Handler handler) {
            this.active.remove(handler);
            handler.shutdown();
        }

        void checkIdle() {
            long l = System.currentTimeMillis();
            int n = this.list.size();
            if (n == 0) {
                this.idleTime = l;
                return;
            }
            if (n < this.numIdle) {
                this.idleTime = l;
                this.numIdle = n;
                return;
            }
            long l2 = l - this.idleTime;
            if (l2 > 1200000L) {
                Report.debug.log("cleaning unused threads #" + n);
                int n2 = 0;
                while (n2 < n) {
                    this.removeHandler(this.getHandler());
                    ++n2;
                }
                n = 0;
                this.idleTime = l;
            }
        }
    }

    private class Handler
    extends Thread {
        Runnable job;
        boolean abort;

        private Handler() {
        }

        synchronized boolean runJob(Runnable runnable) {
            if (this.job != null) {
                return false;
            }
            if (this.abort) {
                return false;
            }
            this.job = runnable;
            this.notify();
            return true;
        }

        synchronized Runnable getJob() {
            while (this.job == null) {
                if (this.abort) {
                    return null;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        synchronized void shutdown() {
            this.abort = true;
            this.notify();
        }

        public void run() {
            while (!this.abort) {
                try {
                    this.getJob();
                    if (this.job == null) continue;
                    this.job.run();
                    this.cleanup();
                }
                catch (Throwable throwable) {
                    Report.error.log(throwable, (Object)"Error running job.");
                }
            }
        }

        private synchronized void cleanup() {
            this.job = null;
            ThreadPool.this.handlers.returnHandler(this);
        }
    }
}

