/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;

public class CommandClient {
    private String hostname;
    private int port;
    private static final String sccs_id = "@(#)CommandClient.java\t1.2 12/11/01 SMI";

    public CommandClient(String string, int n) {
        this.hostname = string;
        this.port = n;
    }

    public CommandClient(String string, String string2) {
        this.hostname = string;
        this.port = Integer.parseInt(string2);
    }

    public InputStream issueCommand(String string) throws IOException {
        return this.doIssueCommand("GET " + string + " HTTP/1.0\r\n\r\n");
    }

    public InputStream issueCommand(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("POST " + string + " HTTP/1.0\r\n");
        stringBuffer.append("Content-length: " + string2.length());
        stringBuffer.append("\r\n\r\n");
        stringBuffer.append(string2);
        return this.doIssueCommand(stringBuffer.toString());
    }

    public InputStream issueCommand(String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        return this.issueCommand(string, stringBuffer.toString());
    }

    public InputStream issueCommand(String string, Properties properties) throws IOException {
        return this.doIssueCommand("GET " + string + " HTTP/1.0\r\n\r\n", properties);
    }

    public InputStream issueCommand(String string, String string2, Properties properties) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("POST " + string + " HTTP/1.0\r\n");
        stringBuffer.append("Content-length: " + string2.length());
        stringBuffer.append("\r\n\r\n");
        stringBuffer.append(string2);
        return this.doIssueCommand(stringBuffer.toString(), properties);
    }

    public InputStream issueCommand(String string, String[] stringArray, Properties properties) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        return this.issueCommand(string, stringBuffer.toString(), properties);
    }

    private InputStream doIssueCommand(String string) throws IOException {
        Socket socket = this.createSocket();
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.write(string);
        bufferedWriter.flush();
        return inputStream;
    }

    private InputStream doIssueCommand(String string, Properties properties) throws IOException {
        Socket socket = this.createSocket();
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.write(string);
        bufferedWriter.flush();
        String string2 = this.getLine(inputStream);
        properties.setProperty("HEADER", string2);
        this.addProperties(inputStream, properties);
        return inputStream;
    }

    private Socket createSocket() throws IOException {
        try {
            return new Socket(this.hostname, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException(unknownHostException.toString());
        }
    }

    private void addProperties(InputStream inputStream, Properties properties) {
        String string;
        while ((string = this.getLine(inputStream)).length() != 0) {
            String string2 = string;
            String string3 = "";
            int n = string.indexOf(58);
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 2);
            }
            properties.setProperty(string2, string3);
        }
        return;
    }

    private String getLine(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                int n;
                if ((n = inputStream.read()) == 13) {
                    continue;
                }
                if (n != 10 && n != -1) {
                    stringBuffer.append((char)n);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

