/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.command;

import com.sun.jade.apps.command.Property;
import com.sun.jade.util.unittest.UnitTest;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Vector;

public class ClientRequest {
    private static final String NEWLINE = "\r\n";
    private Reader in;
    private String command;
    private String location;
    private String version;
    private Vector properties = new Vector();

    public ClientRequest(Reader reader) {
        this.in = reader;
        String string = this.getLine();
        int n = string.indexOf(32);
        if (n > 0) {
            this.command = string.substring(0, n);
            int n2 = string.indexOf(32, n + 1);
            if (n2 > 0) {
                this.location = string.substring(n + 1, n2);
                this.version = string.substring(n2 + 1);
            }
        } else {
            this.command = string;
        }
        this.getProperties();
    }

    public String getCommand() {
        return this.command;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public Vector getAttributes() {
        return this.properties;
    }

    public Property getProperty(String string) {
        if (this.properties != null) {
            int n = 0;
            while (n < this.properties.size()) {
                Property property = (Property)this.properties.get(n);
                if (property.getName().equals(string)) {
                    return property;
                }
                ++n;
            }
        }
        return null;
    }

    public String getReplyHeader(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Date date = new Date();
        stringBuffer.append("HTTP/1.0 200 OK\r\n");
        stringBuffer.append("Date: " + date + NEWLINE);
        stringBuffer.append("Server: StorAde Command 1.3 10/18/01\r\n");
        stringBuffer.append("Content-length: " + n + NEWLINE);
        stringBuffer.append("Content-type: " + string + NEWLINE);
        stringBuffer.append(NEWLINE);
        return stringBuffer.toString();
    }

    private Vector getProperties() {
        Vector vector = this.properties;
        String string;
        while ((string = this.getLine()).length() != 0) {
            int n = string.indexOf(58);
            Property property = n > 0 ? new Property(string.substring(0, n), string.substring(n + 2)) : new Property(string, "");
            vector.add(property);
        }
        return vector;
    }

    private String getLine() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                int n;
                if ((n = this.in.read()) == 13) {
                    continue;
                }
                if (n != 10 && n != -1) {
                    stringBuffer.append((char)n);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            String string = "GET /this HTTP/1.0\nblah: ok\r\n\r\n";
            StringReader stringReader = new StringReader(string);
            ClientRequest clientRequest = new ClientRequest(stringReader);
            this.assertEquals(clientRequest.getCommand(), "GET");
            this.assertEquals(clientRequest.getLocation(), "/this");
            this.assertEquals(clientRequest.getVersion(), "HTTP/1.0");
            this.assertNull(clientRequest.getProperty(" ok"));
            this.assertEquals(clientRequest.getProperty("blah").getValue(), "ok");
        }
    }
}

