/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.minnow2600.service;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.device.array.minnow2600.io.ChannelToken;
import com.sun.jade.device.array.minnow2600.io.ChannelTokenList;
import com.sun.jade.device.array.minnow2600.io.ControllerToken;
import com.sun.jade.device.array.minnow2600.io.DiskToken;
import com.sun.jade.device.array.minnow2600.io.DiskTokenList;
import com.sun.jade.device.array.minnow2600.io.LogicalDiskToken;
import com.sun.jade.device.array.minnow2600.io.LogicalDiskTokenList;
import com.sun.jade.device.array.minnow2600.io.Minnow2600ChannelReporter;
import com.sun.jade.device.array.minnow2600.io.Minnow2600ControllerReporter;
import com.sun.jade.device.array.minnow2600.io.Minnow2600DiskReporter;
import com.sun.jade.device.array.minnow2600.io.Minnow2600LogicalDiskReporter;
import com.sun.jade.device.array.minnow2600.io.Minnow2600SystemReporter;
import com.sun.jade.device.array.minnow2600.io.PortReporter;
import com.sun.jade.device.array.minnow2600.io.SysToken;
import com.sun.jade.device.array.minnow2600.service.Minnow2600Con;
import com.sun.jade.device.array.minnow2600.service.Minnow2600MFImpl;
import com.sun.jade.device.array.minnow2600.util.MinnowWWN;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.logic.wbem.ReportGenerator;
import java.util.Properties;
import java.util.Vector;

public class Minnow2600ReportGenerator
implements ReportGenerator {
    private Properties props;
    private String systemName;
    private String hostIP;
    private SysToken sysToken;
    private String systemWWN;
    private Minnow2600MFImpl mf;
    private PortReporter portWWNReporter;
    private static final String PING = "ping ";
    private static final String REPORT_OK = "OK";
    private static final String REPORT_FAIL = "FAILURE";
    private static final String FULL_REDUNDANCY = "full";
    private static final String DEGRADED_REDUNDANCY = "degraded";
    private static final String LOST_REDUNDANCY = "lost";
    private static final String PCU_TYPE_NAME = "powerUnit";
    private static final String LOOP_TYPE_NAME = "loopCard";
    private static final String FAN_TYPE_NAME = "fan";
    private static final String DRIVE_TYPE_NAME = "diskDrive";
    private static final String VOLUME_TYPE_NAME = "volume";
    private static final String BATTERY_TYPE_NAME = "battery";
    private static final String CONTROLLER_TYPE_NAME = "controller";
    private static final int CONTROLLER = 1;
    private static final int PCU = 2;
    private static final int LOOP = 3;
    private static final int FAN = 4;
    private static final int DRIVE = 5;
    private static final int TEMPSENSOR = 6;
    private static final int VOLUME = 7;
    private static final int MIDPLANE = 8;
    private static final int FIBREPORT = 9;
    private static final int BATTERY = 10;
    private static final int NUM_6120_UNIT_DRIVES = 14;
    public static final String sccs_id = "@(#)Minnow2600ReportGenerator.java\t1.0 11/16/02 SMI";

    public Minnow2600ReportGenerator(Properties properties, Minnow2600MFImpl minnow2600MFImpl) {
        this.props = properties;
        this.hostIP = this.props.getProperty("ip");
        this.systemName = MinnowWWN.getWWN(this.hostIP);
        this.mf = minnow2600MFImpl;
    }

    public String checkStatus() {
        Minnow2600Con minnow2600Con = new Minnow2600Con();
        boolean bl = minnow2600Con.checkConnectionStatus(this.hostIP);
        String string = REPORT_OK;
        if (!bl && !this.checkEthernetConnection(this.hostIP)) {
            string = REPORT_FAIL;
        }
        return string;
    }

    private boolean checkEthernetConnection(String string) {
        try {
            CommandExec commandExec = new CommandExec(PING + string);
            commandExec.exec();
            commandExec.getReturnValue();
            String string2 = commandExec.getStandardOutput();
            string2 = string2.trim();
            String string3 = commandExec.getErrorOutput();
            string3 = string3.trim();
            String string4 = string2 + string3;
            return string4.endsWith("alive");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String generateReport() {
        if (this.mf != null && this.mf.isReserved()) {
            return "<report ReturnCode=\"FAILURE\">\n<exception Reason=\"Service\"/></report>\n";
        }
        String string = this.checkStatus();
        if (string.equals(REPORT_FAIL)) {
            String string2 = "<report ReturnCode=\"FAILURE\">\n<exception Reason=\"Lost Comm\"/></report>\n";
            return string2;
        }
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", REPORT_OK);
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("model");
        deviceClass2.setProperty("schema", "CIM2.5");
        deviceClass2.setProperty("view", "system");
        deviceClass2.setProperty("type", "minnow2600");
        deviceClass2.setProperty("prefix", "StorEdge2600");
        deviceClass2.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass3 = deviceClass2.newSubInstance();
        Minnow2600SystemReporter minnow2600SystemReporter = new Minnow2600SystemReporter(this.hostIP);
        String string3 = minnow2600SystemReporter.getInfo();
        this.sysToken = minnow2600SystemReporter.createSysToken(string3);
        deviceClass3.setClassName("SystemView");
        Minnow2600ControllerReporter minnow2600ControllerReporter = new Minnow2600ControllerReporter(this.hostIP);
        String string4 = minnow2600ControllerReporter.getInfo();
        string4 = string4.trim();
        int n = 0;
        while ((string4 == null || string4.length() == 0) && n < 5) {
            ++n;
            int n2 = 0;
            while (n2 < 10000000) {
                ++n2;
            }
            string4 = minnow2600ControllerReporter.getInfo();
        }
        ControllerToken controllerToken = minnow2600ControllerReporter.createControllerToken(string4);
        DeviceClass deviceClass4 = deviceClass3.newSubInstance();
        this.resolveCluster(deviceClass4, controllerToken);
        String string5 = null;
        int n3 = 1;
        while (n3 <= 1) {
            DeviceClass deviceClass5 = deviceClass4.newSubInstance();
            this.resolveUnitaryComputerSystem(deviceClass5, n3, this.hostIP);
            string5 = "Minnow3";
            DeviceClass deviceClass6 = deviceClass5.newSubInstance();
            this.resolveSCSIController(deviceClass6, controllerToken);
            int n4 = 0;
            ChannelTokenList channelTokenList = null;
            Minnow2600ChannelReporter minnow2600ChannelReporter = new Minnow2600ChannelReporter(this.hostIP);
            String string6 = minnow2600ChannelReporter.getChannel();
            n4 = minnow2600ChannelReporter.getChannelTokenNum(string6);
            channelTokenList = minnow2600ChannelReporter.createChannelTokenList(string6);
            this.portWWNReporter = new PortReporter(this.hostIP);
            int n5 = 0;
            while (n5 < n4) {
                DeviceClass deviceClass7 = deviceClass5.newSubInstance();
                this.resolveChannel(deviceClass7, n5, channelTokenList);
                ++n5;
            }
            int n6 = 0;
            LogicalDiskTokenList logicalDiskTokenList = null;
            Minnow2600LogicalDiskReporter minnow2600LogicalDiskReporter = new Minnow2600LogicalDiskReporter(this.hostIP);
            String string7 = minnow2600LogicalDiskReporter.getLogicalDisk();
            n6 = minnow2600LogicalDiskReporter.getLogicalDiskTokenNum(string7);
            logicalDiskTokenList = minnow2600LogicalDiskReporter.createLogicalDiskTokenList(string7);
            int n7 = 0;
            while (n7 < n6) {
                DeviceClass deviceClass8 = deviceClass5.newSubInstance();
                this.resolveLogicalDiskDrive(deviceClass8, n7, logicalDiskTokenList);
                ++n7;
            }
            int n8 = 0;
            DiskTokenList diskTokenList = null;
            Minnow2600DiskReporter minnow2600DiskReporter = new Minnow2600DiskReporter(this.hostIP);
            String string8 = minnow2600DiskReporter.getDisk();
            n8 = minnow2600DiskReporter.getDiskTokenNum(string8);
            diskTokenList = minnow2600DiskReporter.createDiskTokenList(string8);
            int n9 = 0;
            while (n9 < n8) {
                DeviceClass deviceClass9 = deviceClass5.newSubInstance();
                this.resolveDiskDrive(deviceClass9, n9, diskTokenList);
                ++n9;
            }
            ++n3;
        }
        return deviceClass.toXML();
    }

    private void addPhysicalClasses(DeviceClass deviceClass, String string) {
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        DeviceClass deviceClass3 = deviceClass2.newSubInstance();
        DeviceClass deviceClass4 = deviceClass2.newSubInstance();
        DeviceClass deviceClass5 = deviceClass2.newSubInstance();
    }

    private void resolveCluster(DeviceClass deviceClass, ControllerToken controllerToken) {
        int n = 0;
        Minnow2600LogicalDiskReporter minnow2600LogicalDiskReporter = new Minnow2600LogicalDiskReporter(this.hostIP);
        String string = minnow2600LogicalDiskReporter.getLogicalDisk();
        n = minnow2600LogicalDiskReporter.getLogicalDiskTokenNum(string);
        Integer n2 = new Integer(n);
        int n3 = 0;
        Minnow2600DiskReporter minnow2600DiskReporter = new Minnow2600DiskReporter(this.hostIP);
        String string2 = minnow2600DiskReporter.getDisk();
        n3 = minnow2600DiskReporter.getDiskTokenNum(string2);
        Integer n4 = new Integer(n3);
        int n5 = 0;
        Minnow2600ChannelReporter minnow2600ChannelReporter = new Minnow2600ChannelReporter(this.hostIP);
        String string3 = minnow2600ChannelReporter.getChannel();
        n5 = minnow2600ChannelReporter.getChannelTokenNum(string3);
        Integer n6 = new Integer(n5);
        int n7 = 0;
        int n8 = 0;
        n7 = n3 / 12;
        n8 = n3 % 12;
        if (n8 > 0) {
            ++n7;
        }
        Integer n9 = new Integer(n7);
        int n10 = 0;
        n10 = 2 * n7;
        Integer n11 = new Integer(n10);
        int n12 = controllerToken.getNum();
        Integer n13 = new Integer(n12);
        deviceClass.setClassName("Cluster");
        deviceClass.setProperty("Name", this.systemName);
        deviceClass.setProperty("CreationClassName", "StorEdge2600_Cluster");
        deviceClass.setProperty("HasVolumes", "true");
        deviceClass.setProperty("InterconnectAddress", this.hostIP);
        deviceClass.setProperty("User", "Not Specified");
        deviceClass.setProperty("UnitCount", n9.toString());
        deviceClass.setProperty("CtlrCount", n13.toString());
        deviceClass.setProperty("MidplaneCount", "1");
        deviceClass.setProperty("FruCount", "14");
        deviceClass.setProperty("PortCount", n6.toString());
        deviceClass.setProperty("FibrePortCount", n6.toString());
        deviceClass.setProperty("LoopCount", "0");
        deviceClass.setProperty("PowerCount", n11.toString());
        deviceClass.setProperty("VolumeCount", n2.toString());
        deviceClass.setProperty("DiskCount", n4.toString());
        deviceClass.setProperty("Description", this.sysToken.getRevision());
        deviceClass.setProperty("Status", REPORT_OK);
    }

    private void resolveUnitaryComputerSystem(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("CreationClassName", "StorEdge2600_UnitaryComputerSystem");
        deviceClass.setProperty("Status", REPORT_OK);
        deviceClass.setProperty("Name", this.sysToken.getProduct());
        deviceClass.setProperty("IdentifyingDescriptions", this.sysToken.getSerialnum());
        deviceClass.setProperty("Description", this.sysToken.getRevision());
    }

    private void addLogicalDeviceInternals(DeviceClass deviceClass, int n, String string, int n2) {
        String string2;
        String string3 = "fru";
        switch (n2) {
            case 1: {
                string2 = "StorEdge2600_SCSIController";
                break;
            }
            case 2: {
                string2 = "StorEdge2600_UninterruptiblePowerSupply";
                break;
            }
            case 10: {
                string2 = "StorEdge2600_Battery";
                break;
            }
            case 3: {
                string2 = "StorEdge2600_LoopController";
                break;
            }
            case 5: {
                string2 = "StorEdge2600_DiskDrive";
                break;
            }
            case 6: {
                string2 = "StorEdge2600_TemperatureSensor";
                break;
            }
            case 8: {
                string2 = "StorEdge2600_MidPlaneDevice";
                break;
            }
            case 7: {
                string2 = "StorEdge2600_VolumeSet";
                string3 = "vol";
                break;
            }
            case 9: {
                string2 = "StorEdge2600_FibrePort";
                string3 = "port";
                break;
            }
            default: {
                return;
            }
        }
        String string4 = "ready";
        String string5 = "enabled";
        deviceClass.setProperty("SystemName", this.systemName);
        if (n2 == 10) {
            deviceClass.setProperty("DeviceID", string + "bat");
            deviceClass.setProperty("REF", string + "bat");
        } else {
            deviceClass.setProperty("DeviceID", string);
            deviceClass.setProperty("REF", string);
        }
        if (n2 == 7) {
            deviceClass.setProperty("Name", VOLUME_TYPE_NAME);
        } else if (n2 == 10) {
            deviceClass.setProperty("Name", BATTERY_TYPE_NAME);
        } else {
            deviceClass.setProperty("Name", string + "Type");
        }
        deviceClass.setProperty("CreationClassName", string2);
        deviceClass.setProperty("SystemCreationClassName", "StorEdge2600_Cluster");
        deviceClass.setProperty("Status", this.convertToCIMStatus(string4));
        deviceClass.setProperty("StatusInfo", this.convertToCIMStatusInfo(string5));
        if (n2 == 7) {
            deviceClass.setProperty("Availability", this.convertToCIMAvailability(string4));
        } else {
            deviceClass.setProperty("Availability", this.convertToCIMAvailability(string4, string5));
        }
        deviceClass.setProperty("PowerManagementSupported", "false");
    }

    private void resolveSCSIController(DeviceClass deviceClass, ControllerToken controllerToken) {
        boolean bl = false;
        deviceClass.setClassName("SCSIController");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", controllerToken.getName());
        deviceClass.setProperty("CreationClassName", "StorEdge2600_SCSIController");
        deviceClass.setProperty("SystemCreationClassName", "StorEdge2600_Cluster");
        deviceClass.setProperty("DeviceID", controllerToken.getID());
        deviceClass.setProperty("REF", controllerToken.getID());
        String string = controllerToken.getStatus();
        String string2 = controllerToken.getStatus();
        String string3 = this.convertToCIMStatus(string);
        String string4 = "2";
        if (REPORT_OK.equalsIgnoreCase(string3)) {
            string4 = "3";
        } else if ("Error".equalsIgnoreCase(string3)) {
            string4 = "4";
        }
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("StatusInfo", string4);
        deviceClass.setProperty("CtlrRole", "Primary");
        deviceClass.setProperty("CtlrPartnerId", controllerToken.getSecondarySN());
        deviceClass.setProperty("CtlrCpuDesc", controllerToken.getCpu());
        deviceClass.setProperty("CtlrFwVer", controllerToken.getFwRev());
    }

    private void resolveChannel(DeviceClass deviceClass, int n, ChannelTokenList channelTokenList) {
        Vector vector = channelTokenList.getList();
        ChannelToken channelToken = (ChannelToken)vector.get(n);
        deviceClass.setClassName("Channel");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", "Channel" + n);
        deviceClass.setProperty("CreationClassName", "StorEdge2600_FibreChannel");
        deviceClass.setProperty("SystemCreationClassName", "StorEdge2600_Cluster");
        deviceClass.setProperty("DeviceID", channelToken.getId());
        deviceClass.setProperty("Status", REPORT_OK);
        deviceClass.setProperty("StatusInfo", "3");
        deviceClass.setProperty("Type", channelToken.getType());
        deviceClass.setProperty("Media", channelToken.getMedia());
        deviceClass.setProperty("ChannelSpeed", channelToken.getChannelSpeed());
        deviceClass.setProperty("Width", channelToken.getWidth());
        deviceClass.setProperty("Pid", channelToken.getPid());
        deviceClass.setProperty("Sid", channelToken.getSid());
        if (channelToken.getType().equals("Host")) {
            deviceClass.setProperty("PortWWN", this.portWWNReporter.getPortWWN(channelToken.getId()));
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ProtocolEndpoint");
            deviceClass2.setProperty("Name", this.portWWNReporter.getPortWWN(channelToken.getId()));
            deviceClass2.setProperty("NameFormat", "WWN");
            deviceClass2.setProperty("ProtocolType", "Fibre Channel");
        } else {
            deviceClass.setProperty("PortWWN", "NA");
        }
    }

    private void resolveDiskDrive(DeviceClass deviceClass, int n, DiskTokenList diskTokenList) {
        Vector vector = diskTokenList.getList();
        DiskToken diskToken = (DiskToken)vector.get(n);
        deviceClass.setClassName("DiskDrive");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", "disk" + n);
        deviceClass.setProperty("CreationClassName", "StorEdge2600_DiskDrive");
        deviceClass.setProperty("SystemCreationClassName", "StorEdge2600_Cluster");
        deviceClass.setProperty("DeviceID", diskToken.getElementID());
        String string = diskToken.getStatus();
        String string2 = diskToken.getStatus();
        String string3 = this.convertToCIMStatus(string);
        String string4 = "2";
        if (REPORT_OK.equalsIgnoreCase(string3)) {
            string4 = "3";
        } else if ("SERVICE".equalsIgnoreCase(string3)) {
            string4 = "3";
        } else if ("Error".equalsIgnoreCase(string3)) {
            string4 = "4";
        }
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("StatusInfo", string4);
        deviceClass.setProperty("ChannelId", diskToken.getChannel());
        deviceClass.setProperty("TargetId", diskToken.getId());
        deviceClass.setProperty("Capacity", diskToken.getSize());
        deviceClass.setProperty("FirmwareRev", diskToken.getRevision());
        deviceClass.setProperty("Vendor", diskToken.getVendor());
        deviceClass.setProperty("Model", diskToken.getModel());
        deviceClass.setProperty("logId", diskToken.getlogicalDiskId());
    }

    private void resolveLogicalDiskDrive(DeviceClass deviceClass, int n, LogicalDiskTokenList logicalDiskTokenList) {
        Vector vector = logicalDiskTokenList.getList();
        LogicalDiskToken logicalDiskToken = (LogicalDiskToken)vector.get(n);
        deviceClass.setClassName("LogicalDisk");
        deviceClass.setProperty("SystemName", this.systemName);
        deviceClass.setProperty("Name", logicalDiskToken.getId());
        deviceClass.setProperty("CreationClassName", "StorEdge2600_LogicalDisk");
        deviceClass.setProperty("SystemCreationClassName", "StorEdge2600_Cluster");
        deviceClass.setProperty("DeviceID", logicalDiskToken.getName());
        String string = logicalDiskToken.getStatus();
        String string2 = logicalDiskToken.getStatus();
        String string3 = this.convertToCIMStatus(string);
        String string4 = "2";
        if (REPORT_OK.equalsIgnoreCase(string3)) {
            string4 = "3";
        } else if ("DEGRADED".equalsIgnoreCase(string3)) {
            string4 = "3";
        } else if ("SERVICE".equalsIgnoreCase(string3)) {
            string4 = "3";
        } else if ("Error".equalsIgnoreCase(string3)) {
            string4 = "4";
        }
        deviceClass.setProperty("Status", string3);
        deviceClass.setProperty("StatusInfo", string4);
        deviceClass.setProperty("RaidLevel", logicalDiskToken.getRaid());
        deviceClass.setProperty("SpareDiskNum", logicalDiskToken.getSpareDiskNum());
        deviceClass.setProperty("FailedDiskNum", logicalDiskToken.getFailedNum());
        deviceClass.setProperty("TotalDiskNum", logicalDiskToken.getTotalDiskNum());
        deviceClass.setProperty("Assignment", logicalDiskToken.getAssignment());
        deviceClass.setProperty("Capacity", logicalDiskToken.getSize());
    }

    private String convertToCIMStatus(String string) {
        String string2 = "Unknown";
        try {
            if (string.equalsIgnoreCase("ready") || string.equalsIgnoreCase("mounted") || string.equalsIgnoreCase("online") || string.equalsIgnoreCase("Good")) {
                string2 = REPORT_OK;
            } else if (string.equalsIgnoreCase("fault") || string.equalsIgnoreCase("unmounted") || string.equalsIgnoreCase("Bad")) {
                string2 = "Error";
            } else if (string.equalsIgnoreCase("offline") || string.equalsIgnoreCase("deleted")) {
                string2 = "NonRecover";
            } else if (string.equalsIgnoreCase("Degraded")) {
                string2 = "Degraded";
            } else if (string.equalsIgnoreCase("Rebuilding") || string.equalsIgnoreCase("Rebuild")) {
                string2 = "Service";
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    private String convertToCIMStatusInfo(String string) {
        int n = 2;
        try {
            if (string.equalsIgnoreCase("enabled") || string.equalsIgnoreCase("normal")) {
                n = 3;
            } else if (string.equalsIgnoreCase("disabled") || string.equalsIgnoreCase("notInstalled")) {
                n = 4;
            } else if (string.equalsIgnoreCase("other") || string.equalsIgnoreCase("fault")) {
                n = 1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Integer.toString(n);
    }

    private String convertToCIMAvailability(String string, String string2) {
        int n;
        int n2 = 2;
        String string3 = this.convertToCIMStatus(string);
        String string4 = this.convertToCIMStatusInfo(string2);
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            n = 2;
        }
        try {
            if (n == 4 || string3.equals("NonRecover")) {
                n2 = 8;
            } else if (string3.equals(REPORT_OK)) {
                n2 = 3;
            } else if (string3.equals("Error")) {
                if (n == 3 || n == 2) {
                    n2 = 10;
                } else if (n == 3) {
                    n2 = 8;
                }
            } else {
                n2 = 11;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Integer.toString(n2);
    }

    private String convertToCIMAvailability(String string) {
        int n = 2;
        String string2 = this.convertToCIMStatus(string);
        try {
            n = string2.equals(REPORT_OK) ? 3 : (string2.equals("Error") ? 8 : (string2.equals("NonRecover") ? 11 : 11));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Integer.toString(n);
    }

    private String truncate(String string) {
        String string2 = null;
        try {
            string2 = string.substring(0, string.indexOf("."));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return string;
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("ip", "172.20.67.229");
        Minnow2600ReportGenerator minnow2600ReportGenerator = new Minnow2600ReportGenerator(properties, null);
        String string = minnow2600ReportGenerator.generateReport();
        System.out.println(string);
    }
}

