/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.minnow2600.service;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.apps.discovery.Probe;
import com.sun.jade.device.array.minnow2600.util.MinnowCLICommand;
import com.sun.jade.device.array.minnow2600.util.MinnowCommands;
import com.sun.jade.device.array.minnow2600.util.MinnowSerialNumber;
import com.sun.jade.device.array.minnow2600.util.MinnowWWN;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;

public class Minnow2600Probe
implements Probe,
MinnowCommands {
    private static String probeType = "minnow2600";
    private static String[] propertyNames = new String[]{"ip"};
    private static String SCCLI = "sccli ";
    private static String MINNOW = "minnow2600";
    private static int TIMEOUT = 5000;
    private static int RETRY_TIMEOUT = 2000;
    private String hostIP;
    public static final String sccs_id = "@(#)Minnow2600Probe.java\t1.0 05/24/02 SMI";

    public Properties getBaseProperties(String string) {
        String string2 = MinnowCLICommand.getCommand();
        if (string2 == null) {
            return null;
        }
        CommandExec commandExec = new CommandExec(string2 + string + " inquiry");
        try {
            commandExec.exec();
            int n = commandExec.getReturnValue((long)TIMEOUT);
        }
        catch (InterruptedException interruptedException) {
            try {
                commandExec.exec();
                int n = commandExec.getReturnValue((long)(TIMEOUT + RETRY_TIMEOUT));
            }
            catch (Exception exception) {
                Report.info.log((Object)("Probe timeout for ip " + string));
                return null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            Report.info.log((Object)("Probe encountered illegal state for ip " + string));
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        String string3 = commandExec.getStandardOutput();
        string3 = string3.trim();
        String string4 = commandExec.getErrorOutput();
        string4 = string4.trim();
        String string5 = string3 + string4;
        CommandExec commandExec2 = new CommandExec(string2 + string + " show port-wwn");
        try {
            commandExec2.exec();
            int n = commandExec2.getReturnValue((long)TIMEOUT);
        }
        catch (InterruptedException interruptedException) {
            try {
                commandExec2.exec();
                int n = commandExec2.getReturnValue((long)(TIMEOUT + RETRY_TIMEOUT));
            }
            catch (Exception exception) {
                Report.info.log((Object)("Probe timeout for ip " + string));
                return null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            Report.info.log((Object)("Probe encountered illegal state for ip " + string));
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        String string6 = commandExec2.getStandardOutput();
        string6 = string6.trim();
        String string7 = commandExec2.getErrorOutput();
        string7 = string7.trim();
        String string8 = string6 + string7;
        if (string5.startsWith("sccli: selected")) {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            properties.setProperty("ipno", string);
            properties.setProperty("type", MINNOW);
            this.addAdditionalProperties(string, string5, properties);
            if (string8.startsWith("sccli: selected")) {
                this.addWWNProperties(string, string8, properties);
            }
            return properties;
        }
        return null;
    }

    public Iterator probe(String string) {
        Object object;
        int n = string.indexOf(47);
        int n2 = 1;
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(0, n);
            object = string.substring(n + 1);
            n2 = Integer.parseInt((String)object);
        }
        object = null;
        try {
            object = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        byte[] byArray = ((InetAddress)object).getAddress();
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        int n3 = 0;
        while (n3 < n2) {
            String string3 = this.getIpAddr(byArray);
            Properties properties = this.getBaseProperties(string3);
            if (properties != null) {
                arrayList.add(properties);
            }
            this.nextIpAddr(byArray);
            ++n3;
        }
        return arrayList.iterator();
    }

    private void addAdditionalProperties(String string, String string2, Properties properties) {
        Pattern pattern = Pattern.compile("\n");
        String[] stringArray = pattern.split(string2);
        int n = 0;
        while (n < stringArray.length) {
            Pattern pattern2;
            String[] stringArray2;
            if (n != 0 && (stringArray2 = (pattern2 = Pattern.compile(":")).split(stringArray[n])).length == 2) {
                String string3 = stringArray2[0].trim();
                if ("Serial Number".equalsIgnoreCase(string3)) {
                    string3 = "SerialNumber";
                    MinnowSerialNumber.setSerialNumber(string, stringArray2[1].trim());
                }
                if ("IP Address".equalsIgnoreCase(string3)) {
                    string3 = "ipAddress";
                }
                properties.setProperty(string3, stringArray2[1].trim());
            }
            ++n;
        }
    }

    private void addWWNProperties(String string, String string2, Properties properties) {
        Pattern pattern = Pattern.compile("\n");
        String[] stringArray = pattern.split(string2);
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < stringArray.length) {
            Pattern pattern2;
            String[] stringArray2;
            if (n != 0 && (stringArray2 = (pattern2 = Pattern.compile("\\s")).split(stringArray[n])).length > 1 && ("0".equalsIgnoreCase(string4 = stringArray2[1].trim()) || "1".equalsIgnoreCase(string4) || "4".equalsIgnoreCase(string4) || "5".equalsIgnoreCase(string4))) {
                string3 = "WWN";
                String string5 = stringArray2[stringArray2.length - 1].trim();
                String string6 = string5.substring(0, 1);
                System.out.println("sub_wwn1 is" + string6);
                String string7 = string5.substring(2, 10);
                String string8 = string5.substring(11, string5.length());
                String string9 = string6 + "0" + string7 + "0" + string8;
                MinnowWWN.setWWN(string, string9);
                properties.setProperty(string3, string9);
                break;
            }
            ++n;
        }
    }

    private String getIpAddr(byte[] byArray) {
        return "" + (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    private void nextIpAddr(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        if (n == 255) {
            byArray[3] = 0;
            int n2 = byArray[2] & 0xFF;
            byArray[2] = n2 == 255 ? (byte)0 : (byte)(++n2);
        } else {
            byArray[3] = (byte)(++n);
        }
    }

    public String getProbeType() {
        return probeType;
    }

    public String[] getProbeProperties() {
        return propertyNames;
    }

    public static void main(String[] stringArray) {
        Minnow2600Probe minnow2600Probe = new Minnow2600Probe();
        Iterator iterator = minnow2600Probe.probe(stringArray[0]);
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            properties.list(System.out);
        }
        System.exit(0);
    }
}

