/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.minnow2600.service;

import com.sun.jade.device.array.minnow2600.diags.Minnow2600Test;
import com.sun.jade.device.array.minnow2600.service.Minnow2600Model;
import com.sun.jade.device.array.minnow2600.service.Minnow2600ReportGenerator;
import com.sun.jade.device.array.minnow2600.util.MinnowWWN;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.util.Properties;

public class Minnow2600MFImpl
extends AbstractMF
implements Minnow2600Model {
    private String wwn;
    private String ip;
    private String ipno;
    private InetAddress iaddr;
    private Properties p;
    public static String CIM_CLASS_NAME = "StorEdge2600_Cluster";
    private boolean reserved;

    public Minnow2600MFImpl(Properties properties) {
        super(properties);
        this.p = properties;
        this.ip = this.resolveIP(properties);
        this.ipno = properties.getProperty("ipno");
        String string = properties.getProperty("type");
        this.wwn = MinnowWWN.getWWN(this.ip);
        if (this.wwn == null) {
            Report.debug.log((Object)("WWN not yet set for ip = " + this.ip));
        }
        if (!"minnow2600".equalsIgnoreCase(string)) {
            throw new IllegalArgumentException("Expected minnow2600, received: " + string);
        }
        this.setDeviceReport(new Minnow2600ReportGenerator(properties, this));
        this.addDiagnosticTest(new Minnow2600Test(this.ip));
        this.updateDeviceConfig();
    }

    public String getClassName() {
        return CIM_CLASS_NAME;
    }

    public String getName() {
        return this.wwn;
    }

    public String getIPAddr() {
        return this.ip;
    }

    public String getIPNum() {
        return this.ipno;
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        return new LocalizedString("Sun StorEdge 3510");
    }

    protected void shutdown() {
    }

    public synchronized boolean isReserved() {
        return this.reserved;
    }

    public synchronized boolean reserve() {
        if (this.reserved) {
            return false;
        }
        this.reserved = true;
        return true;
    }

    public synchronized void release() {
        this.reserved = false;
    }
}

