/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.minnow2600.diags;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.array.minnow2600.diags.Messages;
import com.sun.jade.device.array.minnow2600.io.MinnowTestManager;
import com.sun.jade.device.array.minnow2600.io.MinnowTestPattern;
import com.sun.jade.device.array.minnow2600.io.MinnowTestToken;
import com.sun.jade.device.array.minnow2600.service.Minnow2600MFImpl;
import com.sun.jade.device.array.minnow2600.util.MinnowCLICommand;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class Minnow2600TestExecutable
extends TestExecutableImpl {
    static final String TEST_NAME = "Sun StorEdge 2600 Test";
    static final String TEST_EXECUTABLE_DIRECTORY = "test.directory";
    static final String TEST_PASSED = "\"Test Passed\"";
    static final int CRITICAL_PATTERN = 0;
    static final int USER_PATTERN = 1;
    static final int ALL_PATTERN = 2;
    static final int POLL_INTERVAL = 20000;
    private boolean abort_status = false;
    private InetAddress hostAddress = null;
    private String passwd;
    private String minnowip;
    private DiagnosticResult result;
    private static final String TYPE = "minnow2600";
    private int patternType = 0;
    private String patternMode;
    private int xferSize;
    private int numberOfPasses;
    private int patternInt;
    private String testPattern = "0x5e5e5e5e";
    private String stopOption;
    private String compareOption;
    private int chanId;
    private int targetId;
    private int payload;
    private CommandExec command = null;
    private static final Localizer msgs = Messages.getLocalizer();
    private MinnowTestManager mtm = null;
    private String finished_status = null;
    private Minnow2600MFImpl mf;
    public static final String sccs_id = "@(#)Minnow2600TestExecutable.java\t";

    public Minnow2600TestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
        Object object = referenceForMSE.getDeviceService();
        if (object instanceof Minnow2600MFImpl) {
            this.mf = (Minnow2600MFImpl)object;
        }
        Report.debug.log("Minnow2600Diags", (Object)("new Minnow2600TestExecutable: mse     =" + referenceForMSE));
        Report.debug.log("Minnow2600Diags", (Object)("new Minnow2600TestExecutable: setting =" + diagnosticSetting));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        block26: {
            block29: {
                block28: {
                    block27: {
                        this.result = diagnosticResult;
                        this.parseSettings();
                        Report.trace.log("Minnow2600Diags", (Object)"runTest");
                        if (this.mf != null && !this.mf.reserve()) {
                            diagnosticResult.setFinalResults(TestState.FAILED, msgs.getString("failure.info"));
                            return;
                        }
                        try {
                            try {
                                if (!this.parseLocalSettings()) {
                                    Object var14_2 = null;
                                    if (this.mf == null) return;
                                    this.mf.release();
                                    return;
                                }
                                Report.debug.log("Minnow2600Diags", (Object)(" WRB Run Test: mse     =" + this.mse));
                                Report.debug.log("Minnow2600Diags", (Object)(" WRB Run Test: setting =" + this.setting));
                                this.minnowip = this.hostAddress.getHostAddress();
                                Properties properties = DevInfo.getDeviceProperties((String)TYPE);
                                String string = properties.getProperty(TEST_EXECUTABLE_DIRECTORY);
                                String string2 = MinnowCLICommand.getCommand();
                                try {
                                    int n;
                                    int n2;
                                    short s;
                                    String string3;
                                    boolean bl = true;
                                    if (!bl) {
                                        diagnosticResult.setFinalResults(TestState.FAILED, msgs.getString("wrbtest.info.alreadyrun"));
                                        this.waitForResult(this.mtm);
                                        break block26;
                                    }
                                    this.mtm = new MinnowTestManager(this.minnowip, 10, this.chanId, this.targetId);
                                    if (this.patternType == 1) {
                                        string3 = string2 + " " + this.minnowip + " " + "diag buffer-test" + " -chan " + this.chanId + " -targ " + this.targetId + " -pay " + this.testPattern + " -size " + this.xferSize + " -itt " + this.numberOfPasses + " -com " + this.compareOption + " -stop " + this.stopOption;
                                        this.wrbTest(string3, this.testPattern);
                                        this.waitForResult(this.mtm);
                                        if (this.finished_status.equals("diag_aborted_user") || this.abort_status) {
                                            diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("wrbtest.info.abort"));
                                        } else {
                                            if (!this.finished_status.equals("diag_complete_noerr")) {
                                                diagnosticResult.setFinalResults(TestState.FAILED, msgs.getFormattedString("wrbtest.info.failed", new Object[]{this.testPattern}));
                                                break block27;
                                            }
                                            diagnosticResult.setFinalResults(TestState.PASSED, msgs.getString("wrbtest.info.pass"));
                                        }
                                    }
                                    if (this.patternType == 0) {
                                        string3 = "3510 write read buffer test for critical patterns is running";
                                        diagnosticResult.addTestResults(string3);
                                        diagnosticResult.update();
                                        s = 1;
                                        diagnosticResult.setPercentComplete(s);
                                        diagnosticResult.update();
                                        n2 = Array.getLength(MinnowTestPattern.CRITICAL_TEST_PATTERNS);
                                        n = 100 / n2;
                                        int n3 = 0;
                                        block6: while (n3 < n2) {
                                            this.testPattern = MinnowTestPattern.CRITICAL_TEST_PATTERNS[n3];
                                            String string4 = string2 + " " + this.minnowip + " " + "diag buffer-test" + " -chan " + this.chanId + " -targ " + this.targetId + " -pay " + this.testPattern + " -size " + this.xferSize + " -itt " + this.numberOfPasses + " -com " + this.compareOption + " -stop " + this.stopOption;
                                            this.wrbTest(string4, this.testPattern);
                                            this.waitForAllResult(this.mtm);
                                            if (this.finished_status.equals("diag_aborted_user") || this.abort_status) {
                                                diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("wrbtest.info.abort"));
                                                break;
                                            }
                                            if (this.finished_status.equals("diag_complete_noerr")) {
                                                diagnosticResult.addTestResults(msgs.getFormattedString("wrbtest.info.passone", new Object[]{this.testPattern}));
                                                diagnosticResult.update();
                                                s = (short)(n * (n3 + 1));
                                                diagnosticResult.setPercentComplete(s);
                                                diagnosticResult.update();
                                                int n4 = 0;
                                                while (true) {
                                                    if (n4 >= 10000000) {
                                                        ++n3;
                                                        continue block6;
                                                    }
                                                    ++n4;
                                                }
                                            }
                                            diagnosticResult.setFinalResults(TestState.FAILED, msgs.getFormattedString("wrbtest.info.failone", new Object[]{this.testPattern}));
                                            break block28;
                                        }
                                        diagnosticResult.setFinalResults(TestState.PASSED, msgs.getString("wrbtest.info.criticalpass"));
                                    }
                                    if (this.patternType != 2) break block26;
                                    string3 = "3510 write read buffer test for all patterns is running";
                                    diagnosticResult.addTestResults(string3);
                                    diagnosticResult.update();
                                    s = 0;
                                    diagnosticResult.setPercentComplete(s);
                                    diagnosticResult.update();
                                    n2 = Array.getLength(MinnowTestPattern.ALL_TEST_PATTERNS);
                                    n = 0;
                                    block8: while (n < n2) {
                                        this.testPattern = MinnowTestPattern.ALL_TEST_PATTERNS[n];
                                        String string5 = string2 + " " + this.minnowip + " " + "diag buffer-test" + " -chan " + this.chanId + " -targ " + this.targetId + " -pay " + this.testPattern + " -size " + this.xferSize + " -itt " + this.numberOfPasses + " -com " + this.compareOption + " -stop " + this.stopOption;
                                        this.wrbTest(string5, this.testPattern);
                                        this.waitForAllResult(this.mtm);
                                        if (this.finished_status.equals("diag_aborted_user") || this.abort_status) {
                                            diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("wrbtest.info.abort"));
                                            break;
                                        }
                                        if (this.finished_status.equals("diag_complete_noerr")) {
                                            diagnosticResult.addTestResults(msgs.getString("wrbtest.info.passone"));
                                            diagnosticResult.update();
                                            s = (short)(n * 10 / 26);
                                            diagnosticResult.setPercentComplete(s);
                                            diagnosticResult.update();
                                            int n5 = 0;
                                            while (true) {
                                                if (n5 >= 10000000) {
                                                    ++n;
                                                    continue block8;
                                                }
                                                ++n5;
                                            }
                                        }
                                        diagnosticResult.setFinalResults(TestState.FAILED, msgs.getFormattedString("wrbtest.info.failone", new Object[]{this.testPattern}));
                                        break block29;
                                    }
                                    diagnosticResult.setFinalResults(TestState.PASSED, msgs.getString("wrbtest.info.passall"));
                                    break block26;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    LocalizedString localizedString = new LocalizedString(exception);
                                    diagnosticResult.setFinalResults(TestState.FAILED, localizedString.toString());
                                    Object var14_6 = null;
                                    if (this.mf == null) return;
                                    this.mf.release();
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Report.error.log((Object)exception);
                                if (this.reportErrors) {
                                    diagnosticResult.addTestResults(exception.getLocalizedMessage());
                                }
                                diagnosticResult.setFinalResults(TestState.FAILED);
                                Object var14_8 = null;
                                if (this.mf == null) return;
                                this.mf.release();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_9 = null;
                            if (this.mf == null) throw throwable;
                            this.mf.release();
                            throw throwable;
                        }
                    }
                    Object var14_3 = null;
                    if (this.mf == null) return;
                    this.mf.release();
                    return;
                }
                Object var14_4 = null;
                if (this.mf == null) return;
                this.mf.release();
                return;
            }
            Object var14_5 = null;
            if (this.mf == null) return;
            this.mf.release();
            return;
        }
        Object var14_7 = null;
        if (this.mf == null) return;
        this.mf.release();
    }

    private void wrbTest(String string, String string2) throws DiagnosticException {
        try {
            Report.debug.log("Minnow2600Diags", (Object)string);
            this.command = new CommandExec(string);
            this.command.exec();
            this.command.getReturnValue();
            String string3 = this.command.getStandardOutput();
            String string4 = this.command.getErrorOutput();
            string3 = string3.trim();
            string4 = string4.trim();
            String string5 = string3 + " " + string4;
            StringBuffer stringBuffer = new StringBuffer(string5);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '<') {
                    stringBuffer = stringBuffer.replace(n, n + 1, "\t&lt;");
                }
                ++n;
            }
            string5 = stringBuffer.toString().trim();
            if (string5.trim().endsWith("OK!")) {
                this.result.addTestResults(msgs.getFormattedString("wrbtest.info.initializeok", new Object[]{string5}));
                this.result.update();
            } else {
                this.result.addTestResults(string5);
                this.result.update();
                this.result.setFinalResults(TestState.FAILED, msgs.getFormattedString("wrbtest.info.initializefail", new Object[]{string2}));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LocalizedString localizedString = new LocalizedString(exception);
            this.result.setFinalResults(TestState.FAILED, localizedString.toString());
            return;
        }
    }

    private synchronized boolean waitForAllResult(MinnowTestManager minnowTestManager) throws DiagnosticException {
        int n = 0;
        int n2 = 0;
        String string = null;
        Report.trace.log((Object)"waitForALLResult");
        MinnowTestToken minnowTestToken = null;
        minnowTestToken = new MinnowTestToken();
        do {
            if ((string = minnowTestManager.getDiagStatus()) == null) {
                do {
                    try {
                        ((Object)((Object)this)).wait(20000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((string = minnowTestManager.getDiagStatus()) == null && ++n2 < 50 && !this.abort_status);
            }
            n2 = 0;
            System.out.println("Debug: output used to create test status token:" + string + "\n");
            if (string != null) {
                minnowTestToken = minnowTestManager.getTestStatusToken(string);
            }
            try {
                ((Object)((Object)this)).wait(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
            System.out.println("Debug info, test state is :" + minnowTestManager.getTestState(minnowTestToken));
        } while (minnowTestManager.getTestState(minnowTestToken) && !this.abort_status);
        this.finished_status = MinnowTestManager.getStatus(minnowTestToken);
        return true;
    }

    private synchronized boolean waitForResult(MinnowTestManager minnowTestManager) throws DiagnosticException {
        int n = 0;
        int n2 = 0;
        String string = null;
        Report.trace.log((Object)"waitForResult");
        MinnowTestToken minnowTestToken = null;
        minnowTestToken = new MinnowTestToken();
        do {
            if ((string = minnowTestManager.getDiagStatus()) == null) {
                do {
                    try {
                        ((Object)((Object)this)).wait(20000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((string = minnowTestManager.getDiagStatus()) == null && ++n2 < 50 && !this.abort_status);
            }
            n2 = 0;
            System.out.println("Debug: output used to create test status token:" + string + "\n");
            if (string != null) {
                minnowTestToken = minnowTestManager.getTestStatusToken(string);
                short s = MinnowTestManager.getFinishedPercentage(minnowTestToken);
                System.out.println("Debug: waitForResult: percent is " + s + "\n");
                this.result.setPercentComplete(s);
                this.result.update();
                string = null;
            }
            try {
                ((Object)((Object)this)).wait(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
            System.out.println("Debug info, test state is :" + minnowTestManager.getTestState(minnowTestToken));
        } while (minnowTestManager.getTestState(minnowTestToken) && !this.abort_status);
        this.finished_status = MinnowTestManager.getStatus(minnowTestToken);
        return true;
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        Report.trace.log("Minnow2600Diags", (Object)"abortTest");
        String string = MinnowCLICommand.getCommand();
        String string2 = string + " " + this.minnowip + " diag abort -type wrbuf" + " -chan " + this.chanId + " -targ " + this.targetId;
        boolean bl = this.abort_status = this.abortWRBTest(string2);
        return bl;
    }

    private boolean abortWRBTest(String string) throws DiagnosticException {
        try {
            Report.debug.log("Minnow2600Diags", (Object)string);
            this.command = new CommandExec(string);
            this.command.exec();
            this.command.getReturnValue();
            String string2 = this.command.getStandardOutput();
            String string3 = this.command.getErrorOutput();
            string2 = string2.trim();
            string3 = string3.trim();
            String string4 = string2 + " " + string3;
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '<') {
                    stringBuffer = stringBuffer.replace(n, n + 1, "\t&lt;");
                }
                ++n;
            }
            string4 = stringBuffer.toString().trim();
            if (string4.trim().endsWith("OK!")) {
                this.result.addTestResults(msgs.getString("wrbtest.info.abortok"));
                this.result.update();
                return true;
            }
            this.result.addTestResults(msgs.getString("wrbtest.info.abortfails"));
            this.result.update();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LocalizedString localizedString = new LocalizedString(exception);
            this.result.setFinalResults(TestState.FAILED, localizedString.toString());
            return false;
        }
    }

    protected boolean parseLocalSettings() throws Exception {
        String string;
        super.parseSettings();
        TestParameter testParameter = this.setting.getTestParameter("transferSize");
        if (testParameter != null) {
            string = (String)testParameter.getCurrentValue();
            this.xferSize = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("numberOfPasses")) != null) {
            string = (String)testParameter.getCurrentValue();
            this.numberOfPasses = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("Channel ID")) != null) {
            string = (String)testParameter.getCurrentValue();
            this.chanId = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("Target ID")) != null) {
            string = (String)testParameter.getCurrentValue();
            this.targetId = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("ErrorOption")) != null) {
            if (((String)testParameter.getCurrentValue()).equals("Run on error")) {
                this.stopOption = "on_err";
            } else if (((String)testParameter.getCurrentValue()).equals("Stop on error")) {
                this.stopOption = "no_on_err";
            }
        }
        if ((testParameter = this.setting.getTestParameter("compareOption")) != null) {
            if (((String)testParameter.getCurrentValue()).equals("Compare")) {
                this.compareOption = "compare";
            } else if (((String)testParameter.getCurrentValue()).equals("No Compare")) {
                this.compareOption = "nocompare";
            }
        }
        testParameter = this.setting.getTestParameter("PatternType");
        int n = 0;
        if (testParameter != null) {
            n = testParameter.choiceValue(n);
        }
        if (n == 1 && (testParameter = this.setting.getTestParameter("UserPattern")) != null) {
            String string2 = (String)testParameter.getCurrentValue();
            this.testPattern = string2.startsWith("0x") ? string2 : "0x" + string2;
            Report.debug.log("Minnow2600Diags", (Object)("User testPattern=" + this.testPattern));
        }
        this.patternType = n;
        switch (n) {
            case 0: {
                this.patternMode = "Critical";
                break;
            }
            case 1: {
                this.patternMode = "User";
                break;
            }
            case 2: {
                this.patternMode = "All";
            }
        }
        Report.debug.log("Minnow2600Diags", (Object)("patternType=" + this.patternType));
        Report.debug.log("Minnow2600Diags", (Object)("patternMode=" + this.patternMode));
        Report.debug.log("Minnow2600Diags", (Object)("type=" + n));
        Report.debug.log("Minnow2600Diags", (Object)("testPattern=" + this.testPattern));
        Report.debug.log("Minnow2600Diags", (Object)("Loopback test mse = " + this.mse.getCIMObjectPath()));
        Report.debug.log("Minnow2600Diags", (Object)("System Name = " + this.mse.getSystemName()));
        try {
            this.hostAddress = InetAddress.getByName(DiagUtil.getIP((ReferenceForMSE)this.mse));
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Object)unknownHostException);
        }
        return true;
    }
}

