/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.minnow2600.diags;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.array.minnow2600.diags.Messages;
import com.sun.jade.device.array.minnow2600.io.MinnowLoopTestManager;
import com.sun.jade.device.array.minnow2600.io.MinnowLoopTestToken;
import com.sun.jade.device.array.minnow2600.service.Minnow2600MFImpl;
import com.sun.jade.device.array.minnow2600.util.MinnowCLICommand;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class Minnow2600LoopTestExecutable
extends TestExecutableImpl {
    static final String TEST_NAME = "Sun StorEdge 3510 Loopback Test";
    static final String TEST_EXECUTABLE_DIRECTORY = "test.directory";
    static final String TEST_PASSED = "\"Test Passed\"";
    static final int CRITICAL_PATTERN = 0;
    static final int USER_PATTERN = 1;
    static final int ALL_PATTERN = 2;
    static final int POLL_INTERVAL = 60000;
    private boolean abort_status = false;
    private InetAddress hostAddress = null;
    private String passwd;
    private String minnowip;
    private DiagnosticResult result;
    private static final String TYPE = "minnow2600";
    private int patternType = 0;
    private String patternMode;
    private int xferSize;
    private int numberOfPasses;
    private int patternInt;
    private String testPattern = "0x5e5e5e5e";
    private String stopOption;
    private String compareOption;
    private int chanId;
    private int targetId;
    private int payload;
    private CommandExec command = null;
    private static final Localizer msgs = Messages.getLocalizer();
    private MinnowLoopTestManager mtm = null;
    private String finished_status = null;
    private Minnow2600MFImpl mf;
    public static final String sccs_id = "@(#)Minnow2600LoopTestExecutable.java\t";

    public Minnow2600LoopTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
        Object object = referenceForMSE.getDeviceService();
        if (object instanceof Minnow2600MFImpl) {
            this.mf = (Minnow2600MFImpl)object;
        }
        Report.debug.log("Minnow2600Diags", (Object)("new Minnow2600LoopTestExecutable: mse     =" + referenceForMSE));
        Report.debug.log("Minnow2600Diags", (Object)("new Minnow2600LoopTestExecutable: setting =" + diagnosticSetting));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        block16: {
            this.result = diagnosticResult;
            this.parseSettings();
            Report.trace.log("Minnow2600Diags", (Object)"runTest");
            if (this.mf != null && !this.mf.reserve()) {
                diagnosticResult.setFinalResults(TestState.FAILED, " A loopback test already run the same channel id and target id, please wait for the current running test finish, then re-run the test");
                return;
            }
            try {
                try {
                    if (!this.parseLocalSettings()) {
                        Object var8_2 = null;
                        if (this.mf == null) return;
                        this.mf.release();
                        return;
                    }
                    Report.debug.log("Minnow2600Diags", (Object)(" Loopback Run Test: mse     =" + this.mse));
                    Report.debug.log("Minnow2600Diags", (Object)(" Loopback Run Test: setting =" + this.setting));
                    this.minnowip = this.hostAddress.getHostAddress();
                    Properties properties = DevInfo.getDeviceProperties((String)TYPE);
                    this.mtm = new MinnowLoopTestManager(this.minnowip, 11, this.chanId);
                    String string = properties.getProperty(TEST_EXECUTABLE_DIRECTORY);
                    String string2 = MinnowCLICommand.getCommand();
                    try {
                        boolean bl = true;
                        if (!bl) {
                            diagnosticResult.setFinalResults(TestState.FAILED, " A loopback test already run the same channel id and target id, please wait for the current running test finish, then re-run the test");
                            this.waitForResult(this.mtm);
                            break block16;
                        }
                        if (this.patternType == 1) {
                            String string3 = string2 + " " + this.minnowip + " diag loopback" + " -chan " + this.chanId + " -pay " + this.testPattern + " -size " + this.xferSize + " -mode 10bit" + " -itt " + this.numberOfPasses + " -com " + this.compareOption + " -stop " + this.stopOption;
                            this.loopTest(string3);
                        }
                        if (this.patternType == 0) {
                            // empty if block
                        }
                        if (this.patternType == 2) {
                            // empty if block
                        }
                        this.waitForResult(this.mtm);
                        if (this.finished_status.equals("diag_aborted_user") || this.abort_status) {
                            diagnosticResult.setFinalResults(TestState.STOPPED, "3510 loopback test is stopped");
                        }
                        if (this.finished_status.equals("diag_complete_noerr")) {
                            diagnosticResult.setFinalResults(TestState.PASSED, "3510 Loopback test passed");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LocalizedString localizedString = new LocalizedString(exception);
                        diagnosticResult.setFinalResults(TestState.FAILED, localizedString.toString());
                        Object var8_3 = null;
                        if (this.mf == null) return;
                        this.mf.release();
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Report.error.log((Object)exception);
                    if (this.reportErrors) {
                        diagnosticResult.addTestResults(exception.getLocalizedMessage());
                    }
                    diagnosticResult.setFinalResults(TestState.FAILED);
                    Object var8_5 = null;
                    if (this.mf == null) return;
                    this.mf.release();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (this.mf == null) throw throwable;
                this.mf.release();
                throw throwable;
            }
        }
        Object var8_4 = null;
        if (this.mf == null) return;
        this.mf.release();
    }

    private void loopTest(String string) throws DiagnosticException {
        try {
            Report.debug.log("Minnow2600Diags", (Object)string);
            this.command = new CommandExec(string);
            this.command.exec();
            this.command.getReturnValue();
            String string2 = this.command.getStandardOutput();
            String string3 = this.command.getErrorOutput();
            string2 = string2.trim();
            string3 = string3.trim();
            String string4 = string2 + " " + string3;
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '<') {
                    stringBuffer = stringBuffer.replace(n, n + 1, "\t&lt;");
                }
                ++n;
            }
            string4 = stringBuffer.toString().trim();
            if (string4.trim().endsWith("OK!")) {
                this.result.addTestResults(string4);
                this.result.update();
            } else {
                this.result.setFinalResults(TestState.FAILED, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LocalizedString localizedString = new LocalizedString(exception);
            this.result.setFinalResults(TestState.FAILED, localizedString.toString());
            return;
        }
    }

    private synchronized boolean waitForResult(MinnowLoopTestManager minnowLoopTestManager) throws DiagnosticException {
        int n = 0;
        int n2 = 0;
        String string = null;
        Report.trace.log((Object)"waitForResult");
        MinnowLoopTestToken minnowLoopTestToken = null;
        minnowLoopTestToken = new MinnowLoopTestToken();
        do {
            if ((string = minnowLoopTestManager.getDiagStatus()) == null) {
                do {
                    try {
                        ((Object)((Object)this)).wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((string = minnowLoopTestManager.getDiagStatus()) == null && ++n2 < 50 && !this.abort_status);
            }
            n2 = 0;
            System.out.println("Debug: output used to create test status token:" + string + "\n");
            try {
                ((Object)((Object)this)).wait(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
            System.out.println("Debug info, test state is :" + minnowLoopTestManager.getTestState(minnowLoopTestToken));
        } while (minnowLoopTestManager.getTestState(minnowLoopTestToken) && !this.abort_status);
        this.finished_status = MinnowLoopTestManager.getStatus(minnowLoopTestToken);
        return true;
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        Report.trace.log("Minnow2600Diags", (Object)"abortTest");
        String string = MinnowCLICommand.getCommand();
        String string2 = string + " " + this.minnowip + " diag abort -type loopback" + " -chan " + this.chanId;
        boolean bl = this.abort_status = this.abortLoopTest(string2);
        return bl;
    }

    private boolean abortLoopTest(String string) throws DiagnosticException {
        try {
            Report.debug.log("Minnow2600Diags", (Object)string);
            this.command = new CommandExec(string);
            this.command.exec();
            this.command.getReturnValue();
            String string2 = this.command.getStandardOutput();
            String string3 = this.command.getErrorOutput();
            string2 = string2.trim();
            string3 = string3.trim();
            String string4 = string2 + " " + string3;
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '<') {
                    stringBuffer = stringBuffer.replace(n, n + 1, "\t&lt;");
                }
                ++n;
            }
            string4 = stringBuffer.toString().trim();
            if (string4.trim().endsWith("OK!")) {
                this.result.setFinalResults(TestState.STOPPED, "Aborting loopback test succeed");
                return true;
            }
            this.result.addTestResults(" Can not abort the loopback test");
            this.result.update();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LocalizedString localizedString = new LocalizedString(exception);
            this.result.setFinalResults(TestState.FAILED, localizedString.toString());
            return false;
        }
    }

    protected boolean parseLocalSettings() throws Exception {
        String string;
        super.parseSettings();
        TestParameter testParameter = this.setting.getTestParameter("transferSize");
        if (testParameter != null) {
            string = (String)testParameter.getCurrentValue();
            this.xferSize = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("numberOfPasses")) != null) {
            string = (String)testParameter.getCurrentValue();
            this.numberOfPasses = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("Channel ID")) != null) {
            string = (String)testParameter.getCurrentValue();
            this.chanId = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("ErrorOption")) != null) {
            if (((String)testParameter.getCurrentValue()).equals("Run on error")) {
                this.stopOption = "on_err";
            } else if (((String)testParameter.getCurrentValue()).equals("Stop on error")) {
                this.stopOption = "no_on_err";
            }
        }
        if ((testParameter = this.setting.getTestParameter("compareOption")) != null) {
            if (((String)testParameter.getCurrentValue()).equals("Compare")) {
                this.compareOption = "compare";
            } else if (((String)testParameter.getCurrentValue()).equals("No Compare")) {
                this.compareOption = "nocompare";
            }
        }
        testParameter = this.setting.getTestParameter("PatternType");
        int n = 0;
        if (testParameter != null) {
            n = testParameter.choiceValue(n);
        }
        if (n == 1 && (testParameter = this.setting.getTestParameter("UserPattern")) != null) {
            String string2 = (String)testParameter.getCurrentValue();
            this.testPattern = string2.startsWith("0x") ? string2 : "0x" + string2;
            Report.debug.log("Minnow2600Diags", (Object)("User testPattern=" + this.testPattern));
        }
        this.patternType = n;
        switch (n) {
            case 0: {
                this.patternMode = "Critical";
                break;
            }
            case 1: {
                this.patternMode = "User";
                break;
            }
            case 2: {
                this.patternMode = "All";
            }
        }
        Report.debug.log("Minnow2600Diags", (Object)("patternType=" + this.patternType));
        Report.debug.log("Minnow2600Diags", (Object)("patternMode=" + this.patternMode));
        Report.debug.log("Minnow2600Diags", (Object)("type=" + n));
        Report.debug.log("Minnow2600Diags", (Object)("testPattern=" + this.testPattern));
        Report.debug.log("Minnow2600Diags", (Object)("Loopback test mse = " + this.mse.getCIMObjectPath()));
        Report.debug.log("Minnow2600Diags", (Object)("System Name = " + this.mse.getSystemName()));
        try {
            this.hostAddress = InetAddress.getByName(DiagUtil.getIP((ReferenceForMSE)this.mse));
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Object)unknownHostException);
        }
        return true;
    }
}

