/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Advertiser;
import com.sun.slp.Assert;
import com.sun.slp.Locator;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationAttributeVerifier;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceLocationManager;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.TemplateRegistry;
import com.sun.slp.URLAttributeVerifier;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

class SLPTemplateRegistry
extends TemplateRegistry {
    static final String SERVICE_ATTR_ID = "template-type";
    static final String DESCRIPTION_ATTR_ID = "template-description";
    static final String VERSION_ATTR_ID = "template-version";
    static final String SERVICE_URL_ATTR_ID = "template-url-syntax";
    static final String TEMPLATE_SERVICE_TYPE = "service:slp-template";
    private static TemplateRegistry registry = null;

    SLPTemplateRegistry() throws ServiceLocationException {
    }

    public ServiceLocationAttributeVerifier attributeVerifier(String string) throws ServiceLocationException {
        Assert.nonNullParameter(string, "documentURL");
        return new URLAttributeVerifier(string);
    }

    public void deregisterServiceTemplate(ServiceType serviceType, Locale locale, String string) throws ServiceLocationException {
        Assert.nonNullParameter(serviceType, "serviceType");
        Assert.nonNullParameter(locale, "languageLocale");
        ServiceURL serviceURL = this.findVersionedURL(serviceType, locale, string);
        if (serviceURL == null) {
            throw new ServiceLocationException(3, "template_not_registered", new Object[]{serviceType, string, locale});
        }
        Advertiser advertiser = ServiceLocationManager.getAdvertiser(locale);
        if (advertiser == null) {
            throw new ServiceLocationException(16, "no_advertiser", new Object[0]);
        }
        advertiser.deregister(serviceURL);
    }

    public String findTemplateURL(ServiceType serviceType, Locale locale, String string) throws ServiceLocationException {
        Assert.nonNullParameter(serviceType, "serviceType");
        Assert.nonNullParameter(locale, "languageLocale");
        ServiceURL serviceURL = this.findVersionedURL(serviceType, locale, string);
        if (serviceURL == null) {
            return null;
        }
        ServiceType serviceType2 = serviceURL.getServiceType();
        String string2 = serviceURL.toString();
        String string3 = serviceType2.getAbstractTypeName();
        if (!string3.equals(TEMPLATE_SERVICE_TYPE)) {
            throw new ServiceLocationException(2, "template_url_malformed", new Object[]{serviceURL});
        }
        int n = string2.indexOf(";template-type=");
        if (n == -1) {
            throw new ServiceLocationException(2, "template_url_malformed", new Object[]{serviceURL});
        }
        int n2 = TEMPLATE_SERVICE_TYPE.length() + 1;
        return string2.substring(n2, n);
    }

    private ServiceURL findVersionedURL(ServiceType serviceType, Locale locale, String string) throws ServiceLocationException {
        Serializable serializable;
        Enumeration enumeration;
        block10: {
            Vector vector = ServiceLocationManager.findScopes();
            enumeration = null;
            String string2 = "(template-type=" + serviceType + ")";
            if (string != null) {
                string2 = String.valueOf(string2) + "(" + VERSION_ATTR_ID + "=" + string + ")";
            }
            string2 = "(&" + string2 + ")";
            Locator locator = ServiceLocationManager.getLocator(locale);
            if (locator == null) {
                throw new ServiceLocationException(16, "no_locator", new Object[0]);
            }
            try {
                serializable = new ServiceType(TEMPLATE_SERVICE_TYPE);
                enumeration = locator.findServices((ServiceType)serializable, vector, string2);
            }
            catch (ServiceLocationException serviceLocationException) {
                if (serviceLocationException.getErrorCode() == 1) break block10;
                throw serviceLocationException;
            }
        }
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        serializable = null;
        float f = -1.0f;
        while (enumeration.hasMoreElements()) {
            ServiceURL serviceURL = (ServiceURL)enumeration.nextElement();
            String string3 = serviceURL.getURLPath();
            if (string == null) {
                String string4 = ";template-version=";
                int n = string3.indexOf(string4);
                if (n == -1 || (n = (string3 = string3.substring(n + string4.length(), string3.length())).indexOf(";")) == -1) continue;
                String string5 = string3.substring(0, n);
                float f2 = 0.0f;
                try {
                    f2 = Float.valueOf(string5).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (!(f2 > f)) continue;
                serializable = serviceURL;
                continue;
            }
            if (serializable != null) {
                throw new ServiceLocationException(20, "template_multiple", new Object[]{serviceType, string, locale});
            }
            serializable = serviceURL;
        }
        return serializable;
    }

    public void registerServiceTemplate(ServiceType serviceType, String string, Locale locale, String string2) throws ServiceLocationException {
        String string3;
        block5: {
            Assert.nonNullParameter(serviceType, "serviceType");
            Assert.nonNullParameter(string, "documentURL");
            Assert.nonNullParameter(locale, "language");
            Assert.nonNullParameter(string2, "version");
            String string4 = locale.getLanguage();
            if (string4 == null || string4.length() <= 0) {
                throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("template_lang_null", new Object[]{string}));
            }
            string3 = null;
            try {
                string3 = this.findTemplateURL(serviceType, locale, string2);
            }
            catch (ServiceLocationException serviceLocationException) {
                if (serviceLocationException.getErrorCode() == 1) break block5;
                throw serviceLocationException;
            }
        }
        if (string3 != null) {
            throw new ServiceLocationException(3, "template_already_registered", new Object[]{string, string2, locale});
        }
        Vector<ServiceLocationAttribute> vector = new Vector<ServiceLocationAttribute>();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(serviceType.toString());
        ServiceLocationAttribute serviceLocationAttribute = new ServiceLocationAttribute(SERVICE_ATTR_ID, vector2);
        vector.addElement(serviceLocationAttribute);
        vector2 = new Vector();
        vector2.addElement(string2);
        serviceLocationAttribute = new ServiceLocationAttribute(VERSION_ATTR_ID, vector2);
        vector.addElement(serviceLocationAttribute);
        ServiceURL serviceURL = new ServiceURL("service:slp-template:" + string + ";" + SERVICE_ATTR_ID + "=" + serviceType + ";" + VERSION_ATTR_ID + "=" + string2, 65535);
        Advertiser advertiser = ServiceLocationManager.getAdvertiser(locale);
        if (advertiser == null) {
            throw new ServiceLocationException(16, "no_advertiser", new Object[0]);
        }
        advertiser.register(serviceURL, vector);
    }
}

