/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Advertiser;
import com.sun.slp.Assert;
import com.sun.slp.CSrvDereg;
import com.sun.slp.CSrvReg;
import com.sun.slp.PermSARegTable;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.Transact;
import java.util.Locale;
import java.util.Vector;

class SARequester
implements Advertiser {
    private static PermSARegTable pregtable = null;
    private static SLPConfig config = null;
    private Locale locale;

    SARequester(Locale locale) {
        Assert.nonNullParameter(locale, "locale");
        SARequester.getPermSARegTable();
        this.locale = locale;
    }

    public void addAttributes(ServiceURL serviceURL, Vector vector) throws ServiceLocationException {
        this.registerInternal(serviceURL, vector, false);
    }

    public void deleteAttributes(ServiceURL serviceURL, Vector vector) throws ServiceLocationException {
        if (vector == null || vector.size() <= 0) {
            throw new IllegalArgumentException(config.formatMessage("null_or_empty_vector", new Object[]{"attributeIds"}));
        }
        this.deregisterInternal(serviceURL, vector);
    }

    public void deregister(ServiceURL serviceURL) throws ServiceLocationException {
        this.deregisterInternal(serviceURL, null);
    }

    private void deregisterInternal(ServiceURL serviceURL, Vector vector) throws ServiceLocationException {
        Assert.nonNullParameter(serviceURL, "URL");
        Vector vector2 = config.getSAConfiguredScopes();
        if (vector == null) {
            pregtable.dereg(serviceURL);
        }
        CSrvDereg cSrvDereg = new CSrvDereg(this.locale, serviceURL, vector2, vector, null);
        SrvLocMsg srvLocMsg = Transact.transactTCPMsg(config.getLoopback(), cSrvDereg, true);
        this.handleError(srvLocMsg);
    }

    public Locale getLocale() {
        return this.locale;
    }

    static PermSARegTable getPermSARegTable() {
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        if (pregtable == null) {
            pregtable = new PermSARegTable(config);
        }
        return pregtable;
    }

    private void handleError(SrvLocMsg srvLocMsg) throws ServiceLocationException {
        if (srvLocMsg == null || !(srvLocMsg.getHeader().functionCode == 5)) {
            throw new ServiceLocationException(19, "unexpected_ipc", new Object[0]);
        }
        short s = srvLocMsg.getErrorCode();
        if (s != 0) {
            throw new ServiceLocationException(s, "remote_error", new Object[0]);
        }
    }

    public void register(ServiceURL serviceURL, Vector vector) throws ServiceLocationException {
        this.registerInternal(serviceURL, vector, true);
    }

    private void registerInternal(ServiceURL serviceURL, Vector vector, boolean bl) throws ServiceLocationException {
        Assert.nonNullParameter(serviceURL, "URL");
        Assert.nonNullParameter(vector, "serviceLocationAttributes");
        Vector vector2 = config.getSAConfiguredScopes();
        CSrvReg cSrvReg = new CSrvReg(bl, this.locale, serviceURL, vector2, vector, null, null);
        SrvLocMsg srvLocMsg = Transact.transactTCPMsg(config.getLoopback(), cSrvReg, true);
        this.handleError(srvLocMsg);
        if (serviceURL.getIsPermanent()) {
            CSrvReg cSrvReg2 = new CSrvReg(false, this.locale, serviceURL, vector2, new Vector(), null, null);
            pregtable.reg(serviceURL, cSrvReg2);
        } else {
            pregtable.dereg(serviceURL);
        }
    }
}

