/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.ServiceLocationException;

class Opaque {
    private static final char ZERO = '0';
    byte[] bytes;
    static final String OPAQUE_HEADER = "\\ff";

    Opaque(byte[] byArray) {
        this.bytes = byArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Opaque)) {
            return false;
        }
        byte[] byArray = ((Opaque)object).bytes;
        if (byArray.length != this.bytes.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != this.bytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        int n = this.bytes.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OPAQUE_HEADER);
        int n2 = 0;
        while (n2 < n) {
            String string = null;
            string = Integer.toHexString(this.bytes[n2] & 0xFF);
            stringBuffer.append('\\');
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    static byte[] unescapeByteArray(String string) throws ServiceLocationException {
        if (!string.startsWith(OPAQUE_HEADER)) {
            throw new ServiceLocationException(2, "no_opaque_header", new Object[]{string});
        }
        String string2 = string.substring(OPAQUE_HEADER.length());
        int n = string2.length();
        int n2 = 0;
        int n3 = n / 3;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n) {
            if (string2.charAt(n4) != '\\') {
                throw new ServiceLocationException(2, "escape_err", new Object[]{string});
            }
            if (n4 > n - 2) {
                throw new ServiceLocationException(2, "nonterminating_escape", new Object[]{string});
            }
            if (n2 >= n3) {
                throw new ServiceLocationException(2, "wrong_char_num", new Object[]{string});
            }
            try {
                byArray[n2++] = (byte)(Integer.parseInt(string2.substring(++n4, n4 + 2), 16) & 0xFF);
                ++n4;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServiceLocationException(2, "not_hex", new Object[]{string});
            }
            ++n4;
        }
        return byArray;
    }
}

