/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.SrvLocHeader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class AuthBlock {
    private static String SPI_PROPERTY = "sun.net.slp.SPIs";
    int bsd;
    String spi;
    Object[] message;
    int lifetime;
    long timeStamp;
    SrvLocHeader hdr;
    Signature sig;
    int abLength;
    byte[] abBytes;
    byte[] spiBytes;
    HashSet eqSet;
    private static KeyStore keystore;
    private static KeyStore keypkg;

    AuthBlock(SrvLocHeader srvLocHeader, Object[] objectArray, DataInputStream dataInputStream) throws ServiceLocationException, IllegalArgumentException, IOException {
        Assert.nonNullParameter(srvLocHeader, "hdr");
        AuthBlock.ensureNonEmpty(objectArray, "message");
        Assert.nonNullParameter(dataInputStream, "dis");
        this.message = objectArray;
        this.eqSet = new HashSet();
        this.bsd = srvLocHeader.getInt(dataInputStream);
        this.abLength = srvLocHeader.getInt(dataInputStream);
        int n = 4;
        this.timeStamp = AuthBlock.getInt32(dataInputStream);
        n += 4;
        srvLocHeader.nbytes += 4;
        StringBuffer stringBuffer = new StringBuffer();
        srvLocHeader.getString(stringBuffer, dataInputStream);
        this.spi = stringBuffer.toString();
        if (this.spi.length() == 0) {
            throw new ServiceLocationException(2, "no_spi_string", new Object[0]);
        }
        this.abBytes = new byte[this.abLength - (n += 2 + this.spi.length())];
        dataInputStream.readFully(this.abBytes, 0, this.abLength - n);
        srvLocHeader.nbytes += this.abBytes.length;
        long l = this.timeStamp - SLPConfig.currentSLPTime();
        l = l <= Integer.MAX_VALUE ? l : 0L;
        this.lifetime = (int)l;
        this.lifetime = this.lifetime < 0 ? 0 : this.lifetime;
        this.getSecurityProvider(this.bsd);
    }

    AuthBlock(Object[] objectArray, String string, int n, int n2) throws ServiceLocationException, IllegalArgumentException {
        AuthBlock.ensureNonEmpty(objectArray, "message");
        Assert.nonNullParameter(string, "spi");
        this.bsd = n;
        this.getSecurityProvider(n);
        this.message = objectArray;
        this.spi = string;
        this.lifetime = n2;
        this.timeStamp = SLPConfig.currentSLPTime() + (long)n2;
        try {
            this.sig.initSign(null);
            this.computeHash();
            this.abBytes = this.sig.sign();
        }
        catch (InvalidKeyException invalidKeyException) {
            SLPConfig sLPConfig = SLPConfig.getSLPConfig();
            throw new IllegalArgumentException(sLPConfig.formatMessage("cant_sign_for_spi", new Object[]{string, invalidKeyException.getMessage()}));
        }
        catch (SignatureException signatureException) {
            SLPConfig sLPConfig = SLPConfig.getSLPConfig();
            throw new IllegalArgumentException(sLPConfig.formatMessage("cant_sign_for_spi", new Object[]{string, signatureException.getMessage()}));
        }
        this.abLength = 8 + this.spiBytes.length + this.abBytes.length;
    }

    static boolean canSignAs(String string) throws ServiceLocationException {
        X509Certificate x509Certificate = AuthBlock.getSignAsCert();
        if (x509Certificate == null) {
            return false;
        }
        KeyStore keyStore = AuthBlock.getKeyStore();
        if (keyStore == null) {
            return false;
        }
        X509Certificate x509Certificate2 = AuthBlock.getCert(string, keyStore);
        return AuthBlock.onCertChain(x509Certificate.getSubjectDN().toString(), x509Certificate2.getSubjectDN());
    }

    static boolean checkEquiv(String string, AuthBlock authBlock) {
        X509Certificate x509Certificate;
        try {
            KeyStore keyStore = AuthBlock.getKeyStore();
            x509Certificate = AuthBlock.getCert(string, keyStore);
        }
        catch (Exception exception) {
            SLPConfig.getSLPConfig().writeLog("cant_get_equivalency", new Object[]{string, exception.getMessage()});
            return false;
        }
        return authBlock.inEqSet(x509Certificate.getSubjectDN());
    }

    private void checkSPIs(X509Certificate x509Certificate, KeyStore keyStore) throws ServiceLocationException, GeneralSecurityException {
        String string = System.getProperty("sun.net.slp.SPIs");
        if (string == null) {
            throw new ServiceLocationException(7, "no_spis_configured", new Object[0]);
        }
        Certificate[] certificateArray = keyStore.getCertificateChain(x509Certificate.getSubjectDN().toString());
        if (certificateArray == null) {
            throw new ServiceLocationException(7, "no_cert_chain", new Object[]{x509Certificate.getSubjectDN().toString()});
        }
        int n = 0;
        try {
            this.eqSet.add(((X509Certificate)certificateArray[0]).getSubjectDN());
            n = 1;
            while (n < certificateArray.length) {
                ((X509Certificate)certificateArray[n]).checkValidity();
                certificateArray[n - 1].verify(certificateArray[n].getPublicKey(), "SunAMI");
                this.eqSet.add(((X509Certificate)certificateArray[n]).getSubjectDN());
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new ServiceLocationException(7, "not_x509cert", new Object[]{certificateArray[n].getType(), classCastException.getMessage()});
        }
        if (AuthBlock.configuredToVerify(certificateArray, string, keyStore)) {
            return;
        }
        throw new ServiceLocationException(7, "cant_match_spis", new Object[]{x509Certificate.getSubjectDN().toString(), ""});
    }

    static LinkedList commaSeparatedListToLinkedList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            linkedList.add(string2);
        }
        return linkedList;
    }

    private void computeHash() throws ServiceLocationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SrvLocHeader.putStringField(this.spi, byteArrayOutputStream, "UTF8");
            this.spiBytes = byteArrayOutputStream.toByteArray();
            this.sig.update(this.spiBytes);
            int n = this.message.length;
            int n2 = 0;
            while (n2 < n) {
                this.sig.update((byte[])this.message[n2]);
                ++n2;
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            AuthBlock.putInt32(this.timeStamp, byteArrayOutputStream);
            this.sig.update(byteArrayOutputStream.toByteArray());
        }
        catch (SignatureException signatureException) {
            throw new ServiceLocationException(20, "cant_compute_hash", new Object[]{signatureException.getMessage()});
        }
    }

    private static boolean configuredToVerify(Certificate[] certificateArray, String string, KeyStore keyStore) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Principal principal;
            String string2;
            try {
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                X509Certificate x509Certificate = AuthBlock.getCert(string2, keyStore);
                principal = x509Certificate.getSubjectDN();
            }
            catch (ServiceLocationException serviceLocationException) {
                SLPConfig.getSLPConfig().writeLog("cant_process_spi", new Object[]{string2, serviceLocationException.getMessage()});
                continue;
            }
            if (!AuthBlock.onCertChain(principal, certificateArray)) continue;
            return true;
        }
        return false;
    }

    static String desc(Hashtable hashtable) {
        if (hashtable == null) {
            return "null";
        }
        Enumeration enumeration = hashtable.elements();
        int n = hashtable.size();
        String string = n == 1 ? "1 Auth Block:\n" : String.valueOf(n) + " Auth Blocks:\n";
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AuthBlock authBlock = (AuthBlock)enumeration.nextElement();
            string = String.valueOf(string) + "             " + n2++ + ": " + authBlock.toString();
        }
        return string;
    }

    private static void ensureNonEmpty(Object object, String string) throws IllegalArgumentException {
        int n = 0;
        if (object != null) {
            n = object instanceof Object[] ? ((Object[])object).length : ((Hashtable)object).size();
        }
        if (object == null || n == 0) {
            SLPConfig sLPConfig = SLPConfig.getSLPConfig();
            String string2 = sLPConfig.formatMessage("null_or_empty_vector", new Object[]{string});
            throw new IllegalArgumentException(string2);
        }
    }

    void externalize(SrvLocHeader srvLocHeader, ByteArrayOutputStream byteArrayOutputStream) throws ServiceLocationException, IllegalArgumentException {
        Assert.nonNullParameter(srvLocHeader, "hdr");
        Assert.nonNullParameter(byteArrayOutputStream, "baos");
        srvLocHeader.putInt(this.bsd, byteArrayOutputStream);
        srvLocHeader.putInt(this.abLength, byteArrayOutputStream);
        AuthBlock.putInt32(this.timeStamp, byteArrayOutputStream);
        srvLocHeader.nbytes += 4;
        srvLocHeader.putString(this.spi, byteArrayOutputStream);
        byteArrayOutputStream.write(this.abBytes, 0, this.abBytes.length);
        srvLocHeader.nbytes += this.abBytes.length;
    }

    static void externalizeAll(SrvLocHeader srvLocHeader, Hashtable hashtable, ByteArrayOutputStream byteArrayOutputStream) throws ServiceLocationException, IllegalArgumentException {
        AuthBlock.ensureNonEmpty(hashtable, "authBlocks");
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AuthBlock authBlock = (AuthBlock)enumeration.nextElement();
            authBlock.externalize(srvLocHeader, byteArrayOutputStream);
        }
    }

    private static X509Certificate getCert(String string, KeyStore keyStore) throws ServiceLocationException {
        X509Certificate x509Certificate = null;
        try {
            string = ServiceLocationAttribute.unescapeAttributeString(string, false);
        }
        catch (ServiceLocationException serviceLocationException) {
            throw new ServiceLocationException(2, "spi_parse_error", new Object[]{string, serviceLocationException.getMessage()});
        }
        try {
            x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        }
        catch (ClassCastException classCastException) {
            throw new ServiceLocationException(7, "not_x509cert", new Object[]{x509Certificate.getType(), classCastException.getMessage()});
        }
        catch (KeyStoreException keyStoreException) {
            throw new ServiceLocationException(7, "no_cert", new Object[]{string, keyStoreException.getMessage()});
        }
        if (x509Certificate == null) {
            throw new ServiceLocationException(7, "no_cert", new Object[]{string, ""});
        }
        return x509Certificate;
    }

    static Object[] getContents(Hashtable hashtable) throws IllegalArgumentException {
        AuthBlock.ensureNonEmpty(hashtable, "authBlocks");
        Enumeration enumeration = hashtable.elements();
        AuthBlock authBlock = (AuthBlock)enumeration.nextElement();
        return authBlock.getMessageParts();
    }

    static AuthBlock getEquivalentAuth(String string, Hashtable hashtable) {
        X509Certificate x509Certificate;
        Object object;
        if (hashtable.size() == 0) {
            return null;
        }
        try {
            object = AuthBlock.getKeyStore();
            x509Certificate = AuthBlock.getCert(string, (KeyStore)object);
        }
        catch (Exception exception) {
            SLPConfig.getSLPConfig().writeLog("cant_get_equivalency", new Object[]{string, exception.getMessage()});
            return null;
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            AuthBlock authBlock = (AuthBlock)object.nextElement();
            if (!authBlock.inEqSet(x509Certificate.getSubjectDN())) continue;
            return authBlock;
        }
        return null;
    }

    private static long getInt32(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray, 0, 4);
        long l = byArray[0] & 0xFF;
        long l2 = byArray[1] & 0xFF;
        long l3 = byArray[2] & 0xFF;
        long l4 = byArray[3] & 0xFF;
        long l5 = l << 24;
        l5 += l2 << 16;
        l5 += l3 << 8;
        return l5 += l4;
    }

    private static synchronized KeyStore getKeyPkg() throws ServiceLocationException {
        if (keypkg != null) {
            return keypkg;
        }
        try {
            keypkg = KeyStore.getInstance("amiks", "SunAMI");
            keypkg.load(null, null);
        }
        catch (Exception exception) {
            throw new ServiceLocationException(7, "no_keystore", new Object[]{exception.getMessage()});
        }
        return keypkg;
    }

    private static synchronized KeyStore getKeyStore() throws ServiceLocationException {
        if (keystore != null) {
            return keystore;
        }
        try {
            keystore = KeyStore.getInstance("amicerts", "SunAMI");
            keystore.load(null, null);
        }
        catch (Exception exception) {
            throw new ServiceLocationException(7, "no_keystore", new Object[]{exception.getMessage()});
        }
        return keystore;
    }

    int getLifetime() {
        return this.lifetime;
    }

    Object[] getMessageParts() {
        return this.message;
    }

    String getSPI() {
        return this.spi;
    }

    static LinkedList getSPIList(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return AuthBlock.commaSeparatedListToLinkedList(string2);
    }

    private void getSecurityProvider(int n) throws ServiceLocationException {
        String string = "Unknown BSD";
        try {
            if (n == 2) {
                string = "DSA";
                this.sig = Signature.getInstance("SHA/DSA", "SunAMI");
                return;
            }
            if (n == 1) {
                string = "MD5/RSA";
                this.sig = Signature.getInstance("MD5/RSA", "SunAMI");
                return;
            }
            if (n == 3) {
                string = "Keyed HMAC with MD5";
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceLocationException(20, "cant_get_security_provider", new Object[]{new Integer(n), string, generalSecurityException.getMessage()});
        }
        throw new ServiceLocationException(20, "cant_get_security_provider", new Object[]{new Integer(n), string, "Unknown or unsupported BSD"});
    }

    static int getShortestLifetime(Hashtable hashtable) throws IllegalArgumentException {
        AuthBlock.ensureNonEmpty(hashtable, "authBlocks");
        Enumeration enumeration = hashtable.elements();
        int n = Integer.MAX_VALUE;
        while (enumeration.hasMoreElements()) {
            AuthBlock authBlock = (AuthBlock)enumeration.nextElement();
            int n2 = authBlock.getLifetime();
            int n3 = n = n < n2 ? n : n2;
        }
        return n;
    }

    static Hashtable getSignAs() throws ServiceLocationException {
        int n;
        X509Certificate x509Certificate = AuthBlock.getSignAsCert();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        if (x509Certificate == null) {
            return null;
        }
        String string = x509Certificate.getSubjectDN().toString();
        String string2 = null;
        try {
            string2 = ServiceLocationAttribute.escapeAttributeString(string, false);
        }
        catch (ServiceLocationException serviceLocationException) {
            string2 = string;
        }
        string = string2;
        String string3 = x509Certificate.getPublicKey().getAlgorithm();
        if (string3.equals("DSA")) {
            n = 2;
        } else if (string3.equals("RSA")) {
            n = 1;
        } else {
            SLPConfig.getSLPConfig().writeLog("bad_alg_for_alias", new Object[]{string3});
            return null;
        }
        hashtable.put(string, new Integer(n));
        return hashtable;
    }

    static X509Certificate getSignAsCert() throws ServiceLocationException {
        String string = System.getProperty("sun.net.slp.signAs");
        if (string == null) {
            SLPConfig.getSLPConfig().writeLog("no_spis_given", new Object[0]);
            return null;
        }
        KeyStore keyStore = AuthBlock.getKeyPkg();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        X509Certificate x509Certificate = null;
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            x509Certificate = AuthBlock.getCert(string2, keyStore);
        }
        return x509Certificate;
    }

    private boolean inEqSet(Principal principal) {
        return this.eqSet.contains(principal);
    }

    static Hashtable makeAuthBlocks(SrvLocHeader srvLocHeader, Object[] objectArray, DataInputStream dataInputStream, byte by) throws ServiceLocationException, IllegalArgumentException, IOException {
        Hashtable<String, AuthBlock> hashtable = new Hashtable<String, AuthBlock>();
        byte by2 = 0;
        while (by2 < by) {
            AuthBlock authBlock = new AuthBlock(srvLocHeader, objectArray, dataInputStream);
            hashtable.put(authBlock.getSPI(), authBlock);
            by2 = (byte)(by2 + 1);
        }
        return hashtable;
    }

    static Hashtable makeAuthBlocks(Object[] objectArray, int n) throws ServiceLocationException, IllegalArgumentException {
        Hashtable hashtable = AuthBlock.getSignAs();
        if (hashtable == null) {
            throw new ServiceLocationException(7, "cant_sign", new Object[0]);
        }
        Hashtable<String, AuthBlock> hashtable2 = new Hashtable<String, AuthBlock>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n2 = (Integer)hashtable.get(string);
            hashtable2.put(string, new AuthBlock(objectArray, string, n2, n));
        }
        return hashtable2;
    }

    int nBytes() {
        return this.abLength;
    }

    private static boolean onCertChain(String string, Principal principal) throws ServiceLocationException {
        Certificate[] certificateArray;
        ServiceLocationException serviceLocationException = new ServiceLocationException(5, "no_cert_chain", new Object[]{string});
        try {
            KeyStore keyStore = AuthBlock.getKeyStore();
            certificateArray = keyStore.getCertificateChain(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw serviceLocationException;
        }
        if (certificateArray == null) {
            throw serviceLocationException;
        }
        return AuthBlock.onCertChain(principal, certificateArray);
    }

    private static boolean onCertChain(Principal principal, Certificate[] certificateArray) {
        int n = 0;
        while (n < certificateArray.length) {
            Principal principal2 = ((X509Certificate)certificateArray[n]).getSubjectDN();
            if (principal.equals(principal2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void putInt32(long l, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write((byte)(l >> 24 & 0xFFL));
        byteArrayOutputStream.write((byte)(l >> 16 & 0xFFL));
        byteArrayOutputStream.write((byte)(l >> 8 & 0xFFL));
        byteArrayOutputStream.write((byte)(l & 0xFFL));
    }

    public String toString() {
        return "SPI=``" + this.spi + "''\n" + "                BSD=``" + this.bsd + "''\n" + "                timeStamp=``" + this.timeStamp + "''\n" + "                AuthBlock bytes=" + this.abLength + " bytes\n";
    }

    void verify() throws ServiceLocationException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("amicerts", "SunAMI");
            keyStore.load(null, null);
        }
        catch (Exception exception) {
            throw new ServiceLocationException(7, "no_keystore", new Object[]{exception.getMessage()});
        }
        String string = null;
        try {
            string = ServiceLocationAttribute.unescapeAttributeString(this.spi, false);
        }
        catch (ServiceLocationException serviceLocationException) {
            string = this.spi;
        }
        X509Certificate x509Certificate = AuthBlock.getCert(this.spi, keyStore);
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateException certificateException) {
            throw new ServiceLocationException(7, "invalid_cert", new Object[]{string, certificateException.getMessage()});
        }
        if (this.lifetime == 0) {
            throw new ServiceLocationException(7, "timestamp_failure", new Object[]{string});
        }
        try {
            this.checkSPIs(x509Certificate, keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceLocationException(7, "cant_match_spis", new Object[]{x509Certificate.getSubjectDN(), generalSecurityException.getMessage()});
        }
        try {
            this.sig.initVerify(x509Certificate.getPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceLocationException(20, "init_verify_failure", new Object[]{string, invalidKeyException.getMessage()});
        }
        this.computeHash();
        ServiceLocationException serviceLocationException = new ServiceLocationException(7, "verify_failure", new Object[]{string});
        try {
            if (!this.sig.verify(this.abBytes)) {
                throw serviceLocationException;
            }
        }
        catch (SignatureException signatureException) {
            throw serviceLocationException;
        }
    }

    static void verifyAll(Hashtable hashtable) throws ServiceLocationException, IllegalArgumentException {
        AuthBlock.ensureNonEmpty(hashtable, "authBlocks");
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AuthBlock authBlock = (AuthBlock)enumeration.nextElement();
            authBlock.verify();
        }
    }
}

