/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.zones;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.device.fcswitch.util.snmp.EF_6000_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.FIBRE_CHANNEL_MGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ZoneInfo {
    private static final String BROCADE_ZONE_COMMAND = "brocadezone ";
    private static final String QLOGIC_ZONE_COMMAND = "qlogicswitchzones ";
    private static final String SWITCH_1GB_ZONE_COMMAND = "sanbox get_zone ";
    private static final String DEFAULT_BROCADE_PASSWORD = " password";
    private static final String HARD_ZONE = " hd all";
    private static final String SOFT_ZONE = " ns all";
    private static final String LOOP_ZONE = " sl all";
    private static final String SADE_HOME = "storade.home";
    private static final String SBIN = "sbin";
    private static final String LOG_TAG = "Zone";
    private static final String HARD_ZONE_DESCRPTION = "Hard Zone";
    private static final String SOFT_ZONE_DESCRPTION = "Soft Zone";
    private static final String SL_ZONE_DESCRPTION = "Segmented Loop Zone";
    public static final String sccs_id = "@(#)ZoneInfo.java\t1.8 12/01/02 SMI";

    public static Object[] getBrocadeZones(String string) {
        Object[] objectArray = null;
        try {
            objectArray = ZoneInfo.parseBrocadeZoneInfo(ZoneInfo.execute(BROCADE_ZONE_COMMAND + string + DEFAULT_BROCADE_PASSWORD));
        }
        catch (Exception exception) {
            return new Object[0];
        }
        return objectArray;
    }

    public static Object[] getQlogicZones(String string) {
        Object[] objectArray = null;
        try {
            objectArray = ZoneInfo.parseQlogicZoneInfo(ZoneInfo.execute(QLOGIC_ZONE_COMMAND + string));
        }
        catch (Exception exception) {
            return new Object[0];
        }
        return objectArray;
    }

    public static Object[] get1GBSwitchZones(String string) {
        ArrayList arrayList = new ArrayList();
        ZoneInfo.parse1GBZoneInfo(arrayList, ZoneInfo.execute(SWITCH_1GB_ZONE_COMMAND + string + HARD_ZONE), HARD_ZONE_DESCRPTION);
        ZoneInfo.parse1GBZoneInfo(arrayList, ZoneInfo.execute(SWITCH_1GB_ZONE_COMMAND + string + SOFT_ZONE), SOFT_ZONE_DESCRPTION);
        ZoneInfo.parse1GBZoneInfo(arrayList, ZoneInfo.execute(SWITCH_1GB_ZONE_COMMAND + string + LOOP_ZONE), SL_ZONE_DESCRPTION);
        return arrayList.toArray();
    }

    public static Object[] getMcDataZones(String string) {
        ArrayList arrayList = new ArrayList();
        ZoneInfo.parseMcDataZones(arrayList, string);
        return arrayList.toArray();
    }

    private static String execute(String string) {
        String string2 = System.getProperty(SADE_HOME) + File.separator + SBIN + File.separator;
        Report.debug.log(LOG_TAG, (Object)string2);
        String string3 = null;
        try {
            String string4 = string2 + string;
            Report.debug.log(LOG_TAG, (Object)string4);
            CommandExec commandExec = new CommandExec(string4);
            commandExec.exec();
            commandExec.getReturnValue();
            string3 = commandExec.getStandardOutput();
            string3 = string3.trim();
        }
        catch (SecurityException securityException) {
            LocalizedString localizedString = new LocalizedString((Exception)securityException);
            return localizedString.getString();
        }
        catch (NullPointerException nullPointerException) {
            LocalizedString localizedString = new LocalizedString((Exception)nullPointerException);
            return localizedString.getString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LocalizedString localizedString = new LocalizedString((Exception)illegalArgumentException);
            return localizedString.getString();
        }
        catch (Exception exception) {
            LocalizedString localizedString = new LocalizedString(exception);
            return localizedString.getString();
        }
        return string3;
    }

    private static Object[] parseBrocadeZoneInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<Zones> arrayList = new ArrayList<Zones>();
        Zones zones = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("Zone Name")) {
                int n = string3.indexOf("=");
                string2 = string3.substring(n + 1, string3.length());
                zones = new Zones(string2);
                zones.setZoneDescription(SOFT_ZONE_DESCRPTION);
                arrayList.add(zones);
                Report.debug.log(LOG_TAG, (Object)("Added Zone " + string2));
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=");
            while (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                if ("Port".equalsIgnoreCase(string2.trim())) continue;
                Report.debug.log(LOG_TAG, (Object)("\t --> Added Port " + string2));
                zones.addPort(string2);
            }
        }
        return arrayList.toArray();
    }

    private static Object[] parseQlogicZoneInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<Zones> arrayList = new ArrayList<Zones>();
        Zones zones = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            StringTokenizer stringTokenizer2;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("Name")) {
                stringTokenizer2 = new StringTokenizer(string3, "=");
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if ("Name".equalsIgnoreCase(string2.trim())) continue;
                    zones = new Zones(string2);
                    zones.setZoneDescription(SOFT_ZONE_DESCRPTION);
                    arrayList.add(zones);
                    Report.debug.log(LOG_TAG, (Object)("Added Zone " + string2));
                }
                continue;
            }
            if (!string3.startsWith("Port")) continue;
            stringTokenizer2 = new StringTokenizer(string3, "=");
            while (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                if ("Port".equalsIgnoreCase(string2.trim())) continue;
                Report.debug.log(LOG_TAG, (Object)("\t --> Added Port " + string2));
                zones.addPort(string2);
            }
        }
        return arrayList.toArray();
    }

    private static Object[] parse1GBZoneInfo(ArrayList arrayList, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Zones zones = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.trim().startsWith("Zone:")) {
                int n;
                String string4;
                int n2 = string3.indexOf("Zone:");
                int n3 = string3.indexOf(",");
                String string5 = string3.substring(n2 + 5, n3);
                String string6 = string3.substring(n3 + 1, string3.length());
                if (!string6.trim().startsWith("Enabled:") || !(string4 = string6.substring((n = string6.indexOf("Enabled:")) + 8, string6.length())).trim().equalsIgnoreCase("yes")) continue;
                zones = new Zones(string5);
                zones.setZoneDescription(string2);
                arrayList.add(zones);
                Report.debug.log(LOG_TAG, (Object)("Added Zone " + string5));
                continue;
            }
            if (!string3.trim().startsWith("Port")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":");
            while (stringTokenizer2.hasMoreTokens()) {
                String string7 = stringTokenizer2.nextToken();
                if ("Port".equalsIgnoreCase(string7.trim())) continue;
                Report.debug.log(LOG_TAG, (Object)("\t --> Added Port " + string7));
                zones.addPort(string7);
            }
        }
        return arrayList.toArray();
    }

    private static Object[] parseMcDataZones(ArrayList arrayList, String string) {
        Zones zones = null;
        String string2 = ZoneInfo.getMcDataDomainID(string);
        SNMPWalk sNMPWalk = new SNMPWalk(string, new EF_6000_MIBOidTable());
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties("ef6000ZoneIndex", "ef6000ZoneMemberCount");
        HashMap hashMap2 = sNMPWalk.filterProperties(hashMap, "1.3.6.1.4.1.289.2.1.1.2.5.6.1.1");
        Collection collection = hashMap2.values();
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (iterator.hasNext()) {
            String string3;
            String string4;
            Object object;
            String string5 = (String)iterator.next();
            String string6 = LOG_TAG + string5;
            zones = new Zones(string6);
            zones.setZoneDescription(SOFT_ZONE_DESCRPTION);
            arrayList.add(zones);
            Report.debug.log(LOG_TAG, (Object)("Added Zone " + string6));
            hashMap = sNMPWalk.getProperties("ef6000MemberDomainID", "ef6000MemberPortNumber");
            String string7 = "1.3.6.1.4.1.289.2.1.1.2.5.7.1.5." + string5;
            hashMap2 = sNMPWalk.filterProperties(hashMap, string7);
            Set set = hashMap2.entrySet();
            Iterator iterator2 = set.iterator();
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator2.hasNext()) {
                object = (Map.Entry)iterator2.next();
                if (!((String)object.getValue()).equalsIgnoreCase(string2)) continue;
                string4 = (String)object.getKey();
                string3 = string4.substring(string4.lastIndexOf(".") + 1, string4.length());
                hashSet.add(string3);
            }
            object = hashSet.iterator();
            hashMap = sNMPWalk.getProperties("ef6000MemberPortNumber", "ef6000TAIndex");
            while (object.hasNext()) {
                string4 = (String)object.next();
                string3 = "1.3.6.1.4.1.289.2.1.1.2.5.7.1.6." + string5 + "." + string4.trim();
                String string8 = (String)hashMap.get(string3);
                if ("NULL".equalsIgnoreCase(string8)) continue;
                Report.debug.log(LOG_TAG, (Object)("\t --> Added Port " + string8));
                zones.addPort(string8);
            }
        }
        return arrayList.toArray();
    }

    private static String getMcDataDomainID(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(string, new FIBRE_CHANNEL_MGMT_MIBOidTable());
        int n = 0;
        HashMap hashMap = sNMPWalk.getProperties("fcConnUnitDomainId", "fcConnUnitProxyMaster");
        hashMap = sNMPWalk.filterProperties(hashMap, "1.3.6.1.2.1.8888.1.1.3.1.11");
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n2 = string2.length();
            String string3 = string2.substring(0, 1);
            Report.debug.log(LOG_TAG, (Object)("DomainID " + string3));
            try {
                n = Integer.parseInt(string3, 10);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n + "";
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            string = System.getProperty(SADE_HOME);
            if (string == null) {
                System.out.println("Make sure you have your LD_LIBRARY_PATH set to$WORKSPACE/device/switch/lib:${LD_LIBRARY_PATH}.");
            }
            System.out.println("java -Dstorade.home=$WORKSPACE/build/demo com.sun.jade.device.fcswitch.util.zones.ZoneInfo <Brocade/Switch2GB/Switch1GB/McData> <ip>");
            if (stringArray.length != 2) {
                System.out.println("Make sure you have your LD_LIBRARY_PATH set to$WORKSPACE/device/switch/lib:${LD_LIBRARY_PATH}.");
            }
            System.out.println("java -Dstorade.home=$WORKSPACE/build/demo com.sun.jade.device.fcswitch.util.zones.ZoneInfo <Brocade/Switch2GB/Switch1GB/McData> <ip>");
            Object[] objectArray = null;
            if (stringArray[0].equalsIgnoreCase("Brocade")) {
                objectArray = ZoneInfo.getBrocadeZones(stringArray[1]);
            } else if (stringArray[0].equalsIgnoreCase("Switch2GB")) {
                objectArray = ZoneInfo.getQlogicZones(stringArray[1]);
            } else if (stringArray[0].equalsIgnoreCase("Switch1GB")) {
                objectArray = ZoneInfo.get1GBSwitchZones(stringArray[1]);
            } else if (stringArray[0].equalsIgnoreCase("McData")) {
                objectArray = ZoneInfo.getMcDataZones(stringArray[1]);
            }
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                System.out.println("Zone Name " + zones.getZoneName());
                Object[] objectArray2 = zones.getPortList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    System.out.println("\tPort Name " + (String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("java ZoneInfo -Dstorade.home=<$WORKSPACE>/build/demo  <Brocade/Switch2GB/Switch1GB/McData> <ip>");
        }
    }

    public static class Test
    extends UnitTest {
        private String brocadeZoneTestString = "Zone Name = zone5Port = 12Port = 13Zone Name = zone1Port = 7Port = 6Port = 5Zone Name = zone2Port = 0Port = 1Port = 2Port = 3Port = 4Zone Name = zone3Zone Name = zone4Port = 14Port = 15";
        private String qlogicZoneTestString = "Switch domain id = 1Number of zones = 1Number of members in zone 0 is 32Name = Zone2Port = 0Port = 1Port = 2Port = 3Port = 4Port = 5Port = 6Port = 7Port = 8Port = 9Port = 10Port = 11Port = 12Port = 13Port = 14Port = 15";
        private String sun1gbZoneTestString = "Zone:  0, Enabled: yesPort: 1Port: 2Port: 3Port: 4Zone:  1, Enabled: yesPort: 5Port: 6Port: 7Port: 8Zone:  2, Enabled: noZone:  3, Enabled: noZone:  4, Enabled: noZone:  5, Enabled: noZone:  6, Enabled: noZone:  7, Enabled: noZone:  8, Enabled: noZone:  9, Enabled: noZone: 10, Enabled: noZone: 11, Enabled: noZone: 12, Enabled: noZone: 13, Enabled: noZone: 14, Enabled: noZone: 15, Enabled: no";

        public void testBrocadeZoneGenerator() {
            Object[] objectArray = ZoneInfo.parseBrocadeZoneInfo(this.brocadeZoneTestString);
            System.out.println("\nZone Info for Brocade switch 172.20.67.138");
            this.assertNotNull(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                System.out.println("Zone Name " + zones.getZoneName());
                Object[] objectArray2 = zones.getPortList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    System.out.println("\tPort Name " + (String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }

        public void testSun1GBZoneGenerator() {
            Object[] objectArray = ZoneInfo.get1GBSwitchZones(this.sun1gbZoneTestString);
            System.out.println("\nZone Info for Sun 1GB switch 172.20.104.11");
            this.assertNotNull(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                System.out.println("Zone Name " + zones.getZoneName());
                Object[] objectArray2 = zones.getPortList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    System.out.println("\tPort Name " + (String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }

        public void testSun2GBZoneGenerator() {
            Object[] objectArray = ZoneInfo.parseQlogicZoneInfo(this.qlogicZoneTestString);
            this.assertNotNull(objectArray);
            System.out.println("\nZone Info for Sun 2GB switch 172.20.67.101");
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                System.out.println("Zone Name " + zones.getZoneName());
                Object[] objectArray2 = zones.getPortList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    System.out.println("\tPort Name " + (String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }
}

