/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.device.fcswitch.util.snmp.FCFABRIC_ELEMENT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.FIBRE_CHANNEL_FE_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.MibRepository;
import com.sun.jade.device.protocol.snmp.SNMP;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

public class SwitchWWNsnmp {
    private String ipno;
    private static int TIMEOUT = 30000;
    private static int MAX_TRIES = 3;
    private SnmpPeer agent = null;
    private MibRepository oidTable = null;
    private String wwn;
    private String wwnHex;
    private String deviceCategory;
    private String snmpVendorId;
    private String snmpVendorIdPlus;
    private static final String WWN = "WWN";
    private static final String QLOGIC = "QLogic";
    private static final String BROCADE = "Brocade";
    private static final String MCDATA = "MCDATA";
    private static final String SUN = "Sun";
    private static final String FIBRE_CHANNEL_SWITCH = "Fibre Channel Switch";
    private static final String SANBOX_1GB = "SANbox";
    private static final String ZERO = "0";
    private static final String DOT = ".";
    private static final String WWN_ZERO_EXTENSION = "0.0.0.0.0.0.0.0";
    private static final String SYSDESCR = "sysDescr";
    private static final String SYSOBJECTID = "sysObjectID";
    private static final String ENTERPRISE_OID_PREFIX = "1.3.6.1.4.1.";
    private static final String FC_ELEMENT_NAME = "fcElementName";
    private static final String FC_FE_ELEMENT_NAME = "fcFeElementName";
    private static String[] deviceType = new String[]{"fcFeModuleDescr"};
    private static String[] wwnFAProps = new String[]{"fcFeElementName"};
    private static String[] wwnFEProps = new String[]{"fcElementName"};
    private static final String QLOGIC_ANCOR_ENTERPRISE_ID = "1663";
    private static final String BROCADE_ENTERPRISE_ID = "1588";
    private static final String MCDATA_ENTERPRISE_ID = "289";
    private static final String SUN_QLOGIC_ANCOR_ENTERPRISE_ID = "42.2.28.3.4.1.1";
    private SNMP snmp = null;
    private static SnmpSession session = null;
    private static final String LOG_TAG = "WWN_SNMP";
    public static final String sccs_id = "@(#)SwitchWWNsnmp.java\t1.16 03/27/03 SMI";

    public SwitchWWNsnmp(String string) {
        this.ipno = string;
        this.snmp = new SNMP();
        this.oidTable = MibRepository.getMibStorage();
        session = SingleSnmpSession.getSnmpSession();
        this.init();
    }

    private void init() {
        String string = null;
        try {
            Properties properties = this.snmp.getBaseProperties(this.ipno);
            if (properties != null) {
                this.deviceCategory = (String)properties.get(SYSDESCR);
                string = (String)properties.get(SYSOBJECTID);
            }
        }
        catch (Exception exception) {
            Report.error.log((Object)(exception.getLocalizedMessage() + " for device " + this.ipno));
        }
        if (this.deviceCategory == null || string == null) {
            return;
        }
        this.snmpVendorId = this.extractEnterpriseID(string);
        this.snmpVendorIdPlus = this.extractEnterpriseIDPlus(string);
        if (QLOGIC_ANCOR_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId) || this.snmpVendorIdPlus.startsWith(SUN_QLOGIC_ANCOR_ENTERPRISE_ID)) {
            if (this.deviceCategory.startsWith(QLOGIC) || this.deviceCategory.startsWith(SANBOX_1GB) || this.deviceCategory.startsWith(SUN)) {
                this.oidTable.addOidTable(new FIBRE_CHANNEL_FE_MIBOidTable());
                this.wwn = (String)this.getProperties(WWN, wwnFAProps, ZERO).get(FC_FE_ELEMENT_NAME);
            } else if (this.deviceCategory.startsWith(FIBRE_CHANNEL_SWITCH)) {
                this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
                this.wwn = (String)this.getProperties(WWN, wwnFEProps, ZERO).get(FC_ELEMENT_NAME);
            }
        } else if (BROCADE_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId)) {
            this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
            this.wwn = (String)this.getProperties(WWN, wwnFEProps, ZERO).get(FC_ELEMENT_NAME);
        } else if (MCDATA_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId)) {
            this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
            this.wwn = (String)this.getProperties(WWN, wwnFEProps, ZERO).get(FC_ELEMENT_NAME);
        } else {
            this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
            this.wwn = (String)this.getProperties(WWN, wwnFEProps, ZERO).get(FC_ELEMENT_NAME);
        }
    }

    private String extractEnterpriseID(String string) {
        int n = ENTERPRISE_OID_PREFIX.length();
        String string2 = string.substring(n, string.length());
        int n2 = string2.indexOf(DOT);
        return string.substring(n, n2 + n);
    }

    private String extractEnterpriseIDPlus(String string) {
        int n = ENTERPRISE_OID_PREFIX.length();
        String string2 = string.substring(n, string.length());
        return string2;
    }

    private void initializePeer() {
        try {
            this.agent = SingleSnmpSession.newSnmpPeer((String)this.ipno);
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Throwable)unknownHostException, (Object)"host not found");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized HashMap getProperties(String string, String[] stringArray, String string2) {
        SnmpRequest snmpRequest;
        HashMap<String, String> hashMap;
        block28: {
            HashMap<String, String> hashMap2;
            block26: {
                hashMap = new HashMap<String, String>();
                snmpRequest = null;
                boolean bl = false;
                try {
                    try {
                        SnmpOid.setSnmpOidTable((SnmpOidTable)this.oidTable);
                        this.initializePeer();
                        SnmpParameters snmpParameters = new SnmpParameters("public", "private");
                        this.agent.setSnmpParam(snmpParameters);
                        session.setDefaultPeer(this.agent);
                        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SNMP.WWN");
                        try {
                            int n = 0;
                            while (n < stringArray.length) {
                                snmpVarBindList.addVarBind(stringArray[n] + DOT + string2);
                                ++n;
                            }
                        }
                        catch (SnmpStatusException snmpStatusException) {
                            Report.debug.log(LOG_TAG, (Object)snmpStatusException.getLocalizedMessage());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Report.debug.log(LOG_TAG, (Object)illegalArgumentException.getLocalizedMessage());
                        }
                        int n = 0;
                        while (n < MAX_TRIES && !(bl = (snmpRequest = session.snmpGetRequest(this.agent, null, snmpVarBindList)).waitForCompletion((long)TIMEOUT))) {
                            try {
                                this.wait(TIMEOUT);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++n;
                        }
                        if (!bl) {
                            HashMap<String, String> hashMap3 = hashMap;
                            Object var22_18 = null;
                            if (snmpRequest != null) {
                                snmpRequest = null;
                            }
                            if (this.agent == null) return hashMap3;
                            this.agent = null;
                            return hashMap3;
                        }
                        int n2 = snmpRequest.getErrorStatus();
                        if (n2 != 0) {
                            if (snmpRequest.getErrorIndex() != 0) {
                                Report.error.log((Object)("Error status = " + SnmpRequest.snmpErrorToString((int)n2)));
                                Report.error.log((Object)("Error index = " + snmpRequest.getErrorIndex()));
                            }
                            hashMap2 = hashMap;
                            break block26;
                        }
                        SnmpVarBindList snmpVarBindList2 = snmpRequest.getResponseVarBindList();
                        int n3 = snmpVarBindList2.getVarBindCount();
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        int n4 = 0;
                        while (n4 < n3) {
                            block27: {
                                SnmpVarBind snmpVarBind = snmpVarBindList2.getVarBindAt(n4);
                                if (snmpVarBind != null && snmpVarBind.isValidValue()) {
                                    SnmpValue snmpValue = snmpVarBind.getSnmpValue();
                                    if (WWN.equalsIgnoreCase(string)) {
                                        long[] lArray = snmpValue.toOid().longValue();
                                        int n5 = 0;
                                        while (true) {
                                            if (n5 >= lArray.length) {
                                                this.wwnHex = stringBuffer2.toString();
                                                this.wwn = stringBuffer.append(WWN_ZERO_EXTENSION).toString();
                                                hashMap.put(stringArray[n4], this.wwn);
                                                break block27;
                                            }
                                            stringBuffer.append(lArray[n5] + DOT);
                                            String string3 = Long.toHexString(lArray[n5]);
                                            if (string3.length() == 1) {
                                                string3 = ZERO + string3;
                                            }
                                            stringBuffer2.append(string3);
                                            ++n5;
                                        }
                                    }
                                    hashMap.put(stringArray[n4], snmpVarBind.getStringValue());
                                }
                            }
                            ++n4;
                        }
                        break block28;
                    }
                    catch (SnmpStatusException snmpStatusException) {
                        Report.error.log((Throwable)snmpStatusException, (Object)"SNMP error");
                        HashMap<String, String> hashMap4 = hashMap;
                        Object var22_21 = null;
                        if (snmpRequest != null) {
                            snmpRequest = null;
                        }
                        if (this.agent == null) return hashMap4;
                        this.agent = null;
                        return hashMap4;
                    }
                }
                catch (Throwable throwable) {
                    Object var22_22 = null;
                    if (snmpRequest != null) {
                        snmpRequest = null;
                    }
                    if (this.agent == null) throw throwable;
                    this.agent = null;
                    throw throwable;
                }
            }
            Object var22_19 = null;
            if (snmpRequest != null) {
                snmpRequest = null;
            }
            if (this.agent == null) return hashMap2;
            this.agent = null;
            return hashMap2;
        }
        Object var22_20 = null;
        if (snmpRequest != null) {
            snmpRequest = null;
        }
        if (this.agent == null) return hashMap;
        this.agent = null;
        return hashMap;
    }

    public String getWWNString() {
        if (this.wwnHex == null) {
            this.init();
        }
        return this.wwnHex;
    }

    public String getVendorSNMPId() {
        if ("42".equalsIgnoreCase(this.snmpVendorId)) {
            return this.snmpVendorIdPlus;
        }
        return this.snmpVendorId;
    }

    public String getVendorSNMPIdPlus() {
        return this.snmpVendorIdPlus;
    }

    public String getWWNSnmp() {
        return this.wwn;
    }

    public String getDeviceType() {
        return this.deviceCategory;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage <switch-ip-addresss>");
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(stringArray[n]);
            String string = null;
            String string2 = null;
            string = switchWWNsnmp.getWWNString();
            string2 = switchWWNsnmp.getWWNSnmp();
            if (string == null) {
                System.out.println("No data returned");
                System.exit(0);
            }
            System.out.println(" WWN of Switch: " + string);
            System.out.println(" SNMP WWN of Switch: " + string2);
            System.out.println(" Device Category : " + switchWWNsnmp.getDeviceType());
            ++n;
        }
    }

    public static class Test
    extends UnitTest {
        public void testSwitchWWNsnmp() {
            SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp("172.20.67.167");
            String string = null;
            String string2 = null;
            string = switchWWNsnmp.getWWNString();
            string2 = switchWWNsnmp.getWWNSnmp();
            String string3 = switchWWNsnmp.getVendorSNMPId();
            this.assertNotNull(string);
            this.assertNotNull(string2);
            this.assertEquals(switchWWNsnmp.getDeviceType(), "Brocade Switch");
            this.assertEquals(string3, SwitchWWNsnmp.BROCADE_ENTERPRISE_ID);
        }
    }
}

