/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.device.fcswitch.ancor.diag.AncorLoopbackTest;
import com.sun.jade.device.fcswitch.ancor.diag.AncorPortStatusTest;
import com.sun.jade.device.fcswitch.ancor.diag.AncorSwitchTest;
import com.sun.jade.device.fcswitch.fibrealliance.diag.brocade.BrocadeTest;
import com.sun.jade.device.fcswitch.fibrealliance.diag.switch2G.Switch2GTest;
import com.sun.jade.device.fcswitch.fibrealliance.io.AncorDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.BrocadeDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.McDataDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.SwitchDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchModelHelper;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.util.Properties;

public class SwitchMF
extends AbstractMF
implements ReportGenerator {
    private String ip;
    private String wwn;
    private String switchType;
    private String wwnSnmp;
    private MFStatus status;
    private Properties props = null;
    private String snmpVendorId;
    private String displaySwitchModel;
    private ReportGenerator reporter = null;
    private static final String DISPLAY_SWITCH_MODEL = "displaySwitchModel";
    private static final String QLOGIC = "QLogic";
    private static final String BROCADE = "Brocade";
    private static final String MCDATA = "MCDATA";
    private static final String SUN = "Sun";
    private static final String SANBOX_1GB = "SANbox1";
    private static final String SUN_SANBOX_2GB = "Sun SANbox2";
    private static final String SUN_SANBOX_1GB = "Sun SANbox";
    private static final String FIBRE_CHANNEL_SWITCH = "Fibre Channel Switch";
    private static final String CAPTION = "caption";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULT_CAPDESCR = "Fibre Channel Switch";
    private static final String PING = "ping ";
    private static final String QLOGIC_ANCOR_ENTERPRISE_ID = "1663";
    private static final String BROCADE_ENTERPRISE_ID = "1588";
    private static final String MCDATA_ENTERPRISE_ID = "289";
    private static final String SUN_QLOGIC_ANCOR_ENTERPRISE_ID = "42.2.28.3.4.1.1";
    private static final String SANBOX_2GB = "SANbox2";
    private static final String ERROR_STRING = "Error in SwitchMF instantiating appropriate Device report of type :";
    private static final String REPORT_FAILURE = "<report ReturnCode='FAILURE'>";
    private static final int MAX_TRIES = 3;
    private static final long RETRY_TIMEOUT = 60000L;
    public static final String sccs_id = "@(#)SwitchMF.java  1.13 09/03/02 SMI";

    public SwitchMF(Properties properties) {
        super(properties);
        String string;
        String string2;
        String string3;
        String string4;
        this.props = properties;
        String string5 = properties.getProperty("wwn");
        if (string5 != null && !"".equals(string5.trim())) {
            this.wwn = string5;
        }
        if ((string4 = properties.getProperty("vendor")) != null && !"".equals(string4.trim())) {
            this.switchType = string4;
        }
        if ((string3 = properties.getProperty("snmpEnterpriseID")) != null && !"".equals(string3.trim())) {
            this.snmpVendorId = string3;
        }
        if ((string2 = properties.getProperty("wwnSnmp")) != null && !"".equals(string2.trim())) {
            this.wwnSnmp = string2;
        }
        if ((string = properties.getProperty("DeviceDisplayModel")) != null && !"".equals(string.trim())) {
            this.displaySwitchModel = string;
        }
        this.ip = this.resolveIP(properties);
        this.setDeviceReport(this);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized String generateReport() {
        var1_1 = null;
        var2_2 = 0;
        var3_3 = SwitchMF.checkEthernetConnection(this.ip);
        if (var3_3) ** GOTO lbl20
        Report.trace.log((Object)("Ethernet Connection lost for device " + this.ip));
        return this.getReportError("Out Of Band Connection lost to device " + this.ip);
lbl-1000:
        // 1 sources

        {
            try {
                var1_1 = this.doGenerateReport();
                if (!var1_1.startsWith("<report ReturnCode='FAILURE'>")) {
                    return var1_1;
                }
            }
            catch (Exception var4_5) {
                // empty catch block
            }
            try {
                this.wait(60000L);
            }
            catch (InterruptedException var4_6) {
                // empty catch block
            }
            ++var2_2;
lbl20:
            // 2 sources

            ** while (var2_2 < 3)
        }
lbl21:
        // 1 sources

        if (var1_1 == null) {
            return this.getReportError("Too many tries " + this.ip);
        }
        return var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized String doGenerateReport() throws Exception {
        Object object;
        block22: {
            Object object2;
            block21: {
                block23: {
                    if (this.reporter != null) break block22;
                    object = null;
                    if (this.wwn == null || this.switchType == null || this.snmpVendorId == null || this.wwnSnmp == null) {
                        object = new SwitchWWNsnmp(this.ip);
                    }
                    if (this.wwn == null || "".equals(this.wwn.trim())) {
                        this.wwn = ((SwitchWWNsnmp)object).getWWNString();
                    }
                    if (this.switchType == null) {
                        this.switchType = ((SwitchWWNsnmp)object).getDeviceType();
                    }
                    if (this.snmpVendorId == null) {
                        this.snmpVendorId = ((SwitchWWNsnmp)object).getVendorSNMPId();
                    }
                    if (this.wwnSnmp == null) {
                        this.wwnSnmp = ((SwitchWWNsnmp)object).getWWNSnmp();
                    }
                    if (this.switchType == null || this.snmpVendorId == null || this.wwnSnmp == null || this.wwn == null) break block21;
                    this.props.put("wwn", this.wwn);
                    this.props.put("vendor", this.switchType);
                    this.props.put("snmpEnterpriseID", this.snmpVendorId);
                    this.props.put("wwnSnmp", this.wwnSnmp);
                    if (!QLOGIC_ANCOR_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId) && !this.snmpVendorId.startsWith(SUN_QLOGIC_ANCOR_ENTERPRISE_ID)) break block23;
                    if (this.switchType.startsWith(QLOGIC) || this.switchType.startsWith(SUN_SANBOX_2GB) || this.switchType.startsWith(SANBOX_2GB)) {
                        if (this.displaySwitchModel == null) {
                            this.getExtraSwitchProperties(this.props, "Sun StorEdge network FC 2Gig switch");
                        }
                        this.reporter = new SwitchDeviceReport(this.props);
                        this.addDiagnosticTest(new Switch2GTest());
                        break block21;
                    } else if (this.switchType.startsWith("Fibre Channel Switch")) {
                        if (this.displaySwitchModel == null) {
                            this.getExtraSwitchProperties(this.props, "Sun StorEdge network FC switch");
                        }
                        object2 = new AncorDeviceReport(this.props);
                        this.reporter = object2;
                        this.wwn = ((AncorDeviceReport)object2).getName();
                        this.addDiagnosticTest(new AncorLoopbackTest());
                        this.addDiagnosticTest(new AncorPortStatusTest());
                        this.addDiagnosticTest(new AncorSwitchTest());
                        break block21;
                    } else {
                        if (!this.switchType.startsWith(SANBOX_1GB) && !this.switchType.startsWith(SUN_SANBOX_1GB)) {
                            String string = ERROR_STRING + this.props.getProperty("ip");
                            Report.error.log((Object)(ERROR_STRING + this.props.getProperty("ip")));
                            this.displaySwitchModel = "Fibre Channel Switch";
                            return this.getReportError(string);
                        }
                        if (this.displaySwitchModel == null) {
                            this.getExtraSwitchProperties(this.props, "Sun StorEdge network FC switch");
                        }
                        this.reporter = new SwitchDeviceReport(this.props);
                        this.addDiagnosticTest(new Switch2GTest());
                    }
                    break block21;
                }
                if (BROCADE_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId)) {
                    if (this.displaySwitchModel == null) {
                        this.getExtraSwitchProperties(this.props, "Brocade SilkWorm FC Switch");
                    }
                    this.reporter = new BrocadeDeviceReport(this.props);
                    this.addDiagnosticTest(new BrocadeTest());
                } else if (MCDATA_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId)) {
                    if (this.displaySwitchModel == null) {
                        this.getExtraSwitchProperties(this.props, "McData Enterprise Director FC Switch");
                    }
                    this.reporter = new McDataDeviceReport(this.props);
                }
            }
            this.updateDeviceConfig();
            if (this.displaySwitchModel == null && (object2 = this.props.getProperty("DeviceDisplayModel")) != null && !"".equals(((String)object2).trim())) {
                this.displaySwitchModel = object2;
            }
        }
        if (this.reporter == null) {
            return this.getReportError("Switch reporter is still not set: " + this.ip);
        }
        object = this.reporter.generateReport();
        if (object == null) {
            Report.error.log((Object)("Null Report for " + this.ip));
            return this.getReportError("Null Report for " + this.ip);
        }
        return object;
    }

    protected String getReportError(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(REPORT_FAILURE);
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(string);
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    private Properties getExtraSwitchProperties(Properties properties, String string) {
        try {
            SwitchModelHelper switchModelHelper = new SwitchModelHelper(string, properties);
            properties = switchModelHelper.getExtraSwitchProperties();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Report.debug.log((Object)illegalArgumentException.toString());
            return properties;
        }
        catch (Exception exception) {
            return properties;
        }
        return properties;
    }

    private static boolean checkEthernetConnection(String string) {
        SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(string);
        String string2 = switchWWNsnmp.getWWNString();
        if (string2 != null) {
            return true;
        }
        try {
            CommandExec commandExec = new CommandExec(PING + string);
            commandExec.exec();
            commandExec.getReturnValue();
            String string3 = commandExec.getStandardOutput();
            string3 = string3.trim();
            String string4 = commandExec.getErrorOutput();
            string4 = string4.trim();
            String string5 = string3 + string4;
            return string5.endsWith("alive");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getClassName() {
        return "StorAdeSwitch_UnitaryComputerSystem";
    }

    public String getName() {
        return this.wwn;
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        return new LocalizedString("com.sun.jade.device.fcswitch.fibrealliance.service.resource.SwitchModel", this.displaySwitchModel, this.displaySwitchModel == null ? "Fibre Channel Switch" : this.displaySwitchModel);
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        properties.setProperty("ip", stringArray[0]);
        properties.setProperty("type", "switch");
        properties.setProperty("logicalName", stringArray[0]);
        System.out.println(SwitchMF.checkEthernetConnection(stringArray[0]));
    }
}

