/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Initiators;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortCounts;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.util.unittest.UnitTest;
import java.net.InetAddress;

public class SwitchHealth {
    public static boolean debug = true;
    public static final int ERROR = -1;

    public static void usage(int n) {
        SwitchHealth.usage();
        System.exit(n);
    }

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("version        <ip-address>");
        System.out.println("port_counts    <ip-address> <port>");
        System.out.println("initiators     <ip-address>");
        System.out.println("chassis_status <ip-address>");
    }

    public static void run(String[] stringArray) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
        Sanbox sanbox = new Sanbox(inetAddress);
        System.out.println("IP:     " + sanbox.getHost().getHostAddress());
        System.out.println("version");
        SanboxVersion sanboxVersion = sanbox.getVersion();
        System.out.print(sanboxVersion);
        Integer n = new Integer(stringArray[1]);
        System.out.println("port_counts " + n);
        PortCounts portCounts = sanbox.getPortCounts(n - 1);
        System.out.println(portCounts.getBlock());
        System.out.println("initiators");
        Initiators initiators = sanbox.getInitiators(0);
        System.out.println(initiators.getBlock());
        System.out.println("chassis_status");
        ChassisStatus chassisStatus = sanbox.getChassisStatus(0);
        System.out.println(chassisStatus.getBlock());
    }

    public static void main(String[] stringArray) {
        block3: {
            if (stringArray.length < 2) {
                SwitchHealth.usage();
                System.exit(1);
            }
            try {
                SwitchHealth.run(stringArray);
            }
            catch (Exception exception) {
                System.out.println("Error " + exception);
                if (!debug) break block3;
                exception.printStackTrace();
            }
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            SwitchHealth switchHealth = new SwitchHealth();
            this.assertNotNull(switchHealth);
        }
    }
}

