/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.diag;

import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.fcswitch.ancor.diag.Messages;
import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.util.locale.Localizer;
import com.sun.wbem.cim.CIMDateTime;
import java.net.InetAddress;

public class AncorSwitchTestExecutable
extends TestExecutableImpl {
    private static final Localizer msgs = Messages.getLocalizer();
    private static final int ALL_PORTS = -1;
    private DiagnosticResult result;
    private boolean abort = false;
    private boolean isRunning = false;
    private Sanbox sanbox;
    private InetAddress hostAddress;
    private int portNum = -1;
    private int numPorts;
    private static final String sccs_id = "@(#)AncorSwitchTestExecutable.java\t1.6 03/13/03 SMI";

    public AncorSwitchTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        super.parseSettings();
        this.result = diagnosticResult;
        diagnosticResult.setTestStartTime(new CIMDateTime());
        diagnosticResult.setTestState(TestState.IN_PROGRESS);
        diagnosticResult.setEstimatedTimeOfPerforming(10);
        diagnosticResult.setPercentComplete((short)0);
        this.isRunning = true;
        try {
            try {
                InetAddress inetAddress = InetAddress.getByName(DiagUtil.getIP((ReferenceForMSE)this.mse));
                this.sanbox = new Sanbox(inetAddress);
                this.switchStatus(diagnosticResult);
                diagnosticResult.addTestResults(msgs.getString("test.passed"));
                diagnosticResult.setFinalResults(TestState.PASSED);
            }
            catch (Exception exception) {
                if (this.reportErrors) {
                    diagnosticResult.addTestResults(exception.getLocalizedMessage());
                }
                diagnosticResult.setFinalResults(TestState.FAILED);
                Object var5_5 = null;
                this.isRunning = false;
                this.abort = false;
                return;
            }
            Object var5_4 = null;
            this.isRunning = false;
            this.abort = false;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.isRunning = false;
            this.abort = false;
            throw throwable;
        }
    }

    private void switchStatus(DiagnosticResult diagnosticResult) throws DiagnosticException {
        SanboxVersion sanboxVersion = this.sanbox.getVersion();
        if (sanboxVersion == null || !sanboxVersion.isValidVersion()) {
            this.failure(msgs.getFormattedString("status.noresponce", (Object)this.mse.getKeyValue()), diagnosticResult);
        }
        System.out.println(sanboxVersion);
        ChassisStatus chassisStatus = this.sanbox.getChassisStatus(0);
        this.numPorts = chassisStatus.getNumOfPorts();
        if (0 != chassisStatus.getPowerSupplyFailed()) {
            chassisStatus = this.sanbox.getChassisStatus(0);
            this.numPorts = chassisStatus.getNumOfPorts();
            if (0 != chassisStatus.getPowerSupplyFailed()) {
                this.failure(msgs.getString("status.ps.failure"), diagnosticResult);
            }
        }
        this.status(msgs.getFormattedString("status.temp.value", (Object)new Integer(chassisStatus.getBoardTemp() / 2)), diagnosticResult);
        switch (chassisStatus.getBoardHeatStatus()) {
            case 0: {
                this.status(msgs.getString("status.temp.ok"), diagnosticResult);
                break;
            }
            case 1: {
                this.softError(msgs.getString("status.temp.warm"), diagnosticResult);
                break;
            }
            case 2: {
                this.failure(msgs.getString("status.temp.overheat"), diagnosticResult);
            }
        }
        if (chassisStatus.isFanInstalled(1) && 0 != chassisStatus.getFanStatus(1)) {
            this.failure(msgs.getFormattedString("status.fan.failure", (Object)new Integer(1)), diagnosticResult);
        }
        if (chassisStatus.isFanInstalled(2) && 0 != chassisStatus.getFanStatus(2)) {
            this.failure(msgs.getFormattedString("status.fan.failure", (Object)new Integer(2)), diagnosticResult);
        }
    }
}

