/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.shell;

import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.logic.inventory.InventoryImpl;
import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.logic.inventory.SubjectNode;
import com.sun.netstorage.mgmt.services.log.LogAlarmServiceImpl;
import com.sun.netstorage.mgmt.services.log.LogService;
import com.sun.netstorage.mgmt.ui.framework.UICommandHandler;
import com.sun.netstorage.mgmt.ui.shell.Ascii;
import com.sun.netstorage.mgmt.ui.shell.BuiltIn;
import com.sun.netstorage.mgmt.ui.shell.CmdHandler;
import com.sun.netstorage.mgmt.ui.shell.Environment;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import com.sun.netstorage.mgmt.ui.shell.LogTracerImpl;
import com.sun.netstorage.mgmt.ui.shell.Shell;
import com.sun.netstorage.mgmt.ui.shell.ShellUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;

public class ShellImpl
implements Shell,
Ascii {
    private static final boolean debug = false;
    protected final Environment myNames;
    protected final InputStream in;
    protected final OutputStream out;
    protected final OutputStream err;
    protected final Lookup lookup;
    protected final Locale myLocale;
    protected LogTracer logger;
    private final HashMap handlerCache;
    protected final LinkedList myHistory;
    private String myPwd = "/";
    protected int lHist = 0;
    protected int lastStatus = 0;
    private String myUser = null;
    protected BuiltIn lastCmd = null;
    private BuiltIn myBuiltins = null;
    private boolean bInFirst = false;
    private boolean dashX = false;
    private static final String myClass = "com.sun.netstorage.mgmt.ui.shell.ShellImpl";
    public static final String HISTSIZE = "HISTSIZE";
    public static final int HIST_SIZE = 128;
    static final String sccs_id = "@(#)ShellImpl.java 1.16 02/03/06 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$shell$Messages;

    public ShellImpl(Environment environment, Lookup lookup, Locale locale) {
        this(environment, System.in, System.out, System.err, lookup, locale, null, false);
    }

    public ShellImpl(Environment environment, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, Lookup lookup, Locale locale, BuiltIn builtIn, boolean bl) {
        this.in = inputStream;
        this.out = outputStream;
        this.err = outputStream2;
        this.lookup = null == lookup ? InventoryImpl.getInstance() : lookup;
        this.myLocale = locale;
        this.myNames = environment;
        this.myBuiltins = builtIn;
        this.bInFirst = bl;
        this.myNames.setProperty(HISTSIZE, Integer.toString(128));
        this.myHistory = new LinkedList();
        this.handlerCache = new HashMap();
        this.logger = new LogTracerImpl((LogService)LogAlarmServiceImpl.getInstance());
    }

    public final Environment getEnv() {
        return this.myNames;
    }

    public final Locale getLocale() {
        return this.myLocale;
    }

    public final int validPath(String string, boolean bl, boolean bl2) {
        return ShellUtils.validPath(string, this.getPwd(), bl, bl2, this.lookup);
    }

    public final SubjectNode getNode(String string, String string2) {
        return ShellUtils.getNode(null == string ? this.getPwd() : string, string2, this.lookup);
    }

    public final String getNodePath(SubjectNode subjectNode) {
        return ShellUtils.getNodePath(subjectNode, this.lookup);
    }

    protected final CmdHandler getCmdHandler(String string) {
        String string2 = this.myNames.getProperty("PATH", ".");
        StringTokenizer stringTokenizer = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        CmdHandler cmdHandler = null;
        if (!string.startsWith("/")) {
            stringTokenizer = new StringTokenizer(string2, ":");
            n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.setLength(0);
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(".")) {
                    string3 = this.myNames.getProperty("PWD");
                }
                stringBuffer.append(string3).append('/').append(string);
                cmdHandler = this.findCmd(stringBuffer.toString(), '/');
                ++n2;
            }
        } else {
            cmdHandler = this.findCmd(string, '/');
        }
        return cmdHandler;
    }

    private final CmdHandler findCmd(String string, char c) {
        if (null == string) {
            return null;
        }
        String[] stringArray = ShellUtils.toArray(string, '/');
        String string2 = null;
        String string3 = null;
        int n = stringArray.length;
        CmdHandler cmdHandler = null;
        if (n > 0) {
            if ("services".equals(stringArray[0])) {
                string2 = ShellUtils.getCtxObject(stringArray, 0, n);
            } else if ("devices".equals(stringArray[0])) {
                string2 = ShellUtils.getCtxObject(stringArray, 1, n - 1);
                string3 = stringArray[n - 1];
            } else {
                string2 = ShellUtils.getCtxObject(stringArray, 0, n - 1);
                string3 = stringArray[n - 1];
            }
            cmdHandler = (CmdHandler)this.findCmdHandler("CLI", string2, string3);
        }
        return cmdHandler;
    }

    protected final UICommandHandler findCmdHandler(String string, String string2, String string3) {
        return ShellUtils.findCmdHandler(string, string2, string3, this.lookup, this, this.err, this.handlerCache);
    }

    protected final UICommandHandler findCmdHandler(String string, String string2, String string3, String string4) {
        return ShellUtils.findCmdHandler(string, string2, string3, string4, this.lookup, this, this.err, this.handlerCache);
    }

    protected final int processCmd(String string, String[] stringArray) {
        int n;
        block10: {
            Object[] objectArray;
            n = -1;
            if (null == stringArray) {
                // empty if block
            }
            CmdHandler cmdHandler = null;
            if (null != this.myBuiltins && this.bInFirst) {
                this.lastCmd = this.myBuiltins.getBuiltIn(stringArray[0]);
                cmdHandler = this.myBuiltins.getCmdHandler(stringArray[0], this);
                if (null != cmdHandler) {
                    n = cmdHandler.execute(stringArray[0], stringArray);
                    this.myNames.setProperty("?", Integer.toString(n));
                }
            }
            if (null == cmdHandler && null != (cmdHandler = this.getCmdHandler(stringArray[0]))) {
                n = cmdHandler.execute(stringArray[0], stringArray);
                this.myNames.setProperty("?", Integer.toString(n));
            }
            if (null == cmdHandler && null != this.myBuiltins && !this.bInFirst) {
                this.lastCmd = this.myBuiltins.getBuiltIn(stringArray[0]);
                cmdHandler = this.myBuiltins.getCmdHandler(stringArray[0], this);
                if (null != cmdHandler) {
                    n = cmdHandler.execute(stringArray[0], stringArray);
                    this.myNames.setProperty("?", Integer.toString(n));
                }
            }
            if (null != cmdHandler) break block10;
            String string2 = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$shell$Messages == null ? (class$com$sun$netstorage$mgmt$ui$shell$Messages = ShellImpl.class$("com.sun.netstorage.mgmt.ui.shell.Messages")) : class$com$sun$netstorage$mgmt$ui$shell$Messages), (String)"`shell.msg.err.not_found`", (Object[])(objectArray = new Object[]{this.myBuiltins.getShellName(), stringArray[0]}));
            if (string2.startsWith("`shell.msg.err.not_found`")) {
                string2 = MessageFormat.format("{0}: ERROR: {1}: not found", objectArray);
            }
            try {
                this.err.write((string2 + "\r\n").getBytes());
                this.err.flush();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    protected final void addToHistory(String string) {
        int n = 128;
        try {
            n = Integer.parseInt(this.myNames.getProperty(HISTSIZE));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.myHistory.size() == n) {
            this.myHistory.removeFirst();
        }
        this.myHistory.addLast(string);
        ++this.lHist;
    }

    public final String getUserName() {
        return this.myUser;
    }

    public final String getPwd() {
        return this.myPwd;
    }

    public final String setPwd(String string) {
        String string2 = this.myPwd;
        this.myPwd = string;
        this.myNames.setProperty("PWD", this.myPwd);
        this.myNames.setProperty("OLDPWD", string2);
        return string2;
    }

    public final String[] getHistory() {
        return this.myHistory.toArray(new String[this.myHistory.size()]);
    }

    public final String getHistory(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.myHistory.size()) {
            return (String)this.myHistory.getLast();
        }
        return (String)this.myHistory.get(n);
    }

    public final int getLastEntryIndex() {
        return this.lHist;
    }

    public void setOption(String string) {
    }

    public String setVariable(String string, String string2) {
        return (String)this.myNames.setProperty(string, string2);
    }

    public String unsetVariable(String string) {
        return (String)this.myNames.remove(string);
    }

    public final InputStream getStdin() {
        return this.in;
    }

    public final OutputStream getStdout() {
        return this.out;
    }

    public final OutputStream getStderr() {
        return this.err;
    }

    public final Lookup getLookup() {
        return this.lookup;
    }

    public final int getLastStatus() {
        return this.lastStatus;
    }

    public void log(String string) {
        this.log(new String[]{string});
    }

    public void log(String[] stringArray) {
        this.logger.log(stringArray);
    }

    public void audit(String[] stringArray) {
        this.logger.audit(stringArray);
    }

    public void audit(String string) {
        this.audit(new String[]{string});
    }

    public void trace(String[] stringArray) {
        this.logger.audit(stringArray);
    }

    public void trace(String string) {
        this.trace(new String[]{string});
    }

    public void verbose(String string) {
        this.logger.verbose(string);
    }

    public void verbose(boolean bl, String string, String string2) {
        this.logger.verbose(bl, string, string2);
    }

    public final void setDashX(boolean bl) {
        this.dashX = bl;
    }

    public final boolean getDashX() {
        return this.dashX;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

