/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.services.notification;

import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.logic.inventory.Inventory;
import com.sun.netstorage.mgmt.logic.inventory.InventoryImpl;
import com.sun.netstorage.mgmt.service.notification.ContractSpecification;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import com.sun.netstorage.mgmt.service.notification.NotifierSpecification;
import com.sun.netstorage.mgmt.service.notification.SelectorSpecification;
import com.sun.netstorage.mgmt.service.notification.snmp.SnmpNotifierSpecification;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.NotificationService;
import com.sun.netstorage.mgmt.services.notification.NotificationServiceFactory;
import com.sun.netstorage.mgmt.services.notification.NotificationServiceFactoryImpl;
import com.sun.netstorage.mgmt.ui.services.util.Utils;
import com.sun.netstorage.mgmt.ui.util.UIException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class SNMPCommand {
    private static int COLUMNS = 5;
    private static Class BUNDLE = class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages = SNMPCommand.class$("com.sun.netstorage.mgmt.ui.services.notification.NotificationMessages")) : class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages;
    private NotificationService nService = null;
    private ContractSpecification[] contracts = null;
    private Hashtable snmpContracts = null;
    private Locale locale;
    static final String sccs_id = "@(#)SNMPCommand.java 1.7    02/11/14 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory;

    public SNMPCommand(Locale locale) throws UIException {
        this.locale = locale;
        try {
            Inventory inventory = InventoryImpl.getInstance();
            Object[] objectArray = inventory.getServiceByClass((class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory == null ? (class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory = SNMPCommand.class$("com.sun.netstorage.mgmt.services.notification.NotificationServiceFactory")) : class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory).getName());
            NotificationServiceFactory notificationServiceFactory = null;
            notificationServiceFactory = objectArray != null && objectArray.length > 0 ? (NotificationServiceFactory)objectArray[0] : NotificationServiceFactoryImpl.getInstance();
            this.nService = notificationServiceFactory.getNotificationService();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"trouble_contacting_service", (Locale)locale), throwable);
        }
    }

    public void run() throws UIException {
        try {
            this.contracts = this.nService.getContracts();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"trouble_contacting_service", (Locale)this.locale), throwable);
        }
        this.snmpContracts = this.mineContracts(this.contracts, "snmp");
    }

    public int count() {
        return this.snmpContracts.size();
    }

    public String[][] getContracts() {
        String[][] stringArray = new String[this.snmpContracts.size()][COLUMNS];
        if (this.contracts == null) {
            return new String[][]{new String[0]};
        }
        Enumeration enumeration = this.snmpContracts.elements();
        int n = 0;
        ContractSpecification contractSpecification = null;
        while (enumeration.hasMoreElements()) {
            contractSpecification = (ContractSpecification)enumeration.nextElement();
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            SnmpNotifierSpecification snmpNotifierSpecification = (SnmpNotifierSpecification)contractSpecification.getNotifierSpecification();
            stringArray[n][0] = String.valueOf(contractSpecification.getID());
            stringArray[n][1] = Utils.parseSeverity(selectorSpecification.getCriteria());
            stringArray[n][2] = snmpNotifierSpecification.getDestinationAddress().getHostName();
            stringArray[n][3] = String.valueOf(snmpNotifierSpecification.getDestinationPort());
            stringArray[n][4] = snmpNotifierSpecification.getLocale().toString();
            ++n;
        }
        return stringArray;
    }

    public Hashtable getContract(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ContractSpecification contractSpecification = (ContractSpecification)this.snmpContracts.get(string);
        if (contractSpecification != null) {
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            SnmpNotifierSpecification snmpNotifierSpecification = (SnmpNotifierSpecification)contractSpecification.getNotifierSpecification();
            hashtable.put("ID", String.valueOf(contractSpecification.getID()));
            hashtable.put("Criteria", Utils.parseSeverity(selectorSpecification.getCriteria()));
            hashtable.put("Hostname", snmpNotifierSpecification.getDestinationAddress().getHostName());
            hashtable.put("Port", String.valueOf(snmpNotifierSpecification.getDestinationPort()));
            hashtable.put("Locale", snmpNotifierSpecification.getLocale().toString());
        }
        if (contractSpecification == null) {
            return null;
        }
        return hashtable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long addContract(String string, String string2, String string3, String string4) throws UIException, ContractSpecificationException {
        long l = 0L;
        if (string2.length() == 0) throw new UIException(Localize.getString((Object)BUNDLE, (String)"add_snmp_msg_empty_address", (Object)string4));
        try {
            ContractSpecification contractSpecification = new ContractSpecification();
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            SnmpNotifierSpecification snmpNotifierSpecification = new SnmpNotifierSpecification();
            selectorSpecification.setCriteria(Utils.formatSeverityFromToken(string));
            snmpNotifierSpecification.setDestinationAddress(InetAddress.getByName(string2));
            snmpNotifierSpecification.setDestinationPort(Integer.parseInt(string3));
            snmpNotifierSpecification.setLocale(Utils.formatStringToLocale(string4));
            contractSpecification.setNotifierSpecification((NotifierSpecification)snmpNotifierSpecification);
            return this.nService.addContract(contractSpecification);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 103) return l;
            throw contractSpecificationException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"trouble_contacting_service", (Object)string4), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteContract(String string) throws UIException {
        boolean bl = false;
        if (string.equals("0")) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"mod_snmp_msg_empty_address", (Locale)this.locale));
        }
        try {
            bl = this.nService.removeContract(Long.parseLong(string), false);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 301) {
                // empty if block
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"trouble_contacting_service", (Locale)this.locale), throwable);
        }
        if (!bl) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"del_snmp_msg_failed", (Locale)this.locale));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String modContract(String string, String string2, String string3, String string4) throws UIException, ContractSpecificationException {
        String string5 = null;
        if (string.equals("0")) return Localize.getString((Object)BUNDLE, (String)"mod_snmp_msg_empty_address", (Object)string4);
        ContractSpecification contractSpecification = (ContractSpecification)this.snmpContracts.get(string);
        if (contractSpecification == null) return Localize.getString((Object)BUNDLE, (String)"mod_snmp_msg_invalid_address", (Object)string4);
        try {
            SnmpNotifierSpecification snmpNotifierSpecification = (SnmpNotifierSpecification)contractSpecification.getNotifierSpecification();
            if (contractSpecification == null) return string5;
            snmpNotifierSpecification.setDestinationAddress(InetAddress.getByName(string2));
            snmpNotifierSpecification.setDestinationPort(Integer.parseInt(string3));
            snmpNotifierSpecification.setLocale(Utils.formatStringToLocale(string4));
            this.nService.modifyContract(contractSpecification);
            return string5;
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 103) return string5;
            throw contractSpecificationException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"mod_snmp_contract_message", (Object)string4), throwable);
        }
    }

    public void pause(boolean bl) throws UIException {
        try {
            if (bl) {
                this.nService.pauseContractByNotifierType("snmp");
            } else {
                this.nService.resumeContractByNotifierType("snmp");
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"trouble_contacting_service", (Locale)this.locale), throwable);
        }
    }

    public boolean isPaused() throws UIException {
        boolean bl = false;
        try {
            bl = this.nService.isNotifierTypePaused("snmp");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"trouble_contacting_service", (Locale)this.locale), throwable);
        }
        return bl;
    }

    private Hashtable mineContracts(ContractSpecification[] contractSpecificationArray, String string) {
        Hashtable<String, ContractSpecification> hashtable = new Hashtable<String, ContractSpecification>();
        int n = 0;
        while (n < contractSpecificationArray.length) {
            ContractSpecification contractSpecification = contractSpecificationArray[n];
            if (contractSpecification.getNotifierSpecification().getNotifierSpecificationType().equals(string)) {
                String string2 = String.valueOf(contractSpecification.getID());
                hashtable.put(string2, contractSpecification);
            }
            ++n;
        }
        return hashtable;
    }

    static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        SNMPCommand sNMPCommand = new SNMPCommand(Locale.getDefault());
        sNMPCommand.run();
        String[][] stringArray2 = sNMPCommand.getContracts();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray2[0].length) {
                stringBuffer.append(stringArray2[n][n2] + "        ");
                ++n2;
            }
            System.out.println(stringBuffer);
            ++n;
        }
        Hashtable hashtable = sNMPCommand.getContract("3");
        System.out.println(" Contract for id=3:\n    " + hashtable.get("ID") + "    " + hashtable.get("Criteria") + "    " + hashtable.get("Trap") + "    " + hashtable.get("Hostname") + "    " + hashtable.get("Port") + "    " + hashtable.get("Locale"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

