/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.services.notification;

import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.logic.inventory.Inventory;
import com.sun.netstorage.mgmt.logic.inventory.InventoryImpl;
import com.sun.netstorage.mgmt.service.notification.ContractSpecification;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import com.sun.netstorage.mgmt.service.notification.NotifierSpecification;
import com.sun.netstorage.mgmt.service.notification.SelectorSpecification;
import com.sun.netstorage.mgmt.service.notification.email.EmailNotifierSpecification;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.NotificationService;
import com.sun.netstorage.mgmt.services.notification.NotificationServiceFactory;
import com.sun.netstorage.mgmt.services.notification.NotificationServiceFactoryImpl;
import com.sun.netstorage.mgmt.ui.services.util.Utils;
import com.sun.netstorage.mgmt.ui.util.UIException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class EmailCommand {
    private static int COLUMNS = 6;
    private static Class BUNDLE = class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages == null ? (class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages = EmailCommand.class$("com.sun.netstorage.mgmt.ui.services.notification.NotificationMessages")) : class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages;
    private NotificationService nService = null;
    private ContractSpecification[] contracts = null;
    private Hashtable emailContracts = null;
    private Locale locale;
    private String FROM_FIELD = "NotificationService";
    static final String sccs_id = "@(#)EmailCommand.java 1.8    02/11/14 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$services$notification$NotificationMessages;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory;

    public EmailCommand(Locale locale) throws UIException {
        this.locale = locale;
        try {
            Inventory inventory = InventoryImpl.getInstance();
            Object[] objectArray = inventory.getServiceByClass((class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory == null ? (class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory = EmailCommand.class$("com.sun.netstorage.mgmt.services.notification.NotificationServiceFactory")) : class$com$sun$netstorage$mgmt$services$notification$NotificationServiceFactory).getName());
            NotificationServiceFactory notificationServiceFactory = null;
            notificationServiceFactory = objectArray != null && objectArray.length > 0 ? (NotificationServiceFactory)objectArray[0] : NotificationServiceFactoryImpl.getInstance();
            this.nService = notificationServiceFactory.getNotificationService();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(Localize.getString((Object)BUNDLE, (String)"trouble_contacting_service", (Locale)locale), throwable);
        }
    }

    public void run() throws UIException {
        try {
            this.contracts = this.nService.getContracts();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(throwable.getMessage());
        }
        this.emailContracts = this.mineContracts(this.contracts, "email");
        Enumeration enumeration = this.emailContracts.elements();
    }

    public int count() {
        return this.emailContracts.size();
    }

    public String[][] getContracts() {
        String[][] stringArray = new String[this.emailContracts.size()][COLUMNS];
        if (this.contracts == null) {
            return new String[][]{new String[0]};
        }
        Enumeration enumeration = this.emailContracts.elements();
        int n = 0;
        ContractSpecification contractSpecification = null;
        while (enumeration.hasMoreElements()) {
            contractSpecification = (ContractSpecification)enumeration.nextElement();
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            EmailNotifierSpecification emailNotifierSpecification = (EmailNotifierSpecification)contractSpecification.getNotifierSpecification();
            stringArray[n][0] = String.valueOf(contractSpecification.getID());
            stringArray[n][1] = Utils.parseSeverity(selectorSpecification.getCriteria());
            stringArray[n][2] = emailNotifierSpecification.getIsPager();
            stringArray[n][3] = this.stringArrayToOneString(emailNotifierSpecification.getTo());
            stringArray[n][4] = String.valueOf(emailNotifierSpecification.getNotificationInterval());
            stringArray[n][5] = emailNotifierSpecification.getLocale().toString();
            ++n;
        }
        return stringArray;
    }

    public Hashtable getContract(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ContractSpecification contractSpecification = (ContractSpecification)this.emailContracts.get(string);
        if (contractSpecification != null) {
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            EmailNotifierSpecification emailNotifierSpecification = (EmailNotifierSpecification)contractSpecification.getNotifierSpecification();
            hashtable.put("ID", String.valueOf(contractSpecification.getID()));
            hashtable.put("Criteria", Utils.parseSeverity(selectorSpecification.getCriteria()));
            hashtable.put("IsPager", emailNotifierSpecification.getIsPager());
            hashtable.put("To", this.stringArrayToOneString(emailNotifierSpecification.getTo()));
            hashtable.put("NotificationInterval", String.valueOf(emailNotifierSpecification.getNotificationInterval()));
            hashtable.put("Locale", emailNotifierSpecification.getLocale().toString());
        }
        if (contractSpecification == null) {
            return null;
        }
        return hashtable;
    }

    public String getSMTPHost() throws UIException {
        String string = "";
        Properties properties = null;
        try {
            properties = this.nService.getNotifierProperties("email");
            string = properties.getProperty("MailHost");
            if (null == string || "".equals(string)) {
                string = "localhost";
                this.setSMTPHost(string);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(throwable.getMessage());
        }
        return string;
    }

    public String setSMTPHost(String string) throws UIException {
        String string2 = null;
        String string3 = "";
        Properties properties = null;
        try {
            properties = this.nService.getNotifierProperties("email");
            properties.put("MailHost", string);
            this.nService.setNotifierProperties("email", properties);
        }
        catch (Exception exception) {
            string2 = Localize.getString((Object)BUNDLE, (String)"invalid_smtp_server", (Locale)this.locale);
        }
        return string2;
    }

    public void sendTestEmail(String string) throws UIException {
        try {
            EmailNotifierSpecification emailNotifierSpecification = new EmailNotifierSpecification();
            emailNotifierSpecification.setTo(this.stringToStringArray(string));
            emailNotifierSpecification.setFrom(Localize.getString((Object)BUNDLE, (String)"email_from", (Locale)this.locale));
            this.nService.testNotifier((NotifierSpecification)emailNotifierSpecification);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(throwable.getMessage());
        }
    }

    public long addContract(String string, String string2, String string3, String string4, String string5, String string6) throws UIException, ContractSpecificationException {
        long l = 0L;
        if (string2.length() != 0) {
            try {
                ContractSpecification contractSpecification = new ContractSpecification();
                SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
                EmailNotifierSpecification emailNotifierSpecification = new EmailNotifierSpecification();
                selectorSpecification.setCriteria(Utils.formatSeverityFromToken(string));
                emailNotifierSpecification.setTo(this.stringToStringArray(string2));
                emailNotifierSpecification.setFrom(Localize.getString((Object)BUNDLE, (String)"email_from", (Object)string6));
                emailNotifierSpecification.setIsPager(string4.equals("pager") ? "yes" : "no");
                emailNotifierSpecification.setNotificationInterval(Long.parseLong(string5));
                emailNotifierSpecification.setLocale(Utils.formatStringToLocale(string6));
                emailNotifierSpecification.setSubject(string3);
                contractSpecification.setNotifierSpecification((NotifierSpecification)emailNotifierSpecification);
                l = this.nService.addContract(contractSpecification);
            }
            catch (ContractSpecificationException contractSpecificationException) {
                if (contractSpecificationException.getErrorNo() != 103) {
                    throw contractSpecificationException;
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throw new UIException(throwable.getMessage());
            }
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteContract(String string) throws UIException {
        boolean bl = false;
        if (string.equals("0")) return;
        try {
            bl = this.nService.removeContract(Long.parseLong(string), false);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 301) {
                // empty if block
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(throwable.getMessage());
        }
        if (!bl) {
            throw new UIException("Delete Failed");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String modContract(String string, String string2, String string3, String string4, String string5) throws UIException, ContractSpecificationException {
        String string6 = null;
        if (string.equals("0")) return Localize.getString((Object)BUNDLE, (String)"mod_email_msg_empty_address", (Object)string5);
        ContractSpecification contractSpecification = (ContractSpecification)this.emailContracts.get(string);
        if (contractSpecification == null) return Localize.getString((Object)BUNDLE, (String)"mod_email_msg_invalid_address", (Object)string5);
        try {
            EmailNotifierSpecification emailNotifierSpecification = (EmailNotifierSpecification)contractSpecification.getNotifierSpecification();
            if (contractSpecification == null) return string6;
            emailNotifierSpecification.setTo(this.stringToStringArray(string2));
            emailNotifierSpecification.setFrom(Localize.getString((Object)BUNDLE, (String)"email_from", (Object)string5));
            emailNotifierSpecification.setIsPager(string3.equals("pager") ? "yes" : "no");
            emailNotifierSpecification.setNotificationInterval(Long.parseLong(string4));
            emailNotifierSpecification.setLocale(Utils.formatStringToLocale(string5));
            this.nService.modifyContract(contractSpecification);
            return string6;
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 103) return string6;
            throw contractSpecificationException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(throwable.getMessage());
        }
    }

    public void pause(boolean bl) throws UIException {
        try {
            if (bl) {
                this.nService.pauseContractByNotifierType("email");
            } else {
                this.nService.resumeContractByNotifierType("email");
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(throwable.getMessage());
        }
    }

    public boolean isPaused() throws UIException {
        boolean bl = false;
        try {
            bl = this.nService.isNotifierTypePaused("email");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new UIException(throwable.getMessage());
        }
        return bl;
    }

    private String stringArrayToOneString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                stringBuffer.append(stringArray[n]);
            } else {
                stringBuffer.append(", " + stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String[] stringToStringArray(String string) {
        String[] stringArray = new String[]{""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        if (stringTokenizer.countTokens() != 0) {
            stringArray = new String[stringTokenizer.countTokens()];
        }
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
        return stringArray;
    }

    private Hashtable mineContracts(ContractSpecification[] contractSpecificationArray, String string) {
        Hashtable<String, ContractSpecification> hashtable = new Hashtable<String, ContractSpecification>();
        int n = 0;
        while (n < contractSpecificationArray.length) {
            ContractSpecification contractSpecification = contractSpecificationArray[n];
            if (contractSpecification.getNotifierSpecification().getNotifierSpecificationType().equals(string)) {
                String string2 = String.valueOf(contractSpecification.getID());
                hashtable.put(string2, contractSpecification);
            }
            ++n;
        }
        return hashtable;
    }

    static void main(String[] stringArray) throws UIException {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        EmailCommand emailCommand = new EmailCommand(Locale.getDefault());
        emailCommand.run();
        String[][] stringArray2 = emailCommand.getContracts();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray2[0].length) {
                stringBuffer.append(stringArray2[n][n2] + "        ");
                ++n2;
            }
            System.out.println(stringBuffer);
            ++n;
        }
        Hashtable hashtable = emailCommand.getContract("3");
        System.out.println(" Contract for id=3:\n    " + hashtable.get("ID") + "    " + hashtable.get("Criteria") + "    " + hashtable.get("To") + "    " + hashtable.get("IsPager") + "    " + hashtable.get("NotificationInterval") + "    " + hashtable.get("Locale"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

