/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.framework;

import com.sun.netstorage.mgmt.locale.LocalizableMessage;
import com.sun.netstorage.mgmt.logic.FB;
import com.sun.netstorage.mgmt.logic.MF;
import com.sun.netstorage.mgmt.logic.inventory.InventoryImpl;
import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.logic.inventory.SubjectNode;
import com.sun.netstorage.mgmt.services.log.AlarmService;
import com.sun.netstorage.mgmt.services.log.LogAlarmServiceImpl;
import com.sun.netstorage.mgmt.services.log.LogLevel;
import com.sun.netstorage.mgmt.services.log.LogService;
import com.sun.netstorage.mgmt.ui.framework.AbstractCmdHandler;
import com.sun.netstorage.mgmt.ui.framework.CmdCompletion;
import com.sun.netstorage.mgmt.ui.framework.CmdRetStatus;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Locale;

public abstract class Command {
    protected final String m_commandName;
    protected final String m_subCmdName;
    private InputStream myStdin;
    private OutputStream myStdout;
    private OutputStream myStderr;
    private Locale myLocale;
    private static final String LOG_COMPONENT_NAME = "UI";
    private CmdCompletion returnVal = null;
    private Lookup lookup = null;
    private LogService logger = null;
    private AlarmService alarm = null;
    private Class myLogContext = this.getClass();
    private String myLogComponent = "";
    private String myLogDevice = "";
    private static final String sccs_id = "@(#)Command.java 1.24    02/10/10 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$shell$Messages;

    protected Command(String string, String string2, Lookup lookup, LogService logService, AlarmService alarmService) {
        this.m_commandName = string;
        this.m_subCmdName = string2;
        this.myStdin = null;
        this.myStdout = null;
        this.myStderr = null;
        this.lookup = null == lookup ? InventoryImpl.getInstance() : lookup;
        this.logger = null == logService ? LogAlarmServiceImpl.getInstance() : logService;
        this.alarm = null == alarmService ? LogAlarmServiceImpl.getInstance() : alarmService;
        this.setLogComponent(LOG_COMPONENT_NAME);
        this.setLogDevice(this.m_commandName);
    }

    public abstract CmdCompletion execute(String[] var1);

    public CmdCompletion getSytaxError(Class clazz, String string, String[] stringArray, int n, String string2, String string3) {
        CmdCompletion cmdCompletion = new CmdCompletion();
        LocalizableMessage localizableMessage = new LocalizableMessage(clazz, string, (Serializable[])stringArray);
        LocalizableMessage localizableMessage2 = null;
        LocalizableMessage localizableMessage3 = null;
        if (0 == n) {
            localizableMessage2 = localizableMessage;
        } else {
            localizableMessage3 = localizableMessage;
        }
        cmdCompletion.addRetStatus(new CmdRetStatus(string2, string3, null, null, n, localizableMessage2, localizableMessage3));
        if (localizableMessage3 != null) {
            cmdCompletion.addRetStatus(new CmdRetStatus(string2, string3, null, null, n, null, new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$shell$Messages == null ? (class$com$sun$netstorage$mgmt$ui$shell$Messages = Command.class$("com.sun.netstorage.mgmt.ui.shell.Messages")) : class$com$sun$netstorage$mgmt$ui$shell$Messages, "`shell.msg.err.subcmd.usage`", (Serializable[])new String[]{string2, string3})));
        }
        return cmdCompletion;
    }

    public CmdCompletion getArgError(String string, String string2, String string3) {
        return this.getSytaxError(class$com$sun$netstorage$mgmt$ui$shell$Messages == null ? (class$com$sun$netstorage$mgmt$ui$shell$Messages = Command.class$("com.sun.netstorage.mgmt.ui.shell.Messages")) : class$com$sun$netstorage$mgmt$ui$shell$Messages, "`shell.msg.err.arguments`", new String[]{string, string2, string3}, 1, string, string2);
    }

    public CmdCompletion getOptionError(String string, String string2, String string3) {
        return this.getSytaxError(class$com$sun$netstorage$mgmt$ui$shell$Messages == null ? (class$com$sun$netstorage$mgmt$ui$shell$Messages = Command.class$("com.sun.netstorage.mgmt.ui.shell.Messages")) : class$com$sun$netstorage$mgmt$ui$shell$Messages, "`shell.msg.err.bad_option`", new String[]{string, string2, string3}, 2, string, string2);
    }

    public String getName() {
        return this.m_commandName;
    }

    public String getSubName() {
        return this.m_subCmdName;
    }

    protected final LogService getLogService() {
        return this.logger;
    }

    protected final AlarmService getAlarmService() {
        return this.alarm;
    }

    protected final Lookup getLookup() {
        return this.lookup;
    }

    public final String getDeviceId(String string, String string2) {
        return Command.getDeviceId(string, string2, this.logger);
    }

    public static final String getDeviceId(String string, String string2, LogService logService) {
        logService.trace((Serializable)((Object)("SYS = " + string2)));
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (-1 == string2.lastIndexOf(".")) {
            stringBuffer = new StringBuffer(string);
            if (!string.endsWith(".")) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected InputStream getStdin() {
        return this.myStdin;
    }

    protected OutputStream getStdout() {
        return this.myStdout;
    }

    protected OutputStream getStderr() {
        return this.myStderr;
    }

    void setIOStreams(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        this.myStdin = inputStream;
        this.myStdout = outputStream;
        this.myStderr = outputStream2;
    }

    void setLocale(Locale locale) {
        this.myLocale = locale;
    }

    public Locale getLocale() {
        return this.myLocale;
    }

    protected final FB lookupFB(String string, String string2) {
        if (null == this.lookup) {
            return null;
        }
        string = AbstractCmdHandler.getEffectiveId(this.lookup, string);
        return this.lookup.getFB(string2, new String[]{string}, true);
    }

    protected final MF lookupMF(String string) {
        if (null == this.lookup) {
            return null;
        }
        string = AbstractCmdHandler.getEffectiveId(this.lookup, string);
        return this.lookup.getMF(string);
    }

    public String getSystemName(String string) {
        if (null == this.lookup) {
            return null;
        }
        SubjectNode subjectNode = this.lookup.getNode(string);
        String string2 = (String)subjectNode.getValue("svc.name.display");
        return string2;
    }

    protected final Class getLogContext() {
        return this.myLogContext;
    }

    protected final void setLogContext(Class clazz) {
        this.myLogContext = clazz;
    }

    protected final String getLogComponent() {
        return this.myLogComponent;
    }

    protected final void setLogComponent(String string) {
        this.myLogComponent = string;
    }

    protected final String getLogDevice() {
        return this.myLogDevice;
    }

    protected final void setLogDevice(String string) {
        this.myLogDevice = string;
    }

    private void log(String string, LogLevel logLevel) {
        this.getLogService().log(this.getLogContext(), string, logLevel, this.getLogDevice(), this.getLogComponent());
    }

    private void log(String string, Serializable[] serializableArray, LogLevel logLevel) {
        this.getLogService().log(this.getLogContext(), string, serializableArray, logLevel, this.getLogDevice(), this.getLogComponent());
    }

    private void log(LocalizableMessage localizableMessage, LogLevel logLevel) {
        this.getLogService().log((Serializable)localizableMessage, logLevel, this.getLogDevice(), this.getLogComponent());
    }

    protected final void logAudit(String string) {
        this.log(string, LogLevel.AUDIT);
    }

    protected final void logAudit(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.AUDIT);
    }

    protected final void logAudit(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.AUDIT);
    }

    protected final void logTrace(String string) {
        this.log(string, LogLevel.TRACE);
    }

    protected final void logTrace(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.TRACE);
    }

    protected final void logTrace(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.TRACE);
    }

    protected final void logDebug(String string) {
        this.log(string, LogLevel.DEBUG);
    }

    protected final void logDebug(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.DEBUG);
    }

    protected final void logDebug(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.DEBUG);
    }

    protected final void logInfo(String string) {
        this.log(string, LogLevel.INFO);
    }

    protected final void logInfo(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.INFO);
    }

    protected final void logInfo(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.INFO);
    }

    protected final void logMinor(String string) {
        this.log(string, LogLevel.MINOR);
    }

    protected final void logMinor(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.MINOR);
    }

    protected final void logMinor(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.MINOR);
    }

    protected final void logMajor(String string) {
        this.log(string, LogLevel.MAJOR);
    }

    protected final void logMajor(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.MAJOR);
    }

    protected final void logMajor(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.MAJOR);
    }

    protected final void logCritical(String string) {
        this.log(string, LogLevel.CRITICAL);
    }

    protected final void logCritical(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.CRITICAL);
    }

    protected final void logCritical(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.CRITICAL);
    }

    protected final void logDown(String string) {
        this.log(string, LogLevel.DOWN);
    }

    protected final void logDown(String string, Serializable[] serializableArray) {
        this.log(string, serializableArray, LogLevel.DOWN);
    }

    protected final void logDown(LocalizableMessage localizableMessage) {
        this.log(localizableMessage, LogLevel.DOWN);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

