/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.console.login;

import com.sun.netstorage.mgmt.locale.LocalizableMessage;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.logic.cim.CimomFacade;
import com.sun.netstorage.mgmt.ui.console.login.Authentication;
import com.sun.netstorage.mgmt.ui.console.login.Messages;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Locale;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class CIMAuthentication
implements Authentication,
Messages {
    public static final String DEFAULT_CIM_NAMESPACE = "root\\cimv2";
    public static final String DEFAULT_CIM_HOSTNAME = "localhost";
    public static final int AUTHENTICATED = 0;
    public static final int AUTHENTICATED_ON_DEFAULT_HOST = 1;
    public static final int NOT_AUTHENTICATED = -1;
    String m_host;
    String m_namespace;
    static final boolean m_debug = false;
    private String m_msg = "`login.err.unknown_error`";
    private String[] m_msg_params = null;
    private static final String sccs_id = "@(#)CIMAuthentication.java 1.9    02/06/05 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$console$login$Messages;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$console$login$CIMAuthentication;

    public CIMAuthentication() {
        this(DEFAULT_CIM_HOSTNAME, DEFAULT_CIM_NAMESPACE);
    }

    public CIMAuthentication(String string, String string2) {
        this.m_host = null == string ? DEFAULT_CIM_HOSTNAME : string;
        this.m_namespace = null == string2 ? DEFAULT_CIM_NAMESPACE : string2;
    }

    public final int authUser(String string, String string2) {
        boolean bl = true;
        boolean bl2 = false;
        if (!this.authenticate(null, null, string, string2)) {
            String string3 = this.getAuthenticationFailureMsg();
            if (string3.equals("`login.err.unknown_cimom_host`") && this.authenticate(null, DEFAULT_CIM_HOSTNAME, string, string2)) {
                this.m_msg = "`login.info.localhost_revert`";
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public boolean authenticate(String string, String string2) {
        if (!this.authenticate(null, null, string, string2)) {
            String string3 = this.getAuthenticationFailureMsg();
            if (string3.equals("`login.err.unknown_cimom_host`") && !DEFAULT_CIM_HOSTNAME.equals(this.m_host)) {
                return this.authenticate(null, DEFAULT_CIM_HOSTNAME, string, string2);
            }
            return false;
        }
        return true;
    }

    public final boolean authenticate(String string, String string2, String string3, String string4) {
        CimomFacade cimomFacade;
        boolean bl = true;
        if (null == string) {
            string = this.m_namespace;
        }
        if (null == string2) {
            string2 = this.m_host;
        }
        if (null == string2 && null == (string2 = (cimomFacade = new CimomFacade()).getHostname())) {
            string2 = this.getLocalHost();
        }
        try {
            CIMAuthentication.trace(" creating CIMClient: ");
            CIMAuthentication.trace(" host      " + string2);
            CIMAuthentication.trace(" namespace " + string);
            CIMAuthentication.trace(" user      " + string3);
            CIMAuthentication.trace(" pass      ********");
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string2, string);
            CIMClient cIMClient = new CIMClient(cIMNameSpace, (Principal)new UserPrincipal(string3), (Object)new PasswordCredential(string4));
        }
        catch (CIMException cIMException) {
            String string5 = cIMException.getID();
            this.m_msg = "`login.err.unknown_error`";
            if (string5.equals("NO_SUCH_PRINCIPAL") || string5.equals("INVALID_CREDENTIAL")) {
                this.m_msg = "`login.err.inv_user_passwd`";
                this.m_msg_params = new String[]{null == string3 ? "unknown" : ("".equals(string3) ? "unknown" : string3)};
            } else if (string5.equals("UNKNOWNHOST")) {
                System.err.println("Invalid CIM Host");
                this.m_msg = "`login.err.unknown_cimom_host`";
                this.m_msg_params = new String[]{null == this.m_host ? "unknown" : ("".equals(this.m_host) ? "unknown" : this.m_host)};
            } else if (string5.equals("NO_CIMOM") || string5.equals("RMIERROR")) {
                this.m_msg = "`login.err.no_cimom_found`";
            } else if (string5.equals("TIMED_OUT")) {
                this.m_msg = "`login.err.cim_timeout`";
            } else if (string5.equals("VER_ERROR")) {
                this.m_msg = "`login.err.inv_cim_ver`";
            }
            CIMAuthentication.trace("r = " + this.m_msg);
            bl = false;
        }
        return bl;
    }

    public String getAuthenticationFailureMsg() {
        return this.m_msg;
    }

    public String getAuthenticationFailureMsg(Locale locale) {
        return Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$console$login$Messages == null ? (class$com$sun$netstorage$mgmt$ui$console$login$Messages = CIMAuthentication.class$("com.sun.netstorage.mgmt.ui.console.login.Messages")) : class$com$sun$netstorage$mgmt$ui$console$login$Messages), (String)this.m_msg, (Object[])this.m_msg_params, (Locale)locale);
    }

    public String[] getAuthenticationFailureMsgParams() {
        return this.m_msg_params;
    }

    public LocalizableMessage getLocalizableFailureMsg() {
        return new LocalizableMessage(class$com$sun$netstorage$mgmt$ui$console$login$Messages == null ? (class$com$sun$netstorage$mgmt$ui$console$login$Messages = CIMAuthentication.class$("com.sun.netstorage.mgmt.ui.console.login.Messages")) : class$com$sun$netstorage$mgmt$ui$console$login$Messages, this.m_msg, (Serializable[])this.m_msg_params);
    }

    private String getLocalHost() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception2) {
                string = DEFAULT_CIM_HOSTNAME;
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        if (4 != stringArray.length) {
            System.out.println("Usage: java " + (class$com$sun$netstorage$mgmt$ui$console$login$CIMAuthentication == null ? (class$com$sun$netstorage$mgmt$ui$console$login$CIMAuthentication = CIMAuthentication.class$("com.sun.netstorage.mgmt.ui.console.login.CIMAuthentication")) : class$com$sun$netstorage$mgmt$ui$console$login$CIMAuthentication).getName() + " host namespace user password ");
            return;
        }
        CIMAuthentication cIMAuthentication = new CIMAuthentication(stringArray[0], stringArray[1]);
        if (cIMAuthentication.authenticate(stringArray[2], stringArray[3])) {
            System.out.println(" Login was successful!");
        } else {
            System.out.println(" Login was NOT successful.");
        }
    }

    public static void trace(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

