/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli;

import com.sun.netstorage.mgmt.inet.InetDaemonProperties;
import com.sun.netstorage.mgmt.io.terminal.TerminalInputStream;
import com.sun.netstorage.mgmt.io.terminal.TerminalOutputStream;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.ui.cli.CliBuiltIn;
import com.sun.netstorage.mgmt.ui.cli.Utils;
import com.sun.netstorage.mgmt.ui.shell.Ascii;
import com.sun.netstorage.mgmt.ui.shell.Environment;
import com.sun.netstorage.mgmt.ui.shell.ShellImpl;
import com.sun.netstorage.mgmt.util.StringUtils;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;

public class StorEdgeShell
extends ShellImpl
implements Ascii {
    private static final boolean debug = false;
    private TerminalOutputStream tout = null;
    private String myPS1;
    private String myPS2;
    private String myPS3;
    private String[] myPATH;
    private static final String myClass = "com.sun.netstorage.mgmt.ui.cli.StorEdgeShell";
    public static final String WELCOME_MSG = "`shell.msg.welcome`";
    public static final String DEF_WELCOME_MSG = "Welcome to the StorEdge Shell V1.2";
    public static final String MOTD_PATH = "shell.path.motd";
    public static final String DEF_MOTD_PATH = "/opt/SUNWgthm/etc/motd";
    public static final String PS1_PROP = "shell.prompt.PS1";
    public static final String DEF_PS1 = "SeSh ";
    public static final String PS2_PROP = "shell.prompt.PS2";
    public static final String DEF_PS2 = "_> ";
    public static final String PS3_PROP = "shell.prompt.PS3";
    public static final String DEF_PS3 = "_> ";
    public static final int PATH_SIZE = 64;
    private static final int STARTED = 0;
    private static final int PROMPT = 1;
    private static final int WAITING = 2;
    private static final int ERRFLG = 4;
    private static final int PROCESS = 8;
    private static final int BACKWARD = 16;
    private static final int FORWARD = 32;
    private static final int UNKESCAPE = 64;
    private int myState = 0;
    private int sqNesting = 0;
    private int dqNesting = 0;
    private boolean oneShot;
    private ActivityThread myActivityThread;
    private static final int myInterval = InetDaemonProperties.getTimeToWarn() / 2;
    static final String sccs_id = "@(#)StorEdgeShell.java 1.31 02/12/16 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$shell$Messages;

    public StorEdgeShell(Environment environment, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, Locale locale, Lookup lookup) {
        super(environment, inputStream, outputStream, outputStream2, lookup, locale, CliBuiltIn.EXIT, true);
        if (outputStream instanceof TerminalOutputStream) {
            this.tout = (TerminalOutputStream)outputStream;
            int n = this.tout.getRows();
            if (n <= 0) {
                n = 24;
            }
            this.myNames.setProperty("LINES", Integer.toString(n));
            n = this.tout.getColumns();
            if (n <= 0) {
                n = 80;
            }
            this.myNames.setProperty("COLS", Integer.toString(n));
        }
        boolean bl = this.oneShot = !(inputStream instanceof TerminalInputStream);
        if (!this.oneShot) {
            this.oneShot = "notty".equals(environment.getProperty("TERM"));
        }
        this.myPS1 = Utils.getProperty(this.getClass(), myClass, PS1_PROP, DEF_PS1);
        this.myPS2 = Utils.getProperty(this.getClass(), myClass, PS2_PROP, "_> ");
        this.myPS3 = Utils.getProperty(this.getClass(), myClass, PS3_PROP, "_> ");
        this.myNames.setProperty("PS1", this.myPS1);
        this.myNames.setProperty("PS2", this.myPS2);
        this.myNames.setProperty("PS3", this.myPS3);
        this.myPATH = new String[64];
        this.myActivityThread = new ActivityThread();
        this.myActivityThread.start();
    }

    public void run() {
        if (!this.oneShot) {
            this.doMotd();
            this.doWelcome();
            try {
                this.out.write(10);
                this.out.write(this.buildPrompt().getBytes());
                this.out.flush();
            }
            catch (IOException iOException) {
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = -1;
        char c = '\u0000';
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        this.myState = 2;
        int n4 = -1;
        while (!bl) {
            n2 = n;
            try {
                String string;
                n = this.in.read();
                c = (char)n;
                int n5 = 0;
                if (this.myState == 64 || n == 1001 || n == 1002) {
                    if (n == 107 || n == 1001) {
                        n4 = -1 == n4 ? this.getLastEntryIndex() : --n4;
                        n5 = 16;
                    } else if (n == 106 || n == 1002) {
                        ++n4;
                        n5 = 32;
                    } else {
                        this.myState = 2;
                    }
                }
                if (0 != n5) {
                    this.tout.moveLeft(n3);
                    this.tout.eraseToEndOfLine();
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    n3 = 0;
                    if (n4 >= 0 && null != (string = this.getHistory(n4 - 1))) {
                        this.tout.write(string.getBytes());
                        n3 = string.length();
                        stringBuffer.append(string);
                        stringBuffer2.append(string);
                    }
                    this.out.flush();
                    continue;
                }
                if (n == 1202) {
                    this.myState = 64;
                    continue;
                }
                if (n == 1305) {
                    bl = true;
                    continue;
                }
                if (n == 1304) {
                    if (this.oneShot) continue;
                    this.out.write(94);
                    this.out.write(65);
                    continue;
                }
                if (n != 10 && n != 1303 && n != 1302 && n != 1004 && n != 1003 && n != 1001 && n != 1002 && n != 1306 && n != -1 && !this.oneShot) {
                    if (n == 18 || n == 15) {
                        if (n == 15) {
                            this.out.write(94);
                            this.out.write(79);
                        }
                        this.out.write(94);
                        this.out.write(82);
                        this.out.write(10);
                        this.out.write(stringBuffer2.toString().getBytes());
                    } else {
                        if (n == 21) {
                            n3 = stringBuffer.length();
                            stringBuffer.setLength(0);
                            stringBuffer2.setLength(0);
                            if (!this.oneShot && null != this.tout && n3 >= 0) {
                                this.tout.moveLeft(n3);
                                this.tout.eraseToEndOfLine();
                            }
                            this.myState = 2;
                            n3 = 0;
                            this.sqNesting = 0;
                            this.dqNesting = 0;
                            continue;
                        }
                        if (n < 32) {
                            stringBuffer2.append('^').append((char)(n + 64));
                            this.out.write(94);
                            this.out.write((char)(n + 64));
                            if (n == 3) {
                                this.out.write("\r\n".getBytes());
                                this.out.write(this.buildPrompt().getBytes());
                                stringBuffer.setLength(0);
                                stringBuffer2.setLength(0);
                                n3 = 0;
                                this.sqNesting = 0;
                                this.dqNesting = 0;
                            }
                        } else {
                            stringBuffer2.append(c);
                            this.out.write(c);
                        }
                    }
                }
                if (n == 1306) {
                    return;
                }
                if (this.oneShot && n == -1) {
                    this.myState = 8;
                } else {
                    if (n == 1303 || n == 1302 || n == 8) {
                        char c2;
                        int n6 = stringBuffer.length();
                        if (n6 <= 0) continue;
                        int n7 = stringBuffer.charAt(n6 - 1);
                        if (n6 - 1 > 0 && (c2 = stringBuffer.charAt(n6 - 2)) == '\\' && (n7 == 39 || n7 == 34)) {
                            n7 = 32;
                        }
                        stringBuffer.setLength(n6 - 1);
                        stringBuffer2.setLength(n6 - 1);
                        n3 = stringBuffer.length();
                        if (!this.oneShot && null != this.tout && n3 >= 0) {
                            this.tout.moveLeft(1);
                            this.tout.eraseToEndOfLine();
                        }
                        if (n7 == 39) {
                            if (0 != this.dqNesting) continue;
                            this.sqNesting = 0 == this.sqNesting ? 1 : 0;
                            continue;
                        }
                        if (n7 != 34 || 0 != this.sqNesting) continue;
                        this.dqNesting = 0 == this.dqNesting ? 1 : 0;
                        continue;
                    }
                    if (n == 39) {
                        stringBuffer.append(c);
                        stringBuffer2.append(c);
                        ++n3;
                        if (n2 != 92 && 0 == this.dqNesting) {
                            this.sqNesting = 0 == this.sqNesting ? 1 : 0;
                        }
                    } else if (n == 34) {
                        stringBuffer.append(c);
                        stringBuffer2.append(c);
                        ++n3;
                        if (n2 != 92 && 0 == this.sqNesting) {
                            this.dqNesting = 0 == this.dqNesting ? 1 : 0;
                        }
                    } else if (n == 59) {
                        stringBuffer.append(c);
                        stringBuffer2.append(c);
                        ++n3;
                    } else if (n == 10) {
                        this.myState = 8;
                        if (n2 == 92) {
                            stringBuffer.delete(n3 - 1, n3);
                            stringBuffer2.delete(n3 - 1, n3);
                            --n3;
                            this.myState = 1;
                        } else if (this.dqNesting != 0 || this.sqNesting != 0) {
                            this.myState = 1;
                        }
                    } else {
                        stringBuffer.append(c);
                        ++n3;
                    }
                }
                if (this.myState == 1) {
                    this.out.write(10);
                    this.out.write(this.myPS2.getBytes());
                    this.out.flush();
                    this.myState = 2;
                    continue;
                }
                if (this.myState != 8) continue;
                if (!this.oneShot) {
                    this.out.write("\r\n".getBytes());
                }
                if (!(string = stringBuffer.toString().trim()).equals("")) {
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    n3 = 0;
                    n4 = -1;
                    this.lastStatus = this.processCmd(string);
                    if (null != this.lastCmd) {
                        boolean bl2 = bl = this.lastCmd.equals(CliBuiltIn.QUIT) || this.lastCmd.equals(CliBuiltIn.LOGOUT) || this.lastCmd.equals(CliBuiltIn.EXIT);
                    }
                }
                if (this.oneShot && n == -1) {
                    bl = true;
                }
                if (!bl && !this.oneShot) {
                    this.out.write(this.buildPrompt().getBytes());
                }
                this.out.flush();
                this.myState = 2;
                n2 = -1;
            }
            catch (IOException iOException) {
                bl = true;
            }
            catch (Throwable throwable) {
                this.logger.trace("caught exception: " + StringUtils.getStackTrace((Throwable)throwable));
                this.setVariable("LAST_EXCEPTION", StringUtils.getStackTrace((Throwable)throwable));
                String string = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$shell$Messages == null ? StorEdgeShell.class$("com.sun.netstorage.mgmt.ui.shell.Messages") : class$com$sun$netstorage$mgmt$ui$shell$Messages), (String)"`shell.msg.err.internal_error`", (Object[])new Serializable[]{"sesh"});
                try {
                    this.err.write((string + "\r\n").getBytes());
                    this.err.flush();
                    this.out.write(this.buildPrompt().getBytes());
                    this.out.flush();
                    this.myState = 2;
                    n2 = -1;
                }
                catch (IOException iOException) {
                    bl = true;
                }
            }
        }
    }

    private void doMotd() {
        String string = Utils.getProperty(this.getClass(), myClass, MOTD_PATH, DEF_MOTD_PATH);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            while (n > 0) {
                int n2 = fileInputStream.read();
                this.out.write(n2);
                --n;
            }
            this.out.flush();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {}
    }

    private void doWelcome() {
        String string = Utils.getProperty(this.getClass(), myClass, WELCOME_MSG, DEF_WELCOME_MSG);
        try {
            this.out.write(("\r\n" + string + "\r\n").getBytes());
            this.out.flush();
        }
        catch (IOException iOException) {}
    }

    private int processCmd(String string) {
        if (null == string) {
            return 0;
        }
        this.myActivityThread.activity();
        this.addToHistory(string);
        if (this.getDashX()) {
            try {
                this.out.write(43);
                this.out.write(32);
                this.out.write(string.getBytes());
                this.out.write("\r\n".getBytes());
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string.trim().startsWith(";")) {
            String string2 = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$shell$Messages == null ? (class$com$sun$netstorage$mgmt$ui$shell$Messages = StorEdgeShell.class$("com.sun.netstorage.mgmt.ui.shell.Messages")) : class$com$sun$netstorage$mgmt$ui$shell$Messages), (String)"`shell.msg.err.unexpected`", (Object[])new Serializable[]{"sesh", string});
            try {
                this.out.write(string2.getBytes());
                this.out.write("\r\n".getBytes());
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 2;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        int n = 0;
        try {
            String[] stringArray;
            while (null != (stringArray = this.getTokens(streamTokenizer)) && stringArray.length > 0) {
                n = this.processCmd(stringArray[0], stringArray);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myActivityThread.done();
        return n;
    }

    private String[] getTokens(StreamTokenizer streamTokenizer) throws EOFException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string = null;
        String string2 = null;
        int n = 0;
        String string3 = null;
        this.setupTokenizer(streamTokenizer);
        bl = false;
        while (!bl) {
            n = streamTokenizer.nextToken();
            block1 : switch (n) {
                case -1: {
                    bl = true;
                    break;
                }
                case 10: {
                    bl = true;
                    break;
                }
                case -2: {
                    string = new Double(streamTokenizer.nval).toString();
                    break;
                }
                case -3: {
                    string = streamTokenizer.sval;
                    if (null == string3) {
                        string3 = string;
                    }
                    int n2 = streamTokenizer.nextToken();
                    boolean bl2 = true;
                    block7 : switch (n2) {
                        case -1: {
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case -2: {
                            break;
                        }
                        case -3: {
                            break;
                        }
                        default: {
                            switch (streamTokenizer.ttype) {
                                case 61: {
                                    if (0 != arrayList.size()) break block7;
                                    string2 = string;
                                    string = "#a#s#s#i#g#n#";
                                    string3 = "#a#s#s#i#g#n#";
                                    bl2 = false;
                                    break block7;
                                }
                                case 34: {
                                    if (!string.endsWith("\\")) break block7;
                                    string = string.substring(0, string.length() - 1);
                                    string = string + "\"" + streamTokenizer.sval;
                                    bl2 = false;
                                    break block7;
                                }
                                case 39: {
                                    if (!string.endsWith("\\")) break block7;
                                    string = string.substring(0, string.length() - 1);
                                    string = string + "'" + streamTokenizer.sval;
                                    bl2 = false;
                                }
                            }
                        }
                    }
                    if (bl2) {
                        streamTokenizer.pushBack();
                    }
                    int n3 = string.indexOf("\\");
                    while (n3 != -1) {
                        string = string.substring(0, n3) + string.substring(n3 + 1, string.length());
                        n3 = string.indexOf("\\", n3);
                    }
                    break;
                }
                default: {
                    switch (streamTokenizer.ttype) {
                        case 34: {
                            if (null == streamTokenizer.sval) {
                                string = "\"";
                                break block1;
                            }
                            string = streamTokenizer.sval;
                            break block1;
                        }
                        case 39: {
                            if (null == streamTokenizer.sval) {
                                string = "'";
                                break block1;
                            }
                            string = streamTokenizer.sval;
                            break block1;
                        }
                        case 59: {
                            bl = true;
                            string = streamTokenizer.sval;
                            break block1;
                        }
                        case 61: {
                            if (0 != arrayList.size()) break block1;
                            string2 = string;
                            string3 = "#a#s#s#i#g#n#";
                        }
                    }
                }
            }
            String string4 = string;
            if (null == string4) continue;
            string4 = this.varReplace(string4);
            if (null == string3) {
                string3 = string4;
            }
            if ("#a#s#s#i#g#n#".equals(string4)) {
                arrayList.add("set");
                arrayList.add(string2);
            } else {
                arrayList.add(string4);
            }
            string = null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getVal(String string) {
        String string2 = this.myNames.getProperty(string);
        return null == string2 ? "" : string2;
    }

    private String varReplace(String string) {
        if ("$?".equals(string)) {
            return Integer.toString(this.getLastStatus());
        }
        String string2 = string;
        int n = string.length();
        if (0 == string.indexOf(36) && n > 1) {
            string2 = 1 == string.indexOf(123) && n - 1 == string.indexOf(125) && n > 3 ? this.getVal(string.substring(2, n - 1)) : this.getVal(string.substring(1));
        }
        return string2;
    }

    private void setupTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.slashSlashComments(false);
        streamTokenizer.slashStarComments(false);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(36, 47);
        streamTokenizer.wordChars(48, 58);
        streamTokenizer.wordChars(63, 90);
        streamTokenizer.wordChars(91, 95);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(123, 126);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        streamTokenizer.commentChar(35);
        streamTokenizer.eolIsSignificant(true);
    }

    private String buildPrompt() {
        return this.myPS1 + '[' + (this.lHist + 1) + "] ";
    }

    public void setOption(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ActivityThread
    extends Thread {
        private boolean isActive = false;

        private ActivityThread() {
            super(InetDaemonProperties.getInetThreadGroup(), "CLI.ActivityThread");
        }

        public void run() {
            while (true) {
                this.update();
            }
        }

        protected synchronized void activity() {
            this.isActive = true;
            this.notifyAll();
        }

        protected synchronized void done() {
            this.isActive = false;
            this.notifyAll();
        }

        protected synchronized void update() {
            if (this.isActive) {
                try {
                    if (StorEdgeShell.this.getStdin() instanceof TerminalInputStream) {
                        ((TerminalInputStream)StorEdgeShell.this.getStdin()).activity();
                    }
                    this.wait(myInterval);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

