/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.array.t3.config;

import com.sun.netstorage.mgmt.dm.t3.logic.fb.config.aggregate.CreateVLUNImpl;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.services.configuration.device.context.Context;
import com.sun.netstorage.mgmt.services.configuration.device.context.VolumeContext;
import com.sun.netstorage.mgmt.services.configuration.device.context.VolumeStatusBean;
import com.sun.netstorage.mgmt.ui.framework.ViewBean;
import com.sun.netstorage.mgmt.ui.util.PropertyDataModel;
import java.util.Locale;

public class LunCreateViewBean
extends ViewBean {
    static final String DEFAULT_NAME = "luncreateBean";
    static final String DEFAULT_PATH = "/jsp/array/t3/config/luncreate.jsp";
    static final String[] FS_HEADER = new String[]{" ", "config.addlun.blockspace", "config.addlun.blockspace.unit"};
    final String id;
    final VolumeContext ctx;
    final String[] vols;
    final int[] availableLuns;
    final int totalUncarvedSpace;
    final String[] desc = new String[]{"config.addlun.step1", "config.addlun.step2", "config.addlun.step3"};
    int step = 0;
    String volId = null;
    String lunNo = null;
    float desiredSize = -1.0f;
    String scale = null;
    String blockSize = null;
    String perm = null;
    static final String sccs_id = "@(#)LunCreateViewBean.java 1.12    02/12/23 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages;

    public LunCreateViewBean(String string, VolumeContext volumeContext, Locale locale) {
        super(DEFAULT_NAME, DEFAULT_PATH, locale);
        this.id = string;
        this.ctx = volumeContext;
        this.vols = this.grepVolList();
        this.availableLuns = CreateVLUNImpl.getAvailableLUNs((Context)volumeContext);
        this.totalUncarvedSpace = LunCreateViewBean.getTotalUncarvedVolumeSpace(volumeContext);
    }

    String[] grepVolList() {
        if (this.ctx == null) {
            return null;
        }
        String[] stringArray = null;
        VolumeStatusBean[] volumeStatusBeanArray = this.ctx.getStatusBeans();
        if (volumeStatusBeanArray != null) {
            stringArray = new String[volumeStatusBeanArray.length];
            int n = 0;
            while (n < volumeStatusBeanArray.length) {
                stringArray[n] = volumeStatusBeanArray[n].getName();
                ++n;
            }
        }
        return stringArray;
    }

    public String getID() {
        return this.id;
    }

    public String[] getVolumeList() {
        return this.vols;
    }

    public String getVolumeID() {
        return this.volId;
    }

    public void setVolumeID(String string) {
        this.volId = string;
    }

    public String[] getStepDescription() {
        return this.getStepDescription(Locale.getDefault());
    }

    public String[] getStepDescription(Locale locale) {
        int n = this.desc.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? LunCreateViewBean.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages") : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages), (String)this.desc[n2], (Locale)locale);
            ++n2;
        }
        return stringArray;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public int[] getAvailableLunNumbers() {
        return this.availableLuns;
    }

    public String getLunNumber() {
        return this.lunNo;
    }

    public void setLunNumber(String string) {
        this.lunNo = string;
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(String string) {
        this.blockSize = string;
    }

    public String getScale() {
        return this.scale;
    }

    public void setScale(String string) {
        this.scale = string;
    }

    public float getSize() {
        return this.desiredSize;
    }

    public void setSize(float f) {
        this.desiredSize = f;
    }

    public String getPermission() {
        return this.perm;
    }

    public void setPermission(String string) {
        this.perm = string;
    }

    public PropertyDataModel getFreeBlockList(String string) {
        if (string == null || this.ctx == null) {
            return null;
        }
        float[] fArray = CreateVLUNImpl.getAvailableBlocks((VolumeContext)this.ctx, (String)string);
        if (fArray == null) {
            return null;
        }
        Object[][] objectArray = new String[fArray.length][3];
        int n = 0;
        while (n < fArray.length) {
            if ((double)fArray[n] >= 1.0) {
                String string2 = "" + fArray[n];
                objectArray[n][1] = string2;
                objectArray[n][0] = string2;
                objectArray[n][2] = "GB";
            } else {
                objectArray[n][0] = "" + fArray[n];
                objectArray[n][1] = "" + fArray[n] * 1000.0f;
                objectArray[n][2] = "MB";
            }
            ++n;
        }
        PropertyDataModel propertyDataModel = new PropertyDataModel("config.addlun.blocks", FS_HEADER, objectArray, (Object)(class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages == null ? (class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages = LunCreateViewBean.class$("com.sun.netstorage.mgmt.ui.array.t3.config.ConfigMessages")) : class$com$sun$netstorage$mgmt$ui$array$t3$config$ConfigMessages));
        return propertyDataModel;
    }

    public String[] getAvailablePermissions() {
        return new String[]{"none", "ro", "rw"};
    }

    public int getTotalUncarvedSpace() {
        return this.totalUncarvedSpace;
    }

    public static int getTotalUncarvedVolumeSpace(VolumeContext volumeContext) {
        if (volumeContext == null || !volumeContext.isVolsBasedOnPSExtentsSupported()) {
            return 0;
        }
        VolumeStatusBean[] volumeStatusBeanArray = volumeContext.getStatusBeans();
        if (volumeStatusBeanArray == null || volumeStatusBeanArray.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < volumeStatusBeanArray.length) {
            long[] lArray = volumeStatusBeanArray[n2].getAvailableSpaces();
            if (lArray != null || lArray.length > 0) {
                int n3 = 0;
                while (n3 < lArray.length) {
                    int n4 = (int)(lArray[n3] / 1000L);
                    n += n4;
                    ++n3;
                }
            }
            ++n2;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

