/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.net;

import com.sun.netstorage.mgmt.inet.InetDaemonProperties;
import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.net.BootException;
import com.sun.netstorage.mgmt.net.Connection;
import com.sun.netstorage.mgmt.net.ConnectionData;
import com.sun.netstorage.mgmt.net.ConnectionEvent;
import com.sun.netstorage.mgmt.net.ConnectionQueue;
import com.sun.netstorage.mgmt.net.Constants;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import dtw.telnetd.net.ConnectionFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class ConnectionManager
extends Thread
implements Constants {
    private ThreadGroup myThreadGroup = InetDaemonProperties.getInetThreadGroup();
    private Vector myConnections;
    private Vector brokenConnections;
    private Vector closedConnections;
    private ConnectionQueue myCQ;
    private ConnectionFilter myCFilter;
    private boolean active;
    private int maxconnections;
    private int warning_timeout;
    private int disconnect_timeout;
    private int housekeepinginterval;
    private String loginCls;
    private String ioCls;
    private Lookup lookup;
    private LogTracer logger;
    private static final HashMap cMap = new HashMap();
    static final String sccs_id = "@(#)ConnectionManager.java 1.5\t02/11/15 SMI";

    private ConnectionManager(int n, int n2, int n3, int n4, int n5, int n6, String string, String string2, Lookup lookup, LogTracer logTracer) {
        this.myConnections = new Vector(n);
        this.myConnections.ensureCapacity(n);
        this.brokenConnections = new Vector(20);
        this.closedConnections = new Vector(20);
        this.myCQ = new ConnectionQueue(n2);
        this.myCFilter = null;
        this.maxconnections = n;
        this.warning_timeout = n3;
        this.disconnect_timeout = n4;
        this.housekeepinginterval = n5;
        this.active = true;
        this.loginCls = string;
        this.ioCls = string2;
        this.lookup = lookup;
        this.logger = logTracer;
    }

    public void run() {
        try {
            while (this.active) {
                this.cleanupClosed();
                this.cleanupBroken();
                this.checkConnections();
                this.checkQueue();
                ConnectionManager.sleep(this.housekeepinginterval);
            }
        }
        catch (Exception exception) {
            this.logger.log(new String[]{"got exception" + exception.toString()});
        }
    }

    private final void cleanupClosed() {
        while (this.closedConnections.size() != 0) {
            Connection connection = (Connection)this.closedConnections.firstElement();
            this.logger.trace(new String[]{this.toString() + ":Cleaning up closed connection:" + connection.toString()});
            connection.stop();
            this.closedConnections.removeElementAt(0);
            if (this.myCQ.getQueueStatus()) {
                try {
                    this.doConnect(this.myCQ.connectFromQueue());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.myConnections.removeElement(connection);
        }
    }

    private final void cleanupBroken() {
        while (this.brokenConnections.size() != 0) {
            Connection connection = (Connection)this.brokenConnections.firstElement();
            this.logger.trace(new String[]{this.toString() + ":Closing broken connection:" + connection.toString()});
            connection.processConnectionEvent(new ConnectionEvent(connection, 103));
            connection.close();
            this.brokenConnections.removeElementAt(0);
        }
    }

    private final void checkConnections() {
        Enumeration enumeration = this.myConnections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            ConnectionData connectionData = connection.getConnectionData();
            long l = System.currentTimeMillis() - connectionData.getLastActivity();
            if (l <= (long)this.warning_timeout) continue;
            if (l > (long)(this.disconnect_timeout + this.warning_timeout)) {
                this.logger.trace(new String[]{connection.toString() + " exceeded total timeout."});
                connection.processConnectionEvent(new ConnectionEvent(connection, 101));
                connection.close();
                continue;
            }
            if (connectionData.isWarned()) continue;
            this.logger.log(new String[]{connection.toString() + " exceeded warning timeout."});
            connectionData.setWarned(true);
            connection.processConnectionEvent(new ConnectionEvent(connection, 100));
        }
    }

    private final void checkQueue() {
    }

    public final String getSessionClassName() {
        return this.loginCls;
    }

    public final String getIOHandlerClassName() {
        return this.ioCls;
    }

    public final void registerBrokenConnection(Connection connection) {
        if (!this.brokenConnections.contains(connection)) {
            this.brokenConnections.addElement(connection);
        }
    }

    public final void registerClosedConnection(Connection connection) {
        if (!this.closedConnections.contains(connection)) {
            this.closedConnections.addElement(connection);
        }
    }

    public final void makeConnection(Socket socket) {
        if (this.myCFilter == null || this.myCFilter != null && this.myCFilter.isAllowed(socket.getInetAddress())) {
            ConnectionData connectionData = new ConnectionData(socket, this);
            if (this.myConnections.size() < this.maxconnections) {
                try {
                    this.doConnect(connectionData);
                }
                catch (IOException iOException) {}
            } else {
                this.myCQ.addToQueue(connectionData);
            }
        } else {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private final void doConnect(ConnectionData connectionData) throws IOException {
        Connection connection = new Connection(this.myThreadGroup, connectionData, this.lookup, this.logger);
        Object[] objectArray = new Object[]{new Integer(this.myConnections.size() + 1)};
        this.logger.trace(new String[]{MessageFormat.format("connection #{0,number ,integer} made.", objectArray)});
        this.myConnections.addElement(connection);
        connection.start();
    }

    public final void shutdown() {
        this.active = false;
        this.myCQ.informQueuedOfShutdown();
        this.informConnectedOfShutdown();
    }

    public final void setConnectionFilter(ConnectionFilter connectionFilter) {
        this.myCFilter = connectionFilter;
    }

    public final ConnectionFilter getConnectionFilter() {
        return this.myCFilter;
    }

    private synchronized void informConnectedOfShutdown() {
        int n = 0;
        Enumeration enumeration = this.myConnections.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Connection connection = (Connection)enumeration.nextElement();
                connection.close();
            }
            catch (Exception exception) {
                this.logger.log(new String[]{"exception caught " + exception.toString()});
            }
            this.myConnections.removeElementAt(n++);
        }
    }

    public final int getWarningTimeout() {
        return this.warning_timeout;
    }

    public final int getDisconnectTimeout() {
        return this.disconnect_timeout;
    }

    private final PrintStream getStream(Socket socket) throws IOException {
        return new PrintStream(socket.getOutputStream());
    }

    public static ConnectionManager createConnectionManager(Properties properties, Lookup lookup, LogTracer logTracer) throws BootException {
        try {
            int n = Integer.parseInt(properties.getProperty("net.maxconnections"));
            int n2 = Integer.parseInt(properties.getProperty("net.queuelength"));
            int n3 = Integer.parseInt(properties.getProperty("net.time.warn"));
            int n4 = Integer.parseInt(properties.getProperty("net.time.disconnect"));
            int n5 = Integer.parseInt(properties.getProperty("net.time.housekeeping"));
            int n6 = Integer.parseInt(properties.getProperty("net.port"));
            Integer n7 = new Integer(n6);
            String string = properties.getProperty("net.session.class");
            String string2 = properties.getProperty("net.iohandler.class");
            ConnectionManager connectionManager = null;
            if (!cMap.containsKey(n7)) {
                connectionManager = new ConnectionManager(n, n2, n3, n4, n5, n6, string, string2, lookup, logTracer);
                cMap.put(n7, connectionManager);
                connectionManager.setPriority(7);
            }
            return connectionManager;
        }
        catch (Exception exception) {
            logTracer.log(new String[]{"exception caught " + exception.toString()});
            throw new BootException("Failure while creating ConnectionManger instance:\n" + exception.getMessage());
        }
    }
}

