/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.net;

import com.sun.netstorage.mgmt.net.ConnectionManager;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Locale;

public class ConnectionData {
    private ConnectionManager myCM;
    private Socket mySocket;
    private InetAddress ipAddr;
    private String hostName;
    private String hostAddress;
    private int port;
    private Locale myLocale;
    private long lastactivity;
    private boolean warned;
    private String negotiatedTerminalType;
    private int[] terminalGeometry;
    private boolean terminalGeometryChanged = true;
    static final String sccs_id = "@(#)ConnectionData.java 1.3\t02/01/09 SMI";

    public ConnectionData(Socket socket, ConnectionManager connectionManager) {
        this.mySocket = socket;
        this.myCM = connectionManager;
        this.ipAddr = socket.getInetAddress();
        this.hostName = this.ipAddr.getHostName();
        this.hostAddress = this.ipAddr.getHostAddress();
        this.myLocale = this.evaluateLocale();
        this.port = socket.getPort();
        this.terminalGeometry = new int[]{80, 25};
        this.negotiatedTerminalType = "default";
        this.activity();
    }

    public ConnectionManager getManager() {
        return this.myCM;
    }

    public Socket getSocket() {
        return this.mySocket;
    }

    public String getSessionClassName() {
        return this.myCM.getSessionClassName();
    }

    public String getIOHandlerClassName() {
        return this.myCM.getIOHandlerClassName();
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public InetAddress getInetAddress() {
        return this.ipAddr;
    }

    public Locale getLocale() {
        return this.myLocale;
    }

    public long getLastActivity() {
        return this.lastactivity;
    }

    public void activity() {
        this.warned = false;
        this.lastactivity = System.currentTimeMillis();
    }

    public void setWarned(boolean bl) {
        this.warned = bl;
        if (!bl) {
            this.lastactivity = System.currentTimeMillis();
        }
    }

    public boolean isWarned() {
        return this.warned;
    }

    public void setTerminalGeometry(int n, int n2) {
        this.terminalGeometry[0] = n;
        this.terminalGeometry[1] = n2;
        this.terminalGeometryChanged = true;
    }

    public int[] getTerminalGeometry() {
        if (this.terminalGeometryChanged) {
            this.terminalGeometryChanged = false;
        }
        return this.terminalGeometry;
    }

    public int getTerminalColumns() {
        return this.terminalGeometry[0];
    }

    public int getTerminalRows() {
        return this.terminalGeometry[1];
    }

    public boolean isTerminalGeometryChanged() {
        return this.terminalGeometryChanged;
    }

    public void setNegotiatedTerminalType(String string) {
        this.negotiatedTerminalType = string;
    }

    public String getNegotiatedTerminalType() {
        return this.negotiatedTerminalType;
    }

    private Locale evaluateLocale() {
        Locale locale = Locale.US;
        String string = this.getHostName();
        try {
            string = string.substring(string.lastIndexOf(".") - 1);
            if (string.equals("jp")) {
                this.myLocale = Locale.JAPANESE;
            } else if (string.equals("cn")) {
                this.myLocale = Locale.SIMPLIFIED_CHINESE;
            } else if (string.equals("de")) {
                this.myLocale = Locale.GERMANY;
            } else if (string.equals("it")) {
                this.myLocale = Locale.ITALY;
            } else if (string.equals("fr")) {
                this.myLocale = Locale.FRANCE;
            } else if (string.equals("uk")) {
                this.myLocale = new Locale("en", "GB");
            } else if (string.equals("au")) {
                this.myLocale = new Locale("en", "AU");
            } else if (string.equals("mx")) {
                this.myLocale = new Locale("es", "MX");
            } else if (string.equals("es")) {
                this.myLocale = new Locale("es", "ES");
            } else if (string.equals("at")) {
                this.myLocale = new Locale("de", "AT");
            }
        }
        catch (Exception exception) {}
        return locale;
    }
}

