/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.io.terminal;

import com.sun.netstorage.mgmt.net.BootException;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import com.sun.netstorage.mgmt.ui.shell.LogTracerImpl;
import dtw.telnetd.io.terminal.Terminal;
import dtw.telnetd.util.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class TerminalManager {
    private static final boolean debug = false;
    private static TerminalManager Self;
    private Hashtable myTerminals = new Hashtable(10);
    private static LogTracer logger;
    private static Properties terms;
    static final String sccs_id = "@(#)TerminalManager.java 1.4\t02/01/09 SMI";

    private TerminalManager(LogTracer logTracer) {
        logger = logTracer;
        Self = this;
    }

    public Terminal getTerminal(String string) {
        Terminal terminal = null;
        try {
            if (string.equalsIgnoreCase("ANSI")) {
                string = "windoof";
            } else if (!this.myTerminals.containsKey(string = string.toLowerCase())) {
                string = "default";
            }
            terminal = (Terminal)this.myTerminals.get(string);
        }
        catch (Exception exception) {
            logger.log("exception " + exception);
        }
        return terminal;
    }

    LogTracer getLogger() {
        return logger;
    }

    private void setupTerminals(Hashtable hashtable) {
        String string = "";
        String string2 = "";
        Terminal terminal = null;
        Object[] objectArray = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            try {
                string = (String)enumeration.nextElement();
                objectArray = (Object[])hashtable.get(string);
                string2 = (String)objectArray[0];
                terminal = (Terminal)Class.forName(string2).newInstance();
                this.myTerminals.put(string, terminal);
                String[] stringArray = (String[])objectArray[1];
                int n = 0;
                while (n < stringArray.length) {
                    if (!this.myTerminals.containsKey(stringArray[n])) {
                        this.myTerminals.put(stringArray[n], terminal);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                logger.log("exception " + exception.toString());
            }
        }
    }

    public static TerminalManager createInstance(LogTracer logTracer) throws BootException {
        if (null != Self) {
            return Self;
        }
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>(20);
        boolean bl = false;
        if (null == logTracer) {
            logTracer = new LogTracerImpl(null);
        }
        try {
            String string = terms.getProperty("TERMINALS");
            if (null == string) {
                logTracer.trace("No terminals declared.");
                throw new BootException("No terminals declared.");
            }
            String[] stringArray = StringUtil.split((String)string, (String)",");
            Object[] objectArray = null;
            String[] stringArray2 = null;
            int n = 0;
            while (n < stringArray.length) {
                objectArray = new Object[2];
                objectArray[0] = terms.getProperty(stringArray[n]);
                stringArray2 = StringUtil.split((String)terms.getProperty(stringArray[n] + ".aliases"), (String)",");
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray2[n2].equalsIgnoreCase("default")) {
                        if (!bl) {
                            bl = true;
                        } else {
                            throw new BootException("Only one default can be declared.");
                        }
                    }
                    ++n2;
                }
                objectArray[1] = stringArray2;
                hashtable.put(stringArray[n], objectArray);
                ++n;
            }
            if (!bl) {
                throw new BootException("No default terminal declared.");
            }
            TerminalManager terminalManager = new TerminalManager(logTracer);
            terminalManager.setupTerminals(hashtable);
            return terminalManager;
        }
        catch (Exception exception) {
            logTracer.log("TerminalManager.createManager() failed." + exception.toString());
            throw new BootException("Creating TerminalManager Instance failed:\n" + exception.getMessage());
        }
    }

    public static TerminalManager getInstance() {
        return TerminalManager.getInstance(null);
    }

    public static TerminalManager getInstance(LogTracer logTracer) {
        try {
            if (null == Self) {
                Self = TerminalManager.createInstance(logTracer);
            }
        }
        catch (BootException bootException) {}
        return Self;
    }

    static {
        terms = new Properties();
        terms.setProperty("TERMINALS", "vt100,ansi,windoof,xterm");
        terms.setProperty("vt100", "dtw.telnetd.io.terminal.vt100");
        terms.setProperty("vt100.aliases", "default,vt100-am,vt102,dec-vt100");
        terms.setProperty("ansi", "dtw.telnetd.io.terminal.ansi");
        terms.setProperty("ansi.aliases", "color-xterm,xterm-color,vt320,vt220,linux");
        terms.setProperty("windoof", "dtw.telnetd.io.terminal.Windoof");
        terms.setProperty("windoof.aliases", "");
        terms.setProperty("xterm", "dtw.telnetd.io.terminal.xterm");
        terms.setProperty("xterm.aliases", "");
    }
}

