/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.io.telnet;

import com.sun.netstorage.mgmt.io.NetProtoIO;
import com.sun.netstorage.mgmt.net.Connection;
import java.io.IOException;

public class TelnetIO
extends NetProtoIO {
    private static final boolean debug = false;
    private IACHandler iach;
    private boolean NOIAC = false;
    private boolean initialized = false;
    protected static final int IAC = 255;
    protected static final int GA = 249;
    protected static final int WILL = 251;
    protected static final int WONT = 252;
    protected static final int DO = 253;
    protected static final int DONT = 254;
    protected static final int SB = 250;
    protected static final int SE = 240;
    protected static final int NOP = 241;
    protected static final int DM = 242;
    protected static final int BRK = 243;
    protected static final int IP = 244;
    protected static final int AO = 245;
    protected static final int AYT = 246;
    protected static final int EC = 247;
    protected static final int EL = 248;
    protected static final int ECHO = 1;
    protected static final int SUPGA = 3;
    protected static final int NAWS = 31;
    protected static final int TTYPE = 24;
    protected static final int IS = 0;
    protected static final int SEND = 1;
    protected static final int LOGOUT = 18;
    protected static final int EXT_ASCII = 17;
    protected static final int SEND_LOC = 23;
    protected static final int AUTHENTICATION = 37;
    protected static final int ENCRYPT = 38;
    private static final int SMALLEST_BELIEVABLE_WIDTH = 20;
    private static final int SMALLEST_BELIEVABLE_HEIGHT = 6;
    private static final int DEFAULT_WIDTH = 80;
    private static final int DEFAULT_HEIGHT = 25;
    static final String sccs_id = "@(#)TelnetIO.java 1.5 02/03/15 SMI";

    public TelnetIO(Connection connection) throws IOException {
        super(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void write(byte by) {
        try {
            try {
                if (!this.cr && by == 10) {
                    this.outstream.write(13);
                }
                if (this.cr && by != 10) {
                    this.outstream.write(10);
                }
                this.outstream.write(by);
                this.cr = by == 13;
            }
            catch (IOException iOException) {
                if (this.myConnection.isActive()) {
                    this.myConnectionData.getManager().registerBrokenConnection(this.myConnection);
                }
                Object var4_3 = null;
                TelnetIO telnetIO = this;
                telnetIO.myConnection.yield();
                return;
            }
            Object var4_2 = null;
            TelnetIO telnetIO = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            TelnetIO telnetIO = this;
            telnetIO.myConnection.yield();
            throw throwable;
        }
        telnetIO.myConnection.yield();
    }

    public final void closeOutput() {
        this.closing = true;
        this.write(255);
        this.write(253);
        this.write(18);
        try {
            this.outstream.close();
        }
        catch (IOException iOException) {}
    }

    public final int read() {
        int n = this.rawread();
        this.NOIAC = false;
        while (n == 255 && !this.NOIAC) {
            n = this.rawread();
            if (n != 255) {
                this.iach.handleC(n);
                n = this.rawread();
                continue;
            }
            this.NOIAC = true;
        }
        return this.stripCRSeq(n);
    }

    private int stripCRSeq(int n) {
        if (n == 13) {
            int n2 = this.rawread();
            return 10;
        }
        return n;
    }

    protected final void initProtoHandler() {
        this.iach = new IACHandler();
    }

    protected final Object initCommunications() {
        this.initializing = true;
        try {
            this.iach.doInit();
            this.myConnectionData.getSocket().setSoTimeout(1000);
            int n = this.read();
            this.myConnectionData.getSocket().setSoTimeout(0);
            this.initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializing = false;
        return null;
    }

    private void iAmHere() {
        this.write("[" + this.localAddy.toString() + ":Yes]");
        this.flush();
    }

    private void setTerminalGeometry(int n, int n2) {
        if (n < 20) {
            n = 80;
        }
        if (n2 < 6) {
            n2 = 25;
        }
        this.myConnectionData.setTerminalGeometry(n, n2);
    }

    class IACHandler {
        private int c = 0;
        private boolean UNDEFINED = false;
        private boolean SUPPORTED = false;
        private String subnstring;
        private int[] buffer = new int[2];
        private boolean DO_ECHO = false;
        private boolean DO_SUPGA = false;
        private boolean DO_NAWS = false;
        private boolean DO_TTYPE = false;
        private boolean WAIT_DO_REPLY_SUPGA = false;
        private boolean WAIT_DO_REPLY_ECHO = false;
        private boolean WAIT_DO_REPLY_NAWS = false;
        private boolean WAIT_DO_REPLY_TTYPE = false;
        private boolean WAIT_WILL_REPLY_SUPGA = false;
        private boolean WAIT_WILL_REPLY_ECHO = false;
        private boolean WAIT_WILL_REPLY_NAWS = false;
        private boolean WAIT_WILL_REPLY_TTYPE = false;
        private int width = 0;
        private int height = 0;
        private String Terminalstr;
        private byte[] sendbuffer;

        IACHandler() {
        }

        public void handleC(int n) {
            this.buffer[0] = n;
            if (!this.parseTWO(this.buffer)) {
                this.buffer[1] = TelnetIO.this.rawread();
                this.parse(this.buffer);
            }
            this.buffer[0] = 0;
            this.buffer[1] = 0;
        }

        public void doInit() {
            this.sendCommand(251, 1, true);
            this.sendCommand(254, 1, true);
            this.sendCommand(253, 31, true);
            this.sendCommand(251, 3, true);
            this.sendCommand(253, 3, true);
            this.sendCommand(253, 24, true);
            this.getTTYPE();
        }

        private boolean parseTWO(int[] nArray) {
            switch (nArray[0]) {
                case 255: {
                    break;
                }
                case 246: {
                    TelnetIO.this.iAmHere();
                    break;
                }
                case 244: 
                case 245: 
                case 247: 
                case 248: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void parse(int[] nArray) {
            block0 : switch (nArray[0]) {
                case 251: {
                    if (this.supported(nArray[1]) && this.isEnabled(nArray[1])) break;
                    if (this.waitDOreply(nArray[1]) && this.supported(nArray[1])) {
                        this.enable(nArray[1]);
                        this.setWait(253, nArray[1], false);
                        break;
                    }
                    if (this.supported(nArray[1])) {
                        this.sendCommand(253, nArray[1], false);
                        this.enable(nArray[1]);
                        break;
                    }
                    this.sendCommand(254, nArray[1], false);
                    break;
                }
                case 252: {
                    if (this.waitDOreply(nArray[1]) && this.supported(nArray[1])) {
                        this.setWait(253, nArray[1], false);
                        break;
                    }
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    this.enable(nArray[1]);
                    break;
                }
                case 253: {
                    if (this.supported(nArray[1]) && this.isEnabled(nArray[1])) break;
                    if (this.waitWILLreply(nArray[1]) && this.supported(nArray[1])) {
                        this.enable(nArray[1]);
                        this.setWait(251, nArray[1], false);
                        break;
                    }
                    if (this.supported(nArray[1])) {
                        this.sendCommand(251, nArray[1], false);
                        this.enable(nArray[1]);
                        break;
                    }
                    this.sendCommand(252, nArray[1], false);
                    break;
                }
                case 254: {
                    if (this.waitWILLreply(nArray[1]) && this.supported(nArray[1])) {
                        this.setWait(251, nArray[1], false);
                        break;
                    }
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    this.enable(nArray[1]);
                    break;
                }
                case 242: {
                    break;
                }
                case 250: {
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    switch (nArray[1]) {
                        case 31: {
                            this.handleNAWS();
                            break block0;
                        }
                        case 24: {
                            this.handleTTYPE();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        private String readIACSETerminatedString() {
            int n = 0;
            char[] cArray = new char[40];
            int n2 = 32;
            boolean bl = true;
            do {
                int n3 = TelnetIO.this.rawread();
                switch (n3) {
                    case 255: {
                        n3 = TelnetIO.this.rawread();
                        if (n3 != 240) break;
                        bl = false;
                        break;
                    }
                    case -1: {
                        return new String("default");
                    }
                }
                if (!bl) continue;
                n2 = (char)n3;
                if (n2 == 10 || n2 == 13) {
                    bl = false;
                    continue;
                }
                cArray[n++] = n2;
            } while (bl);
            return new String(cArray, 0, n);
        }

        private void handleNAWS() {
            this.width = TelnetIO.this.read16int();
            if (this.width == 255) {
                this.width = TelnetIO.this.read16int();
            }
            this.height = TelnetIO.this.read16int();
            if (this.height == 255) {
                this.height = TelnetIO.this.read16int();
            }
            if (TelnetIO.this.rawread() != 255) {
                // empty if block
            }
            if (TelnetIO.this.rawread() != 240) {
                // empty if block
            }
            TelnetIO.this.setTerminalGeometry(this.width, this.height);
        }

        private void handleTTYPE() {
            String string = "";
            TelnetIO.this.rawread();
            string = this.readIACSETerminatedString();
            TelnetIO.this.myConnectionData.setNegotiatedTerminalType(string);
        }

        public void getTTYPE() {
            if (this.isEnabled(24)) {
                TelnetIO.this.write(255);
                TelnetIO.this.write(250);
                TelnetIO.this.write(24);
                TelnetIO.this.write(1);
                TelnetIO.this.write(255);
                TelnetIO.this.write(240);
                TelnetIO.this.flush();
            }
        }

        private boolean supported(int n) {
            switch (n) {
                case 1: 
                case 3: 
                case 24: 
                case 31: {
                    return true;
                }
            }
            return false;
        }

        private void sendCommand(int n, int n2, boolean bl) {
            TelnetIO.this.write(255);
            TelnetIO.this.write(n);
            TelnetIO.this.write(n2);
            if (n == 253 && bl) {
                this.setWait(253, n2, true);
            }
            if (n == 251 && bl) {
                this.setWait(251, n2, true);
            }
            TelnetIO.this.flush();
        }

        private void enable(int n) {
            switch (n) {
                case 3: {
                    this.DO_SUPGA = !this.DO_SUPGA;
                    break;
                }
                case 1: {
                    this.DO_ECHO = !this.DO_ECHO;
                    break;
                }
                case 31: {
                    this.DO_NAWS = !this.DO_NAWS;
                    break;
                }
                case 24: {
                    boolean bl = this.DO_TTYPE = !this.DO_TTYPE;
                    if (!this.DO_TTYPE) break;
                    this.getTTYPE();
                }
            }
        }

        private boolean isEnabled(int n) {
            switch (n) {
                case 3: {
                    return this.DO_SUPGA;
                }
                case 1: {
                    return this.DO_ECHO;
                }
                case 31: {
                    return this.DO_NAWS;
                }
                case 24: {
                    return this.DO_TTYPE;
                }
            }
            return false;
        }

        private boolean waitWILLreply(int n) {
            switch (n) {
                case 3: {
                    return this.WAIT_WILL_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_WILL_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_WILL_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_WILL_REPLY_TTYPE;
                }
            }
            return false;
        }

        private boolean waitDOreply(int n) {
            switch (n) {
                case 3: {
                    return this.WAIT_DO_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_DO_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_DO_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_DO_REPLY_TTYPE;
                }
            }
            return false;
        }

        private void setWait(int n, int n2, boolean bl) {
            switch (n) {
                case 253: {
                    switch (n2) {
                        case 3: {
                            this.WAIT_DO_REPLY_SUPGA = bl;
                        }
                        case 1: {
                            this.WAIT_DO_REPLY_ECHO = bl;
                        }
                        case 31: {
                            this.WAIT_DO_REPLY_NAWS = bl;
                        }
                        case 24: {
                            this.WAIT_DO_REPLY_TTYPE = bl;
                        }
                    }
                    break;
                }
                case 251: {
                    switch (n2) {
                        case 3: {
                            this.WAIT_WILL_REPLY_SUPGA = bl;
                        }
                        case 1: {
                            this.WAIT_WILL_REPLY_ECHO = bl;
                        }
                        case 31: {
                            this.WAIT_WILL_REPLY_NAWS = bl;
                        }
                        case 24: {
                            this.WAIT_WILL_REPLY_TTYPE = bl;
                        }
                    }
                }
            }
        }
    }
}

