/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.io;

import com.sun.netstorage.mgmt.io.BasicTerminalIO;
import com.sun.netstorage.mgmt.io.NetProtoIO;
import com.sun.netstorage.mgmt.io.terminal.TerminalManager;
import com.sun.netstorage.mgmt.net.Connection;
import com.sun.netstorage.mgmt.net.ConnectionData;
import com.sun.netstorage.mgmt.net.ConnectionEvent;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import dtw.telnetd.io.terminal.Terminal;

public class TerminalIO
implements BasicTerminalIO {
    private static final boolean debug = false;
    private NetProtoIO netio;
    private Connection myConnection;
    private ConnectionData myConnectionData;
    private Terminal terminal;
    private LogTracer myLogger;
    private TerminalManager myTm;
    private boolean acousticSignalling;
    private boolean autoflush;
    public static final int[] HOME = new int[]{0, 0};
    public static final int IOERROR = -1;
    public static final int UP = 1001;
    public static final int DOWN = 1002;
    public static final int RIGHT = 1003;
    public static final int LEFT = 1004;
    public static final int STORECURSOR = 1051;
    public static final int RESTORECURSOR = 1052;
    public static final int EEOL = 1100;
    public static final int EBOL = 1101;
    public static final int EEL = 1103;
    public static final int EEOS = 1104;
    public static final int EBOS = 1105;
    public static final int EES = 1106;
    public static final int ESCAPE = 1200;
    public static final int BYTEMISSING = 1201;
    public static final int UNRECOGNIZED = 1202;
    public static final int ENTER = 1300;
    public static final int TABULATOR = 1301;
    public static final int DELETE = 1302;
    public static final int BACKSPACE = 1303;
    public static final int COLORINIT = 1304;
    public static final int HANDLED = 1305;
    public static final int LOGOUTREQUEST = 1306;
    public static final int LineUpdate = 475;
    public static final int CharacterUpdate = 476;
    public static final int ScreenpartUpdate = 477;
    public static final int EditBuffer = 575;
    public static final int LineEditBuffer = 576;
    public static final int BEL = 7;
    public static final int BS = 8;
    public static final int DEL = 127;
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int FCOLOR = 10001;
    public static final int BCOLOR = 10002;
    public static final int STYLE = 10003;
    public static final int RESET = 10004;
    public static final int BOLD = 1;
    public static final int BOLD_OFF = 22;
    public static final int ITALIC = 3;
    public static final int ITALIC_OFF = 23;
    public static final int UNDERLINED = 4;
    public static final int UNDERLINED_OFF = 24;
    public static final int BLINK = 5;
    public static final int BLINK_OFF = 25;
    public static final String CRLF = "\r\n";
    static final String sccs_id = "@(#)TerminalIO.java 1.6 02/11/15 SMI";

    public TerminalIO(Connection connection, NetProtoIO netProtoIO) {
        this.myConnection = connection;
        this.netio = netProtoIO;
        this.acousticSignalling = true;
        this.autoflush = true;
        this.myConnectionData = connection.getConnectionData();
        this.myLogger = connection.getLogger();
        this.myTm = TerminalManager.getInstance(this.myLogger);
        this.setDefaultTerminal();
    }

    public NetProtoIO getNetIO() {
        return this.netio;
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    public int read() {
        int n = this.netio.read();
        if ((n = this.terminal.translateControlCharacter(n)) == 1306) {
            this.myConnection.processConnectionEvent(new ConnectionEvent(this.myConnection, 102));
            n = 1305;
        } else if (n > 256 && n == 1200) {
            n = this.handleEscapeSequence(n);
        }
        return n;
    }

    public void write(char c) {
        this.netio.write(c);
        if (this.autoflush) {
            this.flush();
        }
    }

    public void write(String string) {
        this.netio.write(this.terminal.format(string));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void eraseToEndOfLine() {
        this.doErase(1100);
    }

    public void eraseToBeginOfLine() {
        this.doErase(1101);
    }

    public void eraseLine() {
        this.doErase(1103);
    }

    public void eraseToEndOfScreen() {
        this.doErase(1104);
    }

    public void eraseToBeginOfScreen() {
        this.doErase(1105);
    }

    public void eraseScreen() {
        this.doErase(1106);
    }

    private void doErase(int n) {
        this.netio.write(this.terminal.getEraseSequence(n));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void moveCursor(int n, int n2) {
        this.netio.write(this.terminal.getCursorMoveSequence(n, n2));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void moveLeft(int n) {
        this.moveCursor(1004, n);
    }

    public void moveRight(int n) {
        this.moveCursor(1003, n);
    }

    public void moveUp(int n) {
        this.moveCursor(1001, n);
    }

    public void moveDown(int n) {
        this.moveCursor(1002, n);
    }

    public void setCursor(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        this.netio.write(this.terminal.getCursorPositioningSequence(nArray));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void homeCursor() {
        this.netio.write(this.terminal.getCursorPositioningSequence(HOME));
        if (this.autoflush) {
            this.flush();
        }
    }

    public void storeCursor() {
        this.netio.write(this.terminal.getSpecialSequence(1051));
    }

    public void restoreCursor() {
        this.netio.write(this.terminal.getSpecialSequence(1052));
    }

    public void setSignalling(boolean bl) {
        this.acousticSignalling = bl;
    }

    public boolean isSignalling() {
        return this.acousticSignalling;
    }

    public void bell() {
        if (this.acousticSignalling) {
            this.netio.write(7);
        }
        if (this.autoflush) {
            this.flush();
        }
    }

    public boolean defineScrollRegion(int n, int n2) {
        if (this.terminal.supportsScrolling()) {
            this.netio.write(this.terminal.getScrollMarginsSequence(n, n2));
            this.flush();
            return true;
        }
        return false;
    }

    public void setForegroundColor(int n) {
        if (this.terminal.supportsSGR()) {
            this.netio.write(this.terminal.getGRSequence(10001, n));
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void setBackgroundColor(int n) {
        if (this.terminal.supportsSGR()) {
            this.netio.write(this.terminal.getGRSequence(10002, n + 10));
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    private void setGRStyle(boolean bl, int n, int n2) {
        if (this.terminal.supportsSGR()) {
            this.netio.write(this.terminal.getGRSequence(10003, bl ? n : n2));
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void setBold(boolean bl) {
        this.setGRStyle(bl, 1, 22);
    }

    public void setUnderlined(boolean bl) {
        this.setGRStyle(bl, 4, 24);
    }

    public void setItalic(boolean bl) {
        this.setGRStyle(bl, 3, 23);
    }

    public void setBlink(boolean bl) {
        this.setGRStyle(bl, 5, 25);
    }

    public void resetAttributes() {
        if (this.terminal.supportsSGR()) {
            this.netio.write(this.terminal.getGRSequence(10004, 0));
        }
    }

    private int handleEscapeSequence(int n) {
        if (n == 1200) {
            int[] nArray = new int[this.terminal.getAtomicSequenceLength()];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = this.netio.read();
                ++n2;
            }
            return this.terminal.translateEscapeSequence(nArray);
        }
        if (n == 1201) {
            // empty if block
        }
        return 1305;
    }

    public boolean isAutoflushing() {
        return this.autoflush;
    }

    public void setAutoflushing(boolean bl) {
        this.autoflush = bl;
    }

    public void flush() {
        this.netio.flush();
    }

    public void close() {
        this.netio.closeOutput();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setDefaultTerminal() {
        this.setTerminal(this.myConnectionData.getNegotiatedTerminalType());
    }

    public void setTerminal(String string) {
        this.terminal = this.myTm.getTerminal(string);
        this.initTerminal();
        this.myLogger.trace(this.toString() + ":Set terminal " + this.terminal.toString());
    }

    private void initTerminal() {
        this.netio.write(this.terminal.getInitSequence());
        this.flush();
    }

    public int getRows() {
        return this.myConnectionData.getTerminalRows();
    }

    public int getColumns() {
        return this.myConnectionData.getTerminalColumns();
    }

    public boolean isTerminalGeometryChanged() {
        return this.myConnectionData.isTerminalGeometryChanged();
    }

    public void activity() {
        this.myConnectionData.activity();
    }
}

