/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.inet;

import com.sun.netstorage.mgmt.inet.Messages;
import com.sun.netstorage.mgmt.inet.NetSession;
import com.sun.netstorage.mgmt.io.BasicTerminalIO;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.logic.inventory.Lookup;
import com.sun.netstorage.mgmt.net.Connection;
import com.sun.netstorage.mgmt.net.ConnectionData;
import com.sun.netstorage.mgmt.net.ConnectionEvent;
import com.sun.netstorage.mgmt.net.ConnectionManager;
import com.sun.netstorage.mgmt.ui.shell.LogTracer;
import java.util.Locale;

public abstract class NetSessionImpl
implements NetSession,
Messages {
    protected final Connection mycon;
    protected final Lookup myLookup;
    protected final LogTracer myLogger;
    protected final BasicTerminalIO myio;
    private String connToutStr = null;
    private String connLoffStr = null;
    private String connBrokenStr = null;
    private ConnectionData myConnData = null;
    static final String sccs_id = "@(#)NetSessionImpl.java 1.4 02/03/29 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$inet$Messages;

    protected NetSessionImpl(Connection connection) {
        this.mycon = connection;
        if (null != connection) {
            this.myio = this.mycon.getTerminalIO();
            this.myLookup = connection.getLookup();
            this.myLogger = connection.getLogger();
        } else {
            this.myio = null;
            this.myLookup = null;
            this.myLogger = null;
        }
    }

    public final Connection getConnection() {
        return this.mycon;
    }

    public final BasicTerminalIO getTerminalIO() {
        return this.myio;
    }

    public final Lookup getLookup() {
        return this.myLookup;
    }

    public final LogTracer getLogger() {
        return this.myLogger;
    }

    public abstract void run();

    public void connectionTimedOut(ConnectionEvent connectionEvent) {
        if (null == this.connToutStr) {
            int n = this.getTimeToDisconnect();
            this.connToutStr = Localize.getString((Object)(class$com$sun$netstorage$mgmt$inet$Messages == null ? (class$com$sun$netstorage$mgmt$inet$Messages = NetSessionImpl.class$("com.sun.netstorage.mgmt.inet.Messages")) : class$com$sun$netstorage$mgmt$inet$Messages), (String)"`inet.msg.timing_out`", (Object[])new String[]{Integer.toString(n)}, (Locale)this.getLocale());
        }
        this.myio.write(this.connToutStr);
        this.myio.flush();
    }

    public void connectionLoggedOff(ConnectionEvent connectionEvent) {
        if (null == this.connLoffStr) {
            this.connLoffStr = Localize.getString((Object)(class$com$sun$netstorage$mgmt$inet$Messages == null ? (class$com$sun$netstorage$mgmt$inet$Messages = NetSessionImpl.class$("com.sun.netstorage.mgmt.inet.Messages")) : class$com$sun$netstorage$mgmt$inet$Messages), (String)"`inet.msg.logged_off`", (Locale)this.getLocale());
        }
        this.myio.write(this.connLoffStr);
        this.myio.flush();
    }

    public void connectionLogoutRequest(ConnectionEvent connectionEvent) {
    }

    public void connectionBroken(ConnectionEvent connectionEvent) {
        if (null == this.connBrokenStr) {
            this.connBrokenStr = Localize.getString((Object)(class$com$sun$netstorage$mgmt$inet$Messages == null ? (class$com$sun$netstorage$mgmt$inet$Messages = NetSessionImpl.class$("com.sun.netstorage.mgmt.inet.Messages")) : class$com$sun$netstorage$mgmt$inet$Messages), (String)"`inet.msg.conn_broken`", (Locale)this.getLocale());
        }
        this.myio.write(this.connBrokenStr);
        this.myio.flush();
    }

    private Locale getLocale() {
        if (null == this.myConnData) {
            this.myConnData = this.mycon.getConnectionData();
        }
        if (null != this.myConnData) {
            return this.myConnData.getLocale();
        }
        return null;
    }

    private int getTimeToDisconnect() {
        ConnectionManager connectionManager;
        if (null == this.myConnData) {
            this.myConnData = this.mycon.getConnectionData();
        }
        if (null != this.myConnData && null != (connectionManager = this.myConnData.getManager())) {
            return connectionManager.getDisconnectTimeout() / 1000;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

