<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)WizardFrame.jsp    1.20    03/08/06     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale -->

<head>
<title><bean:write name="wizardframework" property="wizardTitleMessage" scope="request" /></title>
<%@include file="/layout/page_head_section.jsp"%>

<script language="JavaScript">
// Variable which hold client-side state and other chooser information
var currentPage = <bean:write name="wizardframework" property="activePage"/>;
var totalPages = <bean:write name="wizardframework" property="totalPages"/>;
var tocTitles = "<bean:write name="wizardframework" property="tocTitlesRequestParam" filter="false"/>"

/**
 * Loads the specified page into this chooser.
 * This will cause a reload of:
 * 1)The Table of Contents (to show the new selection),
 * 2)The Wizard Contents
 * 3)The button frame (only if the look or attributes of the buttons must change
 *   (e.g. changing to either the first or last page in the chooser)
 */
function setPage(newPage, wizardAction) {

	loadTOC(newPage);
	
    hideButtons();
	if (wizardAction.indexOf("openWizard") == 0)
		loadContent(newPage, wizardAction);

    // nextPage or previousPage
	else if (wizardAction.indexOf("Page") > -1)			
		submitContent(newPage, wizardAction);

	else if (wizardAction.indexOf("confirmChoices") == 0)
		submitContent(newPage, wizardAction);

	// Set the currentPage now that the new page is loaded
	currentPage = newPage;
}

function updateWizard(newCurrentPage, newTocTitles, newTotalPages) {
	// Change the current page.  The value coming from the server is 1-indexed
	// so we must subtract one from that number.
	if (newCurrentPage != null)
		currentPage = newCurrentPage-1;

	if (newTocTitles != null)
		tocTitles = newTocTitles;
	
	if (newTotalPages != null && newTotalPages != 0)
		totalPages = newTotalPages;
		
	// Load the new table of contents
	loadTOC(currentPage);
	
	// Load new button page
	loadButtons(currentPage);
}

function hideButtons() {
    // hide the buttons
	window.Buttons.location.href = "layout/blank.jsp"; 
}

function loadTOC(newPage) {
//alert ("loading new TOC with " + newPage);
	// Load the Table of Contents
	var tocPath = "WizardFramework.do?page=wizardTOC&wizardTitle=<bean:write name="wizardframework" property="wizardTitle" scope="request"/>"
				+ "&activePage=" + newPage
				+ tocTitles;

	// Load TOC:
	window.TOC.location = tocPath;
}

/**
 * Load new buttons (if necessary)
 */
function loadButtons(newPage) {
	// Always load a new page when we've paged to or from the first or last page.
//	if (newPage == 0 || newPage == totalPages-1 || currentPage == 0 || currentPage == totalPages-1) {
		//alert ("loading new buttons with " + newPage); 

		var buttonPath = "WizardFramework.do?page=wizardButtons"+
						 "&totalPages="+totalPages+
						 "&activePage="+newPage;

//alert (buttonPath);
		window.Buttons.location = buttonPath;
//	}
}

/**
 * Function to load a specific content page.  Note that this will not
 * cause the form in the current page to be submitted, so this will
 * generally only be called when the wizard is first loaded.
 */
function loadContent(newPage, wizardAction) {
	var contentPath = "<bean:write name="wizardframework" property="contentAction" scope="request"/>.do?" +
                      "&wizardPageIndex=" + newPage +
                      "&wizardPreviousPageIndex=" + currentPage +
                      "&wizardAction="+wizardAction;
		      <% if(request.getParameter("context") != null) { %>
		      contentPath += "&context=<%=request.getParameter("context")%>";
		      <% } %>
    window.Content.location = contentPath;
}

/**
 * Function to submit the content on the current page and go to
 * the next/previous page.
 */
function submitContent(newPage, wizardAction) {
	var contentForm = window.Content.document.forms[0];

	contentForm.wizardAction.value = wizardAction;
	contentForm.wizardPageIndex.value = newPage;
	contentForm.wizardPreviousPageIndex.value = currentPage;

//	alert ("about to submit content form.  wizardAction is " + contentForm.wizardAction.value + " and \n" +
//		   "wizardPageIndex is " + contentForm.wizardPageIndex.value);
	contentForm.submit();
}

function nextPage() {
    
	setPage(currentPage+1, "nextPage");
}

function previousPage() {
	setPage(currentPage-1, "previousPage");
}

function confirmChoices() {
    setPage(currentPage, "confirmChoices");
}

function cancel() {
	// TODO: call the WizardFramework Action to get it to do a real cancel -- remove
	// the wizard form object from the session
	// For now, just close the wizard
	closeWindow(false);
}

/**
 * Function to reload the content page, submitting the values that are currently
 * on the form.  Can be called from the content page with parent.reloadContentPage();
 */
function reloadContentPage() {
	setPage(currentPage, "nextPage");
}

function closeWindow(doRefresh) {
	// Refresh parent window
	if (doRefresh) {
	    opener.document.forms[0].submit();
//		opener.location.reload(false);
    }
	// Close this window
	window.close();
}

</script>



</head>

<frameset border="1" framespacing="1" frameborder="0" rows="30,*" onload='setPage(<bean:write name="wizardframework" property="activePage" scope="request"/>, "openWizard")'>
  <frame name="Title" id="title" scrolling="no" marginwidth="5" marginheight="5" title="title" src="WizardFramework.do?page=wizardTitle&wizardTitle=<bean:write name="wizardframework" property="wizardTitle" scope="request"/>">
  <frameset border="1" framespacing="1" frameborder="1" cols="225,*">
    <frame name="TOC" id="toc" scrolling="no" marginwidth="5" marginheight="5" title="toc" src="<%=request.getContextPath()%>/wizard/Blank.jsp">

    <frameset border="1" framespacing="1" frameborder="1" rows="*,50">
      <frame name="Content" id="body" scrolling="yes" marginwidth="5" marginheight="5" title="content" src="<%=request.getContextPath()%>/wizard/Loading.jsp">
      <frame name="Buttons" id="navigation" scrolling="no" marginwidth="0" marginheight="0" title="navigation" src="<%=request.getContextPath()%>/wizard/Blank.jsp">
    </frameset>
  </frameset>
</frameset>

<!--
<body onload="setPage(0)">
</body>
-->

</html:html>
