<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_profileselection_forwizards.jsp     1.3     03/08/07     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<html:html>

<% 
   PoolCreateForm form = 
      (PoolCreateForm)session.getAttribute(
        Constants.HttpSessionFields.CREATE_POOL_FORM_NAME);
   T4Interface currentT4 = 
      (T4Interface)session.getAttribute(
        Constants.HttpSessionFields.CURRENT_T4);

   // flag to indicate if this is used in the create pool wizard
   //  if we do not have a tray to modify then we are using the
   //   create pool wizard
   boolean isCreate = form.getTrayToModify() != null;
   // set the appropriate action for configuring storage by profile
   //  or creating a pool
   String formAction = "/ConfigStorageByProfileWizard.do";
   if(isCreate) {
      formAction = "/CreatePoolWizard.do";
   }
%>

<head>
<%@include file="/layout/page_head_section.jsp"%>
<script language="JavaScript">
	function changeProfileFilter() {
       <% String _page = "0"; 
           if(isCreate) {
             _page = "1";
           }
       %>
       parent.setPage(<%=_page%>, "Page");
	}
</script>
</head>

<%@ include file="/layout/wizard_body_tag.jsp" %>

<html:form action="<%=formAction%>">
<% try { %>
<%@ include file="/wizard/wizard_framework_fields.jsp"%>

<div class="content-layout">

<%@ include file="/layout/user_messages.jsp"%>

<logic:present name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="traysWithSpace">

<!-- section header -->
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr class="wizard-content-title-row">
    <td>
      <div class="wizard-content-title-text">
        <bean:message key="configure.storage.wizard.toc.1"/>
      </div>
    </td>
  </tr>
  <tr>
    <td class="wizard-content-divider"><img alt width="1" height="1" src="/images/general/dot.gif" border="0"></td>
  </tr>
  <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
  </tr>

</table>

<!-- new Profile Section header and instructions table -->
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
  </tr>
  <tr>
       <td>
          <bean:message key="configure.storage.wizard.selectprofile.instructions"/>
       </td>
  </tr>
  <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
  </tr>
<!-- end New Profile Section header and instructions table -->
</table>

<table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
<tr>
 <td>
   <table class="front-table" border="0" cellspacing="0" cellpadding="0">
     <!-- header row -->
     <tr class="header-row">
       <td valign="top"> 
          <div class="table-header-text">
            <bean:message key="configure.storage.wizard.table.col.profilelist"/> 
          </div>
       </td>
       <td>
         <div class="table-header-text">
            <!-- if user selected to create a new profile, show the input column header -->
            <logic:present name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName">
              <logic:equal name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName" value="<%=Constants.Profile.CREATE_NEW_PROFILE%>">
               <bean:message key="configure.storage.wizard.table.col.inputnew"/> 
              </logic:equal>
            </logic:present>
            <!-- show the details column header if we have a newly selected
                  profile name and it's not equal to create new, or if
                  no profile is selected -->
            <logic:present name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName">
              <logic:notEqual name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName" value="<%=Constants.Profile.CREATE_NEW_PROFILE%>">
               <bean:message key="configure.storage.wizard.table.col.seldetails"/> 
              </logic:notEqual>
            </logic:present>
            <logic:notPresent name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName">
               <bean:message key="configure.storage.wizard.table.col.seldetails"/> 
            </logic:notPresent>
         </div>
      </td>
    </tr> <!-- end header row -->
    <!-- data row with select box and details-->
    <tr>
      <td valign="top">
        <logic:present name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="allProfiles">
        <html:select size="10" name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName" onchange="javascript:changeProfileFilter()">
           <!-- add the create new profile option -->
           <html:option key="configure.storage.wizard.create.new" value="<%=Constants.Profile.CREATE_NEW_PROFILE%>"/>

          <logic:iterate id="profile" name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="allProfiles" type="StorageProfile" indexId="idx">
             <html:option value="<%=profile.getName()%>"/>
          </logic:iterate>
        </html:select>
        </logic:present>
      </td>
      <!-- if we don't have a profile selected, show that none is selected-->
      <logic:notPresent name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName">
        <td width="100%" valign="top"> 
          <bean:message key="configure.storage.wizard.table.data.noneselected" />
        </td> 
      </logic:notPresent>
      <!-- if we have a profile name... -->
      <logic:present name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName">
       <!-- and it's not equal to create new show the profile details -->
       <logic:notEqual name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName" value="<%=Constants.Profile.CREATE_NEW_PROFILE%>">
      <%
        StorageProfile selectedProfile = form.getSelectedProfileObject();
      %>
      <td width="100%" valign="top"> <!-- td for profile details -->
        <table>
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
               <bean:message key="storage.mgmt.system.profileinfo.table.name" />
              </div>
            </td>                        
            <td align="left" nowrap>
              <div class="table-normal-text"> 
                 <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="selectedProfileObject.name"/>
              </div>
            </td>
          </tr>                        
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
               <bean:message key="storage.mgmt.system.profileinfo.table.desc" />
              </div>
            </td>                        
            <td align="left" nowrap>
              <div class="table-normal-text"> 
                <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="selectedProfileObject.description"/>
              </div>
            </td>
          </tr>                        
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
                <bean:message key="storage.mgmt.system.profileinfo.table.raid" />
              </div>
            </td>
            <td align="left" nowrap>
              <div class="table-normal-text">
                 <% String raid = "array.raid." + selectedProfile.getRaidLevel();%>
                 <bean:message key="<%=raid%>"/>
              </div>
            </td>
          </tr>  
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
                <bean:message key="storage.mgmt.system.profileinfo.table.segmentsize" />
              </div>
            </td>
            <td align="left" nowrap>
              <div class="table-normal-text">                                                   
                 <% String segSize = "array.segmentSize." + selectedProfile.getSegmentSize();%>
                 <bean:message key="<%=segSize%>"/>
              </div>
            </td>
          </tr>  
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
                <bean:message key="storage.mgmt.system.profileinfo.table.readahead" />
              </div>
            </td>
            <td align="left" nowrap>
              <div class="table-normal-text">                                                   
               <% String ra = 
                   "array.readahead." + ((selectedProfile.getReadaheadMode() != 0) ? "1" : "0");
               %>
               <bean:message key="<%=ra%>"/>
              </div>
            </td>
          </tr>  
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
                <bean:message key="storage.mgmt.profile.details.table.numberdrives" />
              </div>
            </td>
            <td align="left" nowrap>
              <div class="table-normal-text">                                                   
                <bean:write name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="selectedProfileObject.numberOfDrives"/>
              </div>
            </td>
          </tr>  
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
                <bean:message key="storage.mgmt.profile.details.table.arraytype" />
              </div>
            </td>
            <td align="left" nowrap>
              <div class="table-normal-text">                                                   
                <% 
                 String arraytype = "array.type." + selectedProfile.getArrayType();%>
                <bean:message key="<%=arraytype%>"/>
              </div>
            </td>
          </tr>  
          <% if(currentT4.isFeatureSupported(
               Constants.SupportedFeature.FEATURE_DEDICATED_HOT_SPARE)) { 
          %>
          <tr>
            <td align="left" nowrap>
              <div class="table-normal-text">
                <bean:message key="storage.mgmt.profile.details.table.dedicatedhotspare" />
              </div>
            </td>
            <td align="left" nowrap>
              <div class="table-normal-text">                                                   
                <% String dedhs = "storage.profile.dedicatedhotspare.value." + selectedProfile.getDedicatedHotSpare();%>
                <bean:message key="<%=dedhs%>"/>
              </div>
            </td>
          </tr>  
          <% } %>
        </table>
      </td> <!-- end td for profile details -->
      </logic:notEqual>
      </logic:present>
      <!-- if we have a new profile name, and it's equal to the 
           create new profile name; show input fields -->
     <logic:present name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName">
       <logic:equal name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newProfileName" value="<%=Constants.Profile.CREATE_NEW_PROFILE%>">
         <%@ include file="sm_newprofileform_include.jsp"%>
       </logic:equal>
     </logic:present>
    </tr> <!-- end data row-->
  </table><!-- end front-table-->
 </td>
</tr>
</table>

</logic:present>
</div>

<% } catch(Exception e) { 
     Trace.error(this, 
       "sm_profileselection_forwizards.jsp",
       "Page exception: " + e); 
   } 
%>
</html:form>
</body>

</html:html>
