<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_profile_summary.jsp    1.7    03/08/28     SMI"
   * 
   */
 --%>
<%@ page import="com.sun.netstorage.array.mgmt.cfg.ui.forms.StorageProfileForm" %>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale stuff -->

<!-- HTML -->
<head>
   <%@include file="/layout/page_head_section.jsp"%>
   <title>
      <bean:message  key="storage.mgmt.profile.summary.crumb"/>
   </title>
   <!-- Place Java Script Here -->
<script language="javascript">
var uncheckedMsg = <bean:message key="storage.mgmt.profile.summary.select"/>;
</script>
</head>

<%@include file="/layout/bodytag.jsp"%>

<div class="simple-layout">
<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr>
<td>

<%@include file="/layout/top.jsp"%>
<%@include file="/layout/breadcrumb.jsp"%>

<html:form action="root.menu.item0.item3.do">

<% try { %>
<!-- hidden element which specifies the action for this form -->
<input type="hidden" name="request_action" value="<%=request.getAttribute("request_action")%>">
<% 
   List profileList = (List)session.getAttribute(Constants.HttpSessionFields.ALL_PROFILES_LIST);
   boolean hasList = profileList != null && (!profileList.isEmpty()) ;
   StorageProfileForm form = (StorageProfileForm)session.getAttribute("storageProfile");
   boolean areAllHealthy = form.isHealth();
%>
<div class="content-layout">
  <%@ include file="/layout/spacer.jsp" %>
  <%@ include file="/layout/user_messages.jsp"%>
  <%@ include file="/layout/spacer.jsp"%>
  
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <bean:message key="storage.mgmt.profile.summary.header"/> 
              </div>
            </td>
            <td valign="bottom" width="99%">
              <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <tr>
                  <td class="property-separator" valign="bottom"><img alt border="0" height="2" src="/images/general/dot.gif" width="1"></td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td>
         <img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
    <tr>
      <td>
          <bean:message key="storage.mgmt.profile.summary.msg"/>
      </td>
    </tr>
    <tr>
      <td>
         <img alt border="0" height="10" src="/images/general/dot.gif" width="1"></td>
    </tr>
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <bean:message key="storage.mgmt.profile.summary.subheader"/> 
              </div>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td>
         <img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
    <tr>
      <td>
          <bean:message key="storage.mgmt.profile.summary.submsg"/>
      </td>
    </tr>
  </table>
  <%@ include file="/layout/spacer.jsp" %>

  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>
        <table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td align="left" valign="middle">
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>                  
                  <td>
                    <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                      <tr>
                        <td>
                          <table>
                            <tr>
                              <td align="center" valign="middle" nowrap> 
                                 <component:button text="button.create" href="javascript:submitForm('create');" title="button.create" isEnabled="<%= !readOnly %>" />
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                  <td width="10"><img alt width="10" height="1" border="0" src="images/general/dot.gif"></td>                  
                </tr>
              </table>
            </td>
            
            <td>
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>                  
                  <td>
                    <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                      <tr>
                        <td>
                          <table>
                            <tr>
                              <td align="center" valign="middle" nowrap>         
                                 <component:button text="button.delete" href="javascript:document.forms[0].action='root.menu.item0.item3deleteconfirm.do';document.forms[0].submit();" title="button.delete" isEnabled="<%= !readOnly && areAllHealthy %>" />
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                  <td width="10"><img alt width="10" height="1" border="0" src="images/general/dot.gif"></td>                  
                </tr>
              </table>
            </td>
            
            <td>
             <table border="0" cellpadding="0" cellspacing="0">
                <tr>                  
                  <td>
                    <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                      <tr>
                        <td>
                          <table>
                            <tr>
                              <td align="center" valign="middle" nowrap>         
                                 <component:button text="button.import.dots" href="javascript:document.forms[0].action='root.menu.item0.item3import.do';document.forms[0].submit();" title="button.import" isEnabled="<%= !readOnly && areAllHealthy %>" />
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                  <td width="10"><img alt width="10" height="1" border="0" src="images/general/dot.gif"></td>                  
                </tr>
              </table>
            </td>
            
            <td>
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>                  
                  <td>
                    <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                      <tr>
                        <td>
                          <table>
                            <tr>
                              <td align="center" valign="middle" nowrap>
                                 <component:button text="button.export" href="javascript: submitIfChecked(document.forms[0],'se6x20profiles.do');" title="button.export" isEnabled="<%= !readOnly %>" />
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                  <td width="10"><img alt width="10" height="1" border="0" src="images/general/dot.gif"></td>                  
                </tr>
              </table>
            </td>
            <td>
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>                  
                  <td>
                    <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                      <tr>
                        <td>
                          <table>
                            <tr>
                              <td align="center" valign="middle" nowrap>
                                  <bean:message key="array.management.profile.summary.filterHeader"/>&nbsp;
 			      </td>
                              <td align="center" valign="middle" nowrap>
                  
                                <html:select property="profileListFilter" onchange="submitForm('show')">
            	                   <html:option key="array.management.profile.summary.allProfiles" value="<%= Integer.toString(Constants.ProfileFilterTypes.ALL) %>"/>
            	                   <html:option key="array.management.profile.summary.profilesInUse" value="<%= Integer.toString(Constants.ProfileFilterTypes.IN_USE) %>"/>
                                   <html:option key="array.management.profile.summary.profilesNotInUse" value="<%= Integer.toString(Constants.ProfileFilterTypes.NOT_IN_USE) %>"/>
                                </html:select>
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
 
  <!-- Profile summary table -->
  <table>
    <tr>
       <td>
          <img alt border="0" src="images/general/dot.gif" width="1" height="5">
       </td>
    </tr>
    <tr>
       <td nowrap>
          <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
            <tr>
              <td>
                 <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                   <!-- begin column header row -->
                   <tr class="header-row">
                     <td align="center" valign="middle" nowrap>
                        <a href="javascript:checkAll(document.forms[0])"><img src="images/icons/select-all-small.gif" alt='<bean:message key="table.select.all"/>' vspace="2" border="0" width="11" height="13"></a>
                        <a href="javascript:unCheckAll(document.forms[0])"><img src="images/icons/deselect-all-small.gif" alt='<bean:message key="table.deselect.all"/>' vspace="2" border="0" width="11" height="13"></a>
                     </td>
                     <td nowrap>
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.system.name" />
                       </div>
                     </td>
                     <td nowrap>
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.system.profileinfo.table.raid" />
                       </div>
                     </td>
                     <td nowrap>
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.system.profileinfo.table.segmentsize" />
                       </div>
                     </td>
                     <td nowrap>
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.system.profileinfo.table.readahead" />
                       </div>
                     </td>
                     <td nowrap>
                       <div class="table-header-text">
                          <bean:message key="storage.mgmt.system.profileinfo.table.arraytype" />
                       </div>
                     </td>
                  </tr>
                  <!-- end column header row -->
                  <% if (!hasList) { %> 
                     <tr> 
                         <td colspan="6">
                            <div class="table-normal-text">
                                <bean:message key="storage.mgmt.profile.summary.table.noprofiles" />
                            </div>
                         </td> 
                     </tr>
                  <% } else { %>
                  <!-- Begin profile listing -->
                  <logic:iterate id="profile" indexId="index" name="<%=Constants.HttpSessionFields.ALL_PROFILES_LIST%>" type="StorageProfile">
                     <tr>
                        <td>
                           <div class="table-normal-text">
                              <input <% if (readOnly) {  %> disabled <% } %> type="checkbox" name="selectedIndices" value="<%= index %>" >
                           </div>
                        </td>
                        <td nowrap align="left">
                           <div class="table-normal-text">

			      <html:link href="root.menu.item0.item3profiledetails.do" paramId="profileName" paramName="profile" paramProperty="name">
                                <bean:write name="profile" property="name"/>
                              </html:link>
                           </div>
                        </td>
                        <td nowrap>
                           <div class="table-normal-text">
                              <% String raid = "array.raid." + profile.getRaidLevel();%>
                              <bean:message key="<%=raid%>"/>
                           </div>
                        </td>
                        <td align="right" nowrap>
                           <div class="table-normal-text">
                               <% String segSize = "array.segmentSize." + profile.getSegmentSize();%>
                               <bean:message key="<%=segSize%>"/>
                           </div>
                        </td>
                        <td nowrap>
                           <div class="table-normal-text">
                              <% 
                                 String ra = "array.readahead." + ((profile.getReadaheadMode() != 0) ? "1" : "0") ;%>
                              <bean:message key="<%=ra%>"/>
                           </div>
                        </td>
                        <td nowrap>
                           <div class="table-normal-text">
                              <% String at = "array.type." + profile.getArrayType();%>
                              <bean:message key="<%=at%>"/>
                           </div>
                        </td>
                     </tr>
                     <tr >
                        <td class="line-row" height="1" colspan="6">
                            <img src="images/general/dot.gif" border="0" width="0" height="1">
                        </td>
                     </tr>
                  </logic:iterate>
                  <% } %>
                </table>
              </td>
            </tr>
         </table>
       </td>
     </tr>
  </table>
  <!-- End of Profile summary table -->
</div>

<% } catch (Exception e) {Trace.verbose(this, "JSP Page", e);} %>
</html:form>
</td>
</tr>
</table>
</div>
</body>
</html:html> 
