<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_clone_traywiz_selectdest.jsp    1.8    03/08/28     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale -->

<!-- Place Java Script Here -->

<!-- HTML -->
<head>
<%@include file="/layout/page_head_section.jsp"%>
</head>
<%@ include file="/layout/wizard_body_tag.jsp" %>
<html:form action="/CloneTrayWizard.do">
<%@ include file="/wizard/wizard_framework_fields.jsp"%>

<%@ include file="/layout/user_messages.jsp"%>

<%
    T4Interface currentT4 =
        (T4Interface)session.getAttribute(
            Constants.HttpSessionFields.CURRENT_T4);
    boolean isAhsSupported =
        currentT4.isFeatureSupported(
            Constants.SupportedFeature.FEATURE_ARRAY_HOT_SPARE);
%>
 
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr class="wizard-content-title-row">

    <td>
      <div class="wizard-content-title-text">
        <bean:message key="clone.tray.wizard.destheader" arg0="<%=currentT4.getName()%>"/>
      </div>
    </td>
  </tr>
  <tr>
    <td class="wizard-content-divider"><img alt width="1" height="1" src="/images/general/dot.gif" border="0"></td>
  </tr>

</table>
<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><bean:message key="clone.tray.wizard.destmsg"/></td>
  </tr>  

</table>
<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" width="50%">
  <tr>
    <td>
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">

        <tr class="header-row">
           <td align="center" valign="middle" nowrap><a href="javascript:checkAll(document.forms[0])"><img src="images/icons/select-all-small.gif" alt='<bean:message key="table.select.all"/>' vspace="2" border="0" width="11" height="13"></a><a href="javascript:unCheckAll(document.forms[0])"><img src="images/icons/deselect-all-small.gif" alt='<bean:message key="table.deselect.all"/>' vspace="2" border="0" width="11" height="13"></a></td>                      
           <td>
             <div class="table-header-text">
               <bean:message key="tray.table.id"/>
             </div>
           </td>                                               
           <td>
             <div class="table-header-text">
               <bean:message key="tray.table.type"/>
             </div>
           </td>   
            <td>
             <div class="table-header-text">
               <bean:message key="tray.table.drivenum.short"/>
             </div>
           </td>    
            <td>
             <div class="table-header-text">
               <bean:message key="tray.table.drivecapacity"/>
             </div>
           </td> 
           <% if(isAhsSupported) { %> 
               <td>
                 <div class="table-header-text">
                   <bean:message key="tray.table.ahs"/>
                 </div>
               </td>
           <% } %>
        </tr>
        <!-- Begin possible T4 destinations row listing -->           
        <logic:present name="CloneTray" property="possibleDestinations">      
          <logic:iterate id="destTray" name="CloneTray" property="possibleDestinations" type="TrayInterface" indexId="index">           
               <tr>
                  <td align="center">                                            
                    <input type="checkbox" name="<%="dest" + index %>" value="<%= index%>"/>
                  </td>   
                  <td align="center">                       
                    <div class="table-normal-text">  
                     <bean:write name="destTray" property="id"/>
                    </div>
                  </td> 
                  <td align="center">                         
                    <div class="table-normal-text">
                      <%
                         String typeStr = "tray.type." + destTray.getTrayType();                                
                      %>
                      <bean:message key="<%=typeStr%>"/>
                    </div>
                  </td> 
                  <td align="center">                         
                    <div class="table-normal-text">
                     <bean:write name="destTray" property="numberOfDrives"/>
                    </div>
                  </td> 
                  <td align="center">                         
                   <div class="table-normal-text">
                     <%=nf.format(nf.parse(Convert.bytesToGB(destTray.getDriveCapacity())))%> 
                     <bean:message key="size.GB"/>
                   </div>
                  </td>
                  <% if(isAhsSupported) { %> 
                      <td align="right">
                        <div class="table-normal-text">
                          <%=destTray.getNumberOfDisksInRole(Constants.Disks.ROLE_ARRAY_SPARE)%>
                        </div>
                      </td>                                                                                     
                  <% } %>
               </tr>
          </logic:iterate>
        </logic:present>
      </table>
    </td>
  </tr>
</table> 

<% if(isAhsSupported) { %>
    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
      <tr>
        <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
      </tr>
      <tr>
        <td>     
          <bean:message key="clone.tray.wizard.ahs.warning"/> 
        </td>
      </tr>
    </table>
<% } %>

</html:form>
</body>

</html:html>
