<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_newprofileform_include.jsp     1.3     03/09/17     SMI"
   * 
   */
 --%>
<!-- NOTE: This include page requires a 
      PoolCreateForm form variable 
      to be defined.
 -->

<td width="100%" valign="top"> <!-- td for profile inputs -->
  <table>
    <tr>
      <td align="left" nowrap>
        <div class="table-normal-text">
          <bean:message key="storage.mgmt.system.profileinfo.table.name" />
        </div>
      </td>                        
      <td align="left" nowrap>
        <div class="table-normal-text"> 
          <% String maxLen = 
              "" + Constants.ObjectValidation.MAX_PROFILE_NAME; %>
          <html:text property="newName" maxlength="<%=maxLen%>"/>
        </div>
      </td>
    </tr>                        
    <tr>
      <td align="left" nowrap>
        <div class="table-normal-text">
          <bean:message key="storage.mgmt.system.profileinfo.table.desc" />
        </div>
      </td>                        
      <td align="left" nowrap>
        <div class="table-normal-text"> 
          <% String maxDescLen = 
              "" + Constants.ObjectValidation.MAX_PROFILE_DESC; %>
          <html:text property="newDescription" maxlength="<%=maxDescLen%>"/>
        </div>
      </td>
    </tr>                        
    <tr>
      <td align="left" nowrap>
        <div class="table-normal-text">
          <bean:message key="storage.mgmt.system.profileinfo.table.raid" />
        </div>
      </td>
      <td align="left" nowrap>
        <div class="table-normal-text">
          <html:select property="newRaidLevel">
            <html:option key="array.raid.0" value='<%="" + Constants.RAIDLevel.RAID_0%>'/>
            <html:option key="array.raid.1" value='<%="" + Constants.RAIDLevel.RAID_1%>'/>
            <%
              if(form.canHaveRaid5()) {
            %>
               <html:option key="array.raid.5" value='<%="" + Constants.RAIDLevel.RAID_5%>'/>
            <% } %>
          </html:select>
        </div>
       </td>
    </tr>  
    <tr>
       <td align="left" nowrap>
         <div class="table-normal-text">
           <bean:message key="storage.mgmt.system.profileinfo.table.segmentsize" />
         </div>
       </td>
       <td align="left" nowrap>
         <div class="table-normal-text">           
           <%
             if(!form.canChangeSegmentSize()) {
                String currentBlkSize = 
                  "array.blocksize." +
                  currentT4.getBlockSize();
           %>
               <bean:message key="<%=currentBlkSize%>"/>
               <html:hidden name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newSegmentSize" value='<%="" + currentT4.getBlockSize()%>'/>

           <%
             } else {
           %>
           <html:select property="newSegmentSize">
   		     <html:option key="array.blocksize.4096" value='<%="" + Constants.StorageSize._4K%>'/>
             <html:option key="array.blocksize.8192" value='<%="" + Constants.StorageSize._8K%>'/>
             <html:option key="array.blocksize.16384" value='<%="" + Constants.StorageSize._16K%>'/>
             <html:option key="array.blocksize.32768" value='<%="" + Constants.StorageSize._32K%>'/>
             <html:option key="array.blocksize.65536" value='<%="" + Constants.StorageSize._64K%>'/>
          </html:select>
          <% } %>
        </div>
      </td>
    </tr>  
    <tr>
      <td align="left" nowrap>
        <div class="table-normal-text">
           <bean:message key="storage.mgmt.system.profileinfo.table.readahead" />
        </div>
      </td>
      <td align="left" nowrap>
        <div class="table-normal-text">
           <%
             // if we can't change the segment size,
             //  then we can't change the readahead mode either
             if(!form.canChangeSegmentSize()) {
                String ra = (currentT4.getReadaheadMode() != 0) ? "1" : "0";
                String currentReadahead = 
                  "array.readahead." + ra;
           %>
               <bean:message key="<%=currentReadahead%>"/>
               <html:hidden name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newReadaheadMode" value="<%=ra%>"/>
           <%
             } else {
           %>
          <html:select property="newReadaheadMode">
            <html:option key="array.readahead.0" value="0"/>
            <html:option key="array.readahead.1" value="1"/>
          </html:select>
          <% } %>
        </div>
      </td>
    </tr>  
    <tr>
      <td align="left" nowrap>
        <div class="table-normal-text">
         <bean:message key="storage.mgmt.profile.details.table.numberdrives" />
        </div>
      </td>
      <td align="left" nowrap>
        <div class="table-normal-text">
          <%=Constants.ProfileProperties.NUMBER_OF_DRIVES_VARIABLE%>
        </div>
      </td>
    </tr>  
    <tr>
      <td align="left" nowrap>
        <div class="table-normal-text">
          <bean:message key="storage.mgmt.profile.details.table.arraytype" />
        </div>
      </td>
      <td align="left" nowrap>
        <div class="table-normal-text">                                                   
          <select name="newArrayType">
           <% 
              int[] types = form.getPossibleArrayTypes();
              String type = "array.type.";
              for(int i = 0; i < types.length; i++) { 
                if(types[i] == form.getNewArrayType()) {
           %>
                  <option value="<%=types[i]%>" selected><bean:message key="<%=type + types[i]%>"/>
           <%
                } else {
           %>
                  <option value="<%=types[i]%>"><bean:message key="<%=type + types[i]%>"/>
           <%
                }
              }// end for loop 
           %>
          </select>
        </div>
      </td>
    </tr>  
    <tr>
      <td align="left" nowrap>
        <div class="table-normal-text">
          <bean:message key="storage.mgmt.profile.details.table.dedicatedhotspare" />
        </div>
      </td>
      <td align="left" nowrap>
        <div class="table-normal-text">
           <!-- only show the dedicated hs if the feature is supported -->
           <% if(currentT4.isFeatureSupported(
               Constants.SupportedFeature.FEATURE_DEDICATED_HOT_SPARE)) { 
           %>
               <!-- if all trays can not have a dedicated hot spare, 
                    show and set 'no' for the new profile -->
               <% if(!form.canHaveDedicatedHs()) { %>
                   <bean:message key="storage.profile.dedicatedhotspare.value.0"/>
                   <html:hidden name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newDedicatedHotSpare" value="0"/>
               <% } else { %>
                    <html:select property="newDedicatedHotSpare">
                      <html:option key="storage.profile.dedicatedhotspare.value.1" value="1"/>
                      <html:option key="storage.profile.dedicatedhotspare.value.0" value="0"/>
                    </html:select>
               <% } %>
         <% } else {%>
                <bean:message key="not.supported.firmware"/>
                <html:hidden name="<%=Constants.HttpSessionFields.CREATE_POOL_FORM_NAME%>" property="newDedicatedHotSpare" value="0"/>
         <% } %>
        </div>
      </td>
    </tr>  
 </table>
</td> <!-- end td for profile inputs -->
