<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)sm_manage_pools_include.jsp    1.10    03/09/10     SMI"
   * 
   */
 --%>

<%
boolean hasPoolList = session.getAttribute(Constants.HttpSessionFields.POOL_LIST) != null;
boolean showHelpTextAndButtons = request.getAttribute(Constants.HttpRequestFields.POOLS_INCLUDE_HIDE_HELP) == null;
%>
<% if (showHelpTextAndButtons) { %>
<!-- pool section instructions --> 
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="8" width="1" src="images/general/dot.gif"></td>
  </tr>
  <tr>
    <bean:message key="express.subreports.pool.instructions"/>
  </tr>
</table>

<%@include file="/layout/spacer.jsp"%>

  <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr>
            <td nowrap>
              <div class="major-category-text">
                <%
                  T4Interface array = (T4Interface)session.getAttribute(Constants.HttpSessionFields.CURRENT_T4);
                  String name = "";
                  if(array != null){
                  	name = array.getName();
                  }
		  String poolsTableTitle = "storage.mgmt.system.expert.pools.header";
		  if(request.getAttribute(Constants.HttpRequestFields.POOLS_TABLE_TITLE) != null ){
		  	poolsTableTitle = (String)request.getAttribute(Constants.HttpRequestFields.POOLS_TABLE_TITLE);
			name=(String)request.getAttribute(Constants.HttpRequestFields.POOLS_TABLE_TITLE_OBJECT);
		  }

                %>
                <bean:message key="<%=poolsTableTitle%>" arg0="<%=name%>"/>                 
              </div>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
    </tr>
  </table>

<!-- spacer between two sections -->
<%@include file="/layout/spacer.jsp"%>

<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>

    <td align="left" valign="middle">
      <table border="0" cellpadding="0" cellspacing="0">
         <tr>
            <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <component:button text="button.create" href="javascript:createPoolWizard();" title="button.create" isEnabled="<%=!readOnly%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>   
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td>              
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                                <component:button text="button.delete" href="javascript:document.forms[0].action='root.menu.item0.item2poolsdelete.do';document.forms[0].submit();" title="button.delete" isEnabled="<%=hasPoolList && !readOnly%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td>   
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                                <component:button text="storage.mgmt.system.expert.pools.online.button" href="javascript:document.forms[0].action='root.menu.item0.item2pools.do';submitForm('online');" title="storage.mgmt.system.expert.pools.online.button" isEnabled="<%=hasPoolList && !readOnly%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td> 
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                               <component:button text="storage.mgmt.system.expert.pools.offline.button" href="javascript:document.forms[0].action='root.menu.item0.item2poolsoffline.do';document.forms[0].submit();" title="storage.mgmt.system.expert.pools.offline.button" isEnabled="<%=hasPoolList && !readOnly%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td> 
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <component:button text="storage.mgmt.system.expert.pools.initialize.button" href="javascript:document.forms[0].action='root.menu.item0.item2poolsinit.do';document.forms[0].submit();" title="storage.mgmt.system.expert.pools.initialize.button" isEnabled="<%=hasPoolList && !readOnly%>" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>                        
             <td><img alt border="0" height="20" width="10" src="images/general/dot.gif"></td> 
             <td>
              <table border="0" cellpadding="1" cellspacing="0" class="button-link-enabled-text">
                 <tr>
                   <td>
                      <table>
                        <tr>
                           <td align="center" valign="middle" nowrap>
                              <component:button text="storage.mgmt.system.expert.pools.refresh.button" href="javascript:submitForm('show');" title="storage.mgmt.system.expert.pools.refresh.button" isEnabled="true" />
                           </td>
                        </tr>
                      </table>
                   </td>                                      
                 </tr>
               </table>
             </td>                        
           </tr>
       </table>
   </td>
 
    
   
    
 </tr>
 <tr>
   <td><img alt border="0" height="5" src="/images/general/dot.gif" width="1"></td>
 </tr>
</table>

<% } %>

  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>                  
              <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
                <tr>
                  <td>
                    <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                      <tr class="header-row">                        
                        <% if (showHelpTextAndButtons) { %>
                        <td align="center" valign="middle" nowrap><a href="javascript:checkAll(document.forms[0])"><img src="images/icons/select-all-small.gif" alt='<bean:message key="table.select.all"/>' vspace="2" border="0" width="11" height="13"></a><a href="javascript:unCheckAll(document.forms[0])"><img src="images/icons/deselect-all-small.gif" alt='<bean:message key="table.deselect.all"/>' vspace="2" border="0" width="11" height="13"></a></td>
                        <% } %>
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.name"/>
                          </div>
                        </td>                                                
                        <%
                         // if we are hiding the help, then we're on
                         //  the search page; show array name
                          if (!showHelpTextAndButtons) { %>
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="storage.mgmt.system.array.name"/>
                          </div>
                        </td>  
                        <% } %>
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.raid"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="raid.group.table.column.profilename"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.available"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.total"/>
                          </div>
                        </td>  
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.status"/>
                          </div>
                        </td>
                        <td align="left">
                          <div class="table-header-text">
                            <bean:message key="pools.table.state"/>
                          </div>
                        </td>   
                      </tr>
                      <!-- begin data row listing -->
                      <logic:notPresent name="<%=Constants.HttpSessionFields.POOL_LIST%>">
                        <tr>
                          <td colspan="8">
                             <bean:message key="pools.table.nopools"/>
                          </td>
                        </tr>
                      </logic:notPresent>
                      <logic:present name="<%=Constants.HttpSessionFields.POOL_LIST%>">
                         <logic:iterate id="pool" name="<%=Constants.HttpSessionFields.POOL_LIST%>" type="RaidGroupInterface" indexId="idx">
                           <tr>
                             <% if (showHelpTextAndButtons) { %>
                             <td>
                                <div class="table-normal-text">
                                   <input type="checkbox" name="<%="pools" + idx %>" value="<%= idx%>" <% if(readOnly) { %> disabled <%}%>/>
                                </div>
                             </td>
                             <% } %>
                             <td align="left">
                                <div class="table-normal-text">
<a href="root.menu.item0.item2pooldetails.do?name=<bean:write name='pool' property='name'/>&t4Name=<bean:write name='pool' property='t4Name'/>">
                                     <bean:write name="pool" property="name"/>
                                     </a>                                 
                                </div>
                             </td>
                             <% 
                               // if we are hiding the help, then we're on
                               //  the search page; show array name
                               if (!showHelpTextAndButtons) { %>
                             <td align="left">
                                <div class="table-normal-text">
                                  <bean:write name="pool" property="t4Name"/>
                                </div>
                             </td>
                             <% } %>
                             <td align="right">
                                <div class="table-normal-text">
                                  <bean:write name="pool" property="raidLevel"/>
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <html:link href="root.menu.item0.item3profiledetails.do"
              	                   paramId="profileName" paramName="pool" paramProperty="profileName">
                                    <bean:write name="pool" property="profileName"/>
                                  </html:link>
                                </div>
                             </td>
                             <td align="right">
                                <div class="table-normal-text">
                                  <%=nf.format(nf.parse(Convert.bytesToGB(pool.getAvailableCapacity())))%>  
                                  <bean:message key="size.GB"/>                               
                                </div>
                             </td>
                             <td align="right">
                                <div class="table-normal-text">
                                  <%=nf.format(nf.parse(Convert.bytesToGB(pool.getTotalCapacity())))%> 
                                  <bean:message key="size.GB"/>                                                                 
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <%
                                    String status = "storage.mgmt.pool.status." + pool.getStatus();                                   
                                  %>
                                  <bean:message key="<%=status%>"/>
                                </div>
                             </td>
                             <td>
                                <div class="table-normal-text">
                                  <%
                                    String state = "storage.mgmt.pool.state." + pool.getState();
                                  %>
                                  <bean:message key="<%=state%>"/>
                                </div>
                             </td>
                           </tr>
                         </logic:iterate>
                       </logic:present>  
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
