<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)admin_notifications.jsp    1.18    03/09/04     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>
<%@ page import="com.sun.netstorage.array.mgmt.logger.EventCategoryInfo"%>
<%@ page import="com.sun.netstorage.array.mgmt.logger.EventInfo"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="java.util.Iterator"%>
<%@ page import="java.util.List"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale -->

<!-- Place Java Script Here -->

<!-- HTML -->

<!-- Get the attributes set by AdminNotificationsAction. The
"selectedCategory" attribute will be non-null if we should display the
category details screen. Otherwise, the "selectedEvent" attribute will
be non-null if we should display the event details screen. Otherwise,
display the default screen showing the list of categories. -->

<%
String action = (String) request.getAttribute("action");
String formTargetSuffix="";
if(action != null) {
	if(action.compareTo("selectCategory") == 0) {
		formTargetSuffix="category";
	} else if(action.compareTo("selectEvent") == 0) {
		formTargetSuffix="event";
	}
	
}
EventCategoryInfo categoryInfo = (EventCategoryInfo)
    session.getAttribute(Constants.HttpSessionFields.SELECTED_CATEGORY);
EventInfo eventInfo = (EventInfo)
    session.getAttribute(Constants.HttpSessionFields.SELECTED_EVENT);
// get the list of All subscribers
List all =
  (List)session.getAttribute(Constants.HttpSessionFields.ALL_SUBSCRIBERS_LIST);
boolean haveAllSubscribers = (all != null && !all.isEmpty());
boolean haveCategorySubscribers = categoryInfo != null && categoryInfo.getSubscribers().length > 0;
%>

<head>
<%@include file="/layout/page_head_section.jsp"%>
        <title>
            <bean:message  key="admin.notifications.notifications"/>
        </title>
</head>

<%@include file="/layout/bodytag.jsp"%>
<%@include file="/layout/top.jsp"%>
<%@include file="/layout/breadcrumb.jsp"%>
<%@include file="/layout/spacer.jsp"%>
<%@include file="/layout/user_messages.jsp"%>

<%
String uri = request.getRequestURL().toString();
if(uri.indexOf("root.menu.item3.item5.do") >= 0 ||
   uri.indexOf("progress") >= 0) {
//list categories
%>
<form name="events" action="root.menu.item3.item5.do" method="POST">
<%
} else if(uri.indexOf("root.menu.item3.item5category.do") >= 0) {
//category detail
%>
<form name="events" action="root.menu.item3.item5category.do" method="POST">
<%
} else {
%>
<form name="events" action="root.menu.item3.item5event.do" method="POST">
<%
}
%>
<input type="hidden" name="action" value="<%=action%>">

<div class="content-layout">

<% if (uri.indexOf("root.menu.item3.item5category.do") >= 0) { %>

<input name="<%=Constants.HttpSessionFields.SELECTED_CATEGORY%>"
       value="<%=categoryInfo.getCategory()%>"
       type="hidden">

<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.eventcategorydetail" />
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<table width="100%">
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr class="header-row">
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.eventid"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.name"/>
                        </div>
                    </td>
                </tr>
                <%
                EventInfo[] events = categoryInfo.getEvents();
                if (null == events) {
                    %>
                    <tr>
                        <td colspan="2">
                            <div class="table-normal-text">null event list</div>
                        </td>
                    </tr>
                    <%
                } else {
                    for (int i = 0; i < events.length; ++i) {
                        EventInfo event = events[i];
                        if (null == event) {
                            %>
                            <tr>
                                <td colspan="2">
                                    <div class="table-normal-text">null event</div>
                                </td>
                            </tr>
                            <%
                        } else {
                            %>
                            <tr>
                                <td>
                                    <div class="table-normal-text">
                                        <%=event.getId()%>
                                    </div>
                                </td>
                                <td>
                                    <div class="table-normal-text" >
                                        <a href="root.menu.item3.item5event.do?action=selectEvent&selectedEvent=<%=URLEncoder.encode(event.getEvent(), "UTF-8")%>">
					<bean:message key="<%="admin.notification.event." + event.getEvent()%>"/>
					</a>
                                    </div>
                                </td>
                            </tr>
                            <%
                        }
                    }
                }
                %>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<jsp:include page="/layout/spacer.jsp" flush="true"/>


<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.subscribedusers" />
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<component:button text="button.remove"
                  href="javascript:submitForm('removeCategorySubscribers');"
                  title="admin.notifications.removecategorysubscriber"
                  isEnabled="<%=!readOnly && haveCategorySubscribers %>"/>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<table width="100%">
<tr>
  <td>
    <bean:message key="admin.notifications.instructions.category"/>
  </td>
</tr>
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr class="header-row">
                    <td align="right">
                        <div class="table-header-text">
                            &nbsp;
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.emailaddress"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.subscribertype"/>
                        </div>
                    </td>
                </tr>
                <% 
                   // if we don't have any subscribers...
                   if(!haveCategorySubscribers && !haveAllSubscribers) {
                %>
                    <tr>
                        <td colspan="3"> 
                          <div class="table-normal-text">
                            <bean:message key="admin.notifications.none"/>
                          </div>
                        </td>
                    </tr>
                <%
                   // end no subscribers
                   } else {
                     // show any category subscribers 
                     if(haveCategorySubscribers) {
                       String[] categorySubscribers = categoryInfo.getSubscribers();
                       for (int i = 0; i < categorySubscribers.length; ++i) {
                         String sub = categorySubscribers[i];
                %>
                    <tr>
                        <td align="right">
                            <div class="table-normal-text">
                                <input name="<%=Constants.HttpRequestFields.CATEGORY_SUBSCRIBERS_PARAM%>"
                                       value="<%=sub%>"
                                       type="checkbox">
                            </div>
                        </td>
                        <td><div class="table-normal-text"><%=sub%></div></td>
                        <td> 
                          <div class="table-normal-text">
                            <bean:message key="admin.notifications.category"/>
                          </div>
                        </td>
                    </tr>
                    <%
                      }// end for
                     } // end haveCategorySubscribers
                     // get the list of all subscribers
                     if(haveAllSubscribers) {
                      for (int j = 0; j < all.size(); ++j) {
                        String sub = (String)all.get(j); 
                %>
                    <tr>
                        <td><div class="table-normal-text">&nbsp;</div></td>
                        <td><div class="table-normal-text"><%=sub%></div></td>
                        <td> 
                          <div class="table-normal-text">
                            <bean:message key="admin.notifications.all"/>
                          </div>
                        </td>
                    </tr>
                    <%
                      }// end for
                    } // end all
                  } // end else have subscribers
                %>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<!-- end category subscribers list -->

<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.newsubscription" />
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<component:button text="button.add"
                  href="javascript:submitForm('addCategorySubscriber');"
                  title="admin.notifications.addcategorysubscriber"
                  isEnabled="<%=!readOnly%>"/>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<table width="100%">
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr>
                    <td>
                        <div class="table-label-text">
                            <bean:message key="admin.notifications.addcategorysubscriber"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-normal-text">
                            <input name="<%=Constants.HttpRequestFields.CATEGORY_SUBSCRIBERS_PARAM%>">
                        </div>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<% } else if (uri.indexOf("root.menu.item3.item5event.do") >= 0) { %>

<input name="<%=Constants.HttpSessionFields.SELECTED_EVENT%>"
       value="<%=eventInfo.getEvent()%>"
       type="hidden">

<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.eventdetail" />
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<table width="100%">
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr class="header-row">
                    <td>
                        <div class="table-header-text">
                            <bean:message key="detail.property"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="detail.value"/>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td align="left">
                        <div class="table-label-text">
                            <bean:message key="admin.notifications.eventid"/>
                        </div>
                    </td>
                    <td align="left">
                        <div class="table-normal-text">
                            <%=eventInfo.getId()%>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td align="left">
                        <div class="table-label-text">
                            <bean:message key="admin.notifications.event"/>
                        </div>
                    </td>
                    <td align="left">
                        <div class="table-normal-text">
                            <bean:message key="<%="admin.notification.event." + eventInfo.getEvent()%>"/>
                        </div>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<% boolean haveEventSubscribers = (eventInfo.getSubscribers().length > 0); %>

<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.subscribedusers"/>
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<component:button text="button.remove"
                  href="javascript:submitForm('removeEventSubscribers');"
                  title="admin.notifications.removeeventsubscriber"
                  isEnabled="<%=!readOnly && haveEventSubscribers %>"/>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<table width="100%">
<tr>
  <td>
    <bean:message key="admin.notifications.instructions.event"/>
  </td>
</tr>
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr class="header-row">
                    <td align="right">
                        <div class="table-header-text">
                            &nbsp;
                        </div>
                    </td>
                    <td align="left">
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.emailaddress"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.subscribertype"/>
                        </div>
                    </td>
                </tr>

                <% 
                   // if we dont' have any subscribers, show none in the table
                   if(!haveEventSubscribers &&
                      !haveCategorySubscribers &&
                      !haveAllSubscribers) {
                %>
                    <tr>
                        <td colspan="3"> 
                          <div class="table-normal-text">
                            <bean:message key="admin.notifications.none"/>
                          </div>
                        </td>
                    </tr>
                <%
                   } else {
                      if(haveEventSubscribers) {
                        String[] subscribers = eventInfo.getSubscribers();
                        for (int n = 0; n < subscribers.length; ++n) {
                %>
                    <tr>
                        <td align="right">
                            <div class="table-normal-text">
                                <input name="<%=Constants.HttpRequestFields.EVENT_SUBSCRIBERS_PARAM%>"
                                       value="<%=subscribers[n]%>"
                                       type="checkbox">
                            </div>
                        </td>
                        <td align="left">
                            <div class="table-normal-text">
                                <%=subscribers[n]%>
                            </div>
                        </td>
                        <td align="left">
                            <div class="table-normal-text">
                              <bean:message key="admin.notifications.event"/>
                            </div>
                        </td>
                    </tr>

                <%
                    }// end for
                   } // end haveEventSubscribers
                   // show any category subscribers 
                   if(haveCategorySubscribers) {
                       String[] categorySubscribers = categoryInfo.getSubscribers();
                       for (int k = 0; k < categorySubscribers.length; ++k) {
                         String sub = categorySubscribers[k];
                %>
                    <tr>
                        <td><div class="table-normal-text">&nbsp;</div></td>
                        <td><div class="table-normal-text"><%=sub%></div></td>
                        <td> 
                          <div class="table-normal-text">
                            <bean:message key="admin.notifications.category"/>
                          </div>
                        </td>
                    </tr>
                    <%
                      }// end for
                     } // end haveCategorySubscribers
                     // get the list of all subscribers
                     if(haveAllSubscribers) {
                      for (int j = 0; j < all.size(); ++j) {
                        String sub = (String)all.get(j); 
                %>
                    <tr>
                        <td><div class="table-normal-text">&nbsp;</div></td>
                        <td><div class="table-normal-text"><%=sub%></div></td>
                        <td> 
                          <div class="table-normal-text">
                            <bean:message key="admin.notifications.all"/>
                          </div>
                        </td>
                    </tr>
                    <%
                      }// end for
                    } // end all
                  } // end else have subscribers
                %>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<!-- end event subscribers listing -->

<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.newsubscription"/>
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<component:button text="button.add"
                  href="javascript:submitForm('addEventSubscriber');"
                  title="admin.notifications.addeventsubscriber"
                  isEnabled="<%=!readOnly%>"/>
<jsp:include page="/layout/spacer.jsp" flush="true"/>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<table width="100%">
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr>
                    <td>
                        <div class="table-label-text">
                            <bean:message key="admin.notifications.addeventsubscriber"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-normal-text">
                            <input name="<%=Constants.HttpRequestFields.EVENT_SUBSCRIBERS_PARAM%>">
                        </div>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<% } else { %>

<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.eventcategories" />
</jsp:include>

<component:button text="refreshlist"
                  href="javascript:submitForm('events');"
                  title="refreshlist"
                  isEnabled="true"/>
<jsp:include page="/layout/spacer.jsp" flush="true"/>
<table width="100%">
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left" >
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr class="header-row">
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.eventcategory"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.numberofevents"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.numberofsubscribers"/>
                        </div>
                    </td>
                </tr>
                <%
                try {
                    List categories = (List) session.getAttribute("CategoryList");
                    if (null == categories) {
                        out.print("<tr><td colspan=\"3\">");
                        out.print("Category list parameter is null.");
                        out.print("</td></tr>");
                    } else {
                        for (Iterator i = categories.iterator();
                             i.hasNext(); ) {
                            categoryInfo = (EventCategoryInfo) i.next();
                            String category = categoryInfo.getCategory();
                    %>
                    <tr >
                        <td>
                            <div class="table-normal-text">
                                <a href="root.menu.item3.item5category.do?action=selectCategory&selectedCategory=<%=URLEncoder.encode(category, "UTF-8")%>">
				<bean:message key="<%="admin.notification.category." + category%>"/>
				</a>
                            </div>
                        </td>
                        <td align="right">
                            <div class="table-normal-text">
                                <%=categoryInfo.getEvents().length%>
                            </div>
                        </td>
                        <td  align="right">
                            <div class="table-normal-text">
                                <%=categoryInfo.getSubscribers().length%>
                            </div>
                        </td>
                    </tr>
                    <%
                        }
                    }
                } catch (Throwable x) {
                    Trace.error(this,"admin_notification.jsp", x.getMessage());
                }
                %>
            </table>
        </td>
    </td>
</table>
</td>
</td>
</table>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.subscribedusers" />
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<component:button text="button.remove"
                  href="javascript:submitForm('removeAllSubscriber');"
                  title="admin.notifications.removeallsubscriber"
                  isEnabled="<%=!readOnly && haveAllSubscribers %>"/>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<table width="100%">
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr class="header-row">
                    <td align="right">
                        <div class="table-header-text">
                            &nbsp;
                        </div>
                    </td>
                    <td>
                        <div class="table-header-text">
                            <bean:message key="admin.notifications.emailaddress"/>
                        </div>
                    </td>
                </tr>
                <%
                if(haveAllSubscribers) {
                 for (int i = 0; i < all.size(); ++i) {
                    String sub = (String)all.get(i); 
                    %>
                    <tr>
                        <td align="right">
                            <div class="table-normal-text">
                                <input name="<%=Constants.HttpRequestFields.ALL_SUBSCRIBERS_PARAM%>"
                                       value="<%=sub%>"
                                       type="checkbox">
                            </div>
                        </td>
                        <td><div class="table-normal-text"><%=sub%></div></td>
                    </tr>
                    <%
                 }
                } else {
                %>
                    <tr>
                        <td colspan="3"> 
                          <div class="table-normal-text">
                            <bean:message key="admin.notifications.none"/>
                          </div>
                        </td>
                    </tr>
                <%
                }
                %>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<jsp:include page="/layout/spacer.jsp" flush="true"/>
<!-- end all subscribers listing -->

<jsp:include page="/layout/spacer.jsp" flush="true"/>
<jsp:include page="/layout/section_header.jsp" flush="true">
    <jsp:param name="sectionname" value="admin.notifications.newsubscription"/>
</jsp:include>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<component:button text="button.add"
                  href="javascript:submitForm('addAllSubscriber');"
                  title="admin.notifications.addallsubscriber"
                  isEnabled="<%=!readOnly%>"/>
<jsp:include page="/layout/spacer.jsp" flush="true"/>


<table width="100%">
<tr>
<td>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left">
    <tr>
        <td>
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr>
                    <td>
                        <div class="table-label-text">
                            <bean:message key="admin.notifications.addallsubscriber"/>
                        </div>
                    </td>
                    <td>
                        <div class="table-normal-text">
                            <input name="<%=Constants.HttpRequestFields.ALL_SUBSCRIBERS_PARAM%>">
                        </div>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</td>
</tr>
</table>

<jsp:include page="/layout/spacer.jsp" flush="true"/>

<% } %>

</div>
</form>

</body>

</html:html>
