/**
 * Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 * 
 * "%Z%%M%		%I%		%E%		SMI"
 *
 */

/**
 * Common JavaScript functions
 */


/**
 * Function to check all checkboxes on a page
 */
function checkAll(pageForm) {
	for (var i=0; i<pageForm.elements.length; ++i)
		if (pageForm.elements[i].type == "checkbox")
			pageForm.elements[i].checked=true;
}

		
function unCheckAll(pageForm) {
	for (var i=0; i<pageForm.elements.length; ++i)
		if (pageForm.elements[i].type == "checkbox")
			pageForm.elements[i].checked=false;
}

/**
 * Function to submit the first form on a page.
 *
 * @param action If specified, the action parameter of the form will be set
 *               to this value (there must already be a hidden form element
 *               in the form named action.
 * @param confirmText String to display in a confirm dialog before submitting
 *                the form.  If the user presses cancel on the submit dialog,
 *                the form will not be submitted.
 * @param optionalParams Specify any number of additional name=value pairs
 *                       as arguments to the function call.
 * e.g. ( submitForm("save", "myfield1=val1", "myfield2=val2"...);
 * (NOTE: optional params is not yet implemented
 */
 var formSubmitted = 0;
function submitForm(action, confirmText, optonalParams) {
	var actionField;
	if (typeof document.forms[0].request_action != "undefined")
		actionField = document.forms[0].request_action;
	else
		actionField = document.forms[0].action;

	if (typeof confirmText == "string") {
		if (confirm(confirmText)) {
			actionField.value = action;
			document.forms[0].submit();
		}
	}
	// No confirm text passed, just submit the form.
	else {
		actionField.value = action;
		if(formSubmitted == 0) {
			document.forms[0].submit();
			formSubmitted = 1;
		} else {
		    alert(formSubmittedTwiceMsg);
		}
	}
}

NS4 = (document.layers) ? true : false;

function checkEnter(event, action)
{ 	
	var code = 0;
	if (NS4){
		code = event.which;
		}
	else {
		code = event.keyCode;
		}
	if (code==13){
		submitForm(action);
	}
	return 0;
}


function setReadOnly(object, isReadOnly) {
	if (isReadOnly)
		object.blur();
}

/**
 * Function to open a small external window for displaying simple text
 * @param text Text to display in the external window
 */
function openTextDialog(text) {
	var detailWindow = window.open("layout/text_dialog.jsp?text="+text, "textDialog", "HEIGHT=40,WIDTH=450");
	detailWindow.focus();
	return false;
}

// Wizard helper functions

var wizard;			// This variable holds a reference to the wizard window

function openWizard(contentAction, windowName, title, TOCTitles, UIScheme, redrawParent, activePage) {

	// Create url string to use
	urlString = "WizardFramework.do?";
	urlString += "page=wizardFrame";
	urlString += "&contentAction="+contentAction;
	urlString += "&wizardTitle="+title;
	urlString += "&redrawParent="+redrawParent;
	urlString += "&activePage="+activePage;
	urlString += "&totalPages="+TOCTitles.length;
	
	for (var i=0; i<TOCTitles.length; ++i) {
		urlString += "&tocTitles="+TOCTitles[i];
	}

    wizard = window.open(urlString, windowName,'scrollbars,resizable=no,width=850,height=500');
    wizard.focus();
}

function openWizardInContext(contentAction, windowName, title, context, TOCTitles, UIScheme, redrawParent, activePage) {

	// Create url string to use
	urlString = "WizardFramework.do?";
	urlString += "page=wizardFrame";
	urlString += "&contentAction="+contentAction;
	urlString += "&wizardTitle="+title;
	urlString += "&redrawParent="+redrawParent;
	urlString += "&activePage="+activePage;
	urlString += "&totalPages="+TOCTitles.length;
	urlString += "&context="+context;
	
	for (var i=0; i<TOCTitles.length; ++i) {
		urlString += "&tocTitles="+TOCTitles[i];
	}

    wizard = window.open(urlString, windowName,'scrollbars,resizable=no,width=850,height=500');
    wizard.focus();
}

function createVolumeWizard() {

	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.volumes.createwizard.toc.1",
					 		   "storage.mgmt.volumes.createwizard.toc.2",
					 		   "storage.mgmt.volumes.createwizard.toc.3",
					 		   "storage.mgmt.volumes.createwizard.toc.4");

	openWizard('VolumeCreateWizard', 'VolumeWizard', 'storage.mgmt.volumes.createvolume', TOCTitles, null, false, 0);
}

function createVolumeOnPool(poolId) {

	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.volumes.createwizard.toc.1",
					 		   "storage.mgmt.volumes.createwizard.toc.2",
					 		   "storage.mgmt.volumes.createwizard.toc.3",
					 		   "storage.mgmt.volumes.createwizard.toc.4");

	openWizardInContext('VolumeCreateWizard', 'VolumeWizard', 'storage.mgmt.volumes.createvolume', poolId, TOCTitles, null, false, 0);
}

function cloneT4Wizard() {
   
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("main.menu.clone.t4.wizard.toc.1",
					 		   "main.menu.clone.t4.wizard.toc.2",
					 		   "main.menu.clone.t4.wizard.toc.3");

	openWizard('CloneT4Wizard', 'CloneWizard', 'main.menu.clone.t4.wizard.title', TOCTitles, null, false, 0);
}


function configStorageByProfileWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("configure.storage.wizard.toc.1",
					 		   "configure.storage.wizard.toc.2",
					 		   "configure.storage.wizard.toc.3",
					 		   "configure.storage.wizard.toc.4"
					 		   );

	openWizard('ConfigStorageByProfileWizard', 'ConfigStorageByProfileWizard', 'configure.storage.wizard.title', TOCTitles, null, false, 0);
}

function addProfileWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.system.profile.wizard.toc.2",
					 		   "storage.mgmt.system.profile.wizard.toc.3"
					 		   );

	openWizard('AddProfileWizard', 'AddProfileWizard', 'storage.mgmt.system.addprofile.wizard.title', TOCTitles, null, false, 0);
}

function traySettingWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.system.expert.tray.setting.wizard.toc.1",
					 		   "storage.mgmt.system.expert.tray.setting.wizard.toc.9"
					 		   );

	openWizard('TraySettingWizard', 'TraySettingWizard', 'storage.mgmt.system.expert.tray.setting.wizard.title', TOCTitles, null, false, 0);
}

function createPoolWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.pool.createwiz.toc.1",
                               "storage.mgmt.pool.createwiz.toc.2",
                               "storage.mgmt.pool.createwiz.toc.3",
                               "storage.mgmt.pool.createwiz.toc.4"
                               );

	openWizard('CreatePoolWizard', 'CreatePoolWizard', 'storage.mgmt.pool.createwiz.title', TOCTitles, null, false, 0);
}

function createPoolOnTray(trayId) {
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("storage.mgmt.pool.createwiz.toc.1",
                               "storage.mgmt.pool.createwiz.toc.2",
                               "storage.mgmt.pool.createwiz.toc.3",
                               "storage.mgmt.pool.createwiz.toc.4"
                               );

	openWizardInContext('CreatePoolWizard', 'CreatePoolWizard', 'storage.mgmt.pool.createwiz.title', trayId, TOCTitles, null, false, 0);

}

function cloneTrayWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("clone.tray.wizard.toc.1",
                               "clone.tray.wizard.toc.2", 
                               "clone.tray.wizard.toc.3",
                               "clone.tray.wizard.toc.4"
					 		   );

	openWizard('CloneTrayWizard', 'CloneTrayWizard', 'clone.tray.wizard.title', TOCTitles, null, false, 0);
}

function createVolumeGroupWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("create.volume.group.wizard.toc.1",
                               "create.volume.group.wizard.toc.2", 
                               "create.volume.group.wizard.toc.3"
					 		   );

	openWizard('CreateVolumeGroupWizard', 'CreateVolumeGroupWizard', 'create.volume.group.wizard.title', TOCTitles, null, false, 0);
}

function addExpansionWizard() {
    
	// Define the strings used for the wizard table of contents
	var TOCTitles = new Array ("add.expansion.wizard.toc.1",
                               "add.expansion.wizard.toc.2", 
                               "add.expansion.wizard.toc.3", 
                               "add.expansion.wizard.toc.4" 
					 		   );

	openWizard('AddExpansionWizard', 'AddExpansionWizard', 'add.expansion.wizard.title', TOCTitles, null, false, 0);
}

function removeExpansionWizard(showRarp) {
    
    if(showRarp) {
	  // Define the strings used for the wizard table of contents
	  var TOCTitles = new Array ("remove.expansion.wizard.toc.1",
                                 "remove.expansion.wizard.toc.2", 
                                 "remove.expansion.wizard.toc.3", 
                                 "remove.expansion.wizard.toc.4", 
                                 "remove.expansion.wizard.toc.5" 
					 		     );
	  openWizard('RemoveExpansionWizard', 'RemoveExpansionWizard', 'remove.expansion.wizard.title', TOCTitles, null, false, 0);
    } else {
	  // Define the strings used for the wizard table of contents
	  var TOCTitles = new Array ("remove.expansion.wizard.toc.2", 
                                 "remove.expansion.wizard.toc.3", 
                                 "remove.expansion.wizard.toc.4", 
                                 "remove.expansion.wizard.toc.5" 
					 		     );
	  openWizard('RemoveExpansionWizardNoRarp', 'RemoveExpansionWizard', 'remove.expansion.wizard.title', TOCTitles, null, false, 0);
    }
}
/** 
  Function that updates possible values for number of disks in 
  the profile.
  longerLength  - the length for RAID 5
  newValue - new value to insert if raid level is 0 or 1. The value is inserted as a second entry in the list. 
*/
function changeDiskValues(longerLength, newValue) {
    // get the index of selected raid level
    var rlIndex = document.forms[0].raidLevel.options.selectedIndex;
    var lastRaidLevel = document.forms[0].raidLevel.options.length-1; 
    var diskOptions = document.forms[0].numberDrives.options;
    if (longerLength == null) {
       longerLength = 14;
    }
    var diskSelected = document.forms[0].numberDrives.selectedIndex;
    if (rlIndex == lastRaidLevel 
        && diskOptions.length == longerLength) {
        // selected the last entry and there 
        // are longerLength entries in the diskDrive
        // removing the second entry and shifting all subsequent
        
        // if the entry is selected that is going away 'Variable" should 
        // be selected 
        for (i = 2; i< longerLength; i++) {
           var oneOption = document.forms[0].numberDrives.options[i]; 
           document.forms[0].numberDrives.options[i-1] = 
                new Option(oneOption.text,
                           oneOption.value,
                           oneOption.defaultSelected,
                           oneOption.selected);
        }
        document.forms[0].numberDrives.length = longerLength - 1;
        var selectedNow = diskSelected -1;
        if (selectedNow <= 0) {
            selectedNow = 0;
        } else { 
           document.forms[0].numberDrives.options[0].selected = false;
        }
        document.forms[0].numberDrives.selectedIndex = selectedNow;
    } else if (rlIndex != lastRaidLevel 
               && diskOptions.length == (longerLength -1)) {
        // not selecte the last entry and there 
        // are longerLength-1 entries in the diskDrive
        // insert an entry to the second position 
        document.forms[0].numberDrives.length = longerLength;
        for (i = (longerLength -1); i > 1 ; i--) {
           var oneOption = document.forms[0].numberDrives.options[i-1]; 
           document.forms[0].numberDrives.options[i] = 
                       new Option(oneOption.text,
                                  oneOption.value,
                                  oneOption.defaultSelected,
                                  oneOption.selected);
        }
        document.forms[0].numberDrives.options[1] = 
			new Option(newValue, 
                                   newValue, 
                                   false, 
                                   false);
    }
}
/** 
  Function that checks if a checkbox selection has been made and if yes, 
  submits the request. 
  If not alerts the user to make a selection. 
  Variable uncheckedMsg should be declared and populated with the message 
  before function is executed.
  pageForm - form whose checkboxes are checked
  checkedAction - action for the form to be submitted, if any checkbox is
  selected.
*/

function submitIfChecked(pageForm, checkedAction) {
   var allUnchecked = true;
   var i = 0; 
   while (i < pageForm.elements.length && allUnchecked) { 
       if (pageForm.elements[i].type == "checkbox" 
           && pageForm.elements[i].checked == true) {
           allUnchecked = false;
       }
       i++;
   }
   if (allUnchecked) {
      alert(uncheckedMsg );
   } else {
      pageForm.action = checkedAction;
      pageForm.submit();
   }       
}

