<%--
  /**
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   *
   * "@(#)admin_userlist.jsp    1.9    03/08/13     SMI"
   * 
   */
 --%>
<%@ include file="/layout/toptags.jsp"%>

<html locale="true">

<head>
<%@include file="/layout/page_head_section.jsp"%>
	<title>
		<bean:message  key="admin.users.title"/>
	</title>
</head>

<%@ page import="com.sun.netstorage.array.mgmt.cfg.admin.business.UserInterface" %>
<%@ page import="com.sun.netstorage.array.mgmt.cfg.admin.business.Role" %>

<%@ include file="/layout/bodytag.jsp"%>
<%@ include file="/layout/top.jsp"%>
<%@ include file="/layout/breadcrumb.jsp"%>
<%@ include file="/layout/spacer.jsp"%>
<%@ include file="/layout/user_messages.jsp"%>

<html:form action="root.menu.item3.item1.m1m2.do">

<jsp:include page="/layout/section_header.jsp" flush="true">
	<jsp:param name="sectionname" value="admin.users.list.title" />
</jsp:include>

<!-- hidden element which specifies the action for this form -->
<input type="hidden" name="action" value="<%=request.getAttribute("action")%>">

<div class="content-layout">

  <!-- page description for user -->
  <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
     <tr>
     	<td><bean:message key="admin.users.list.description" /></td>
     </tr>
  </table>

  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td>
        <%@include file="/layout/spacer.jsp"%>
      </td>
    </tr>
  </table>

  <!-- filter pulldown -->
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>
        <table border="0" cellspacing="0" cellpadding="0">
          <tr align="left">
            <td>
              <div class="table-title-text">
                <bean:message key="admin.users.list.filter" />:&nbsp;
              </div>
            </td>
            <td nowrap>
                <html:select size="1" property="userListFilter" 
                        onchange="javascript:submitForm();" >
                    <html:option value="">
                        <bean:message key="admin.role.all" /> 
                    </html:option>
                    <html:option value="<%=Role.STORAGE.getKey()%>">
                        <bean:message key="admin.role.storage"/>
                    </html:option>
                    <html:option  value="<%=Role.ADMIN.getKey()%>">
                        <bean:message key="admin.role.admin"/>
                    </html:option>
                    <html:option  value="<%=Role.GUEST.getKey()%>">
                        <bean:message key="admin.role.guest"/>
                    </html:option>
                </html:select>
            </td>
          </tr>
          <tr width="100%">
            <td nowrap colspan="3">
                <img alt border="0" src="images/general/dot.gif" width="1" height="5">
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>

  <!-- Button row -->
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>
      	<table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td align="left">
              <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td>
                    <component:button text="button.add" 
                        href="root.menu.item3.item1.m1m2adduser.do" 
                        title="button.add" isEnabled="<%=!readOnly%>" />
				  </td>
				  <td>
				  	<img width="10" height="1" border="0" src="images/general/dot.gif">
				  </td>
				  <td>
                    <component:button text="button.remove" 
                        href="javascript:submitForm('deleteUsers');" 
                        title="button.remove" isEnabled="<%=!readOnly%>" />
				  </td>
				</tr>
		      </table>
		    </td>
		  </tr>
		</table>  
      </td>
    </tr>
  </table>
  <!-- end button row-->

  <%@include file="/layout/spacer.jsp"%>

  <!-- table of users -->
  <table width="50%">
  <tr>
      <td width="100%">
          <%@include file="/layout/prevnext.jsp"%>
      </td>
  </tr>
  <tr>
  <td>
  <table class="back-table" border="0" cellspacing="0" cellpadding="1" align="left" width="100%">
    <tr>
      <td>
        <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row">
            <td align="center" valign="middle" nowrap><a href="javascript:checkAll(document.forms[0])"><img src="images/icons/select-all-small.gif" alt='<bean:message key="table.select.all"/>' vspace="2" border="0" width="11" height="13"></a><a href="javascript:unCheckAll(document.forms[0])"><img src="images/icons/deselect-all-small.gif" alt='<bean:message key="table.deselect.all"/>' vspace="2" border="0" width="11" height="13"></a></td>
            <td nowrap="nowrap" width="40%">
              <div class="table-header-text">
                <bean:message key="admin.users.list.username" />
              </div>
            </td>
            <td nowrap="nowrap" width="40%">
              <div class="table-header-text">
                <bean:message key="admin.users.list.role" />
              </div>
            </td>
          </tr>
          <%
          Trace.verbose(this, "admin_userlist.jsp", "Get attribute UserList");
          List userList = (List) session.getAttribute("UserList");
          Trace.verbose(this, "admin_userlist.jsp", "Number of entries:" + userList.size());
          int beginIndex = ((Integer)request.getAttribute("beginIndex")).intValue();
          int maxRows = ((Integer)request.getAttribute("maxRowsPerListing")).intValue();
          Trace.verbose(this, "admin_userlist.jsp", "Go into loop on user entries");
          for(int i = beginIndex; i < maxRows + beginIndex && i < userList.size(); i++) {
              try {
                Trace.verbose(this, "admin_userlist.jsp", "get entry " + i);
                UserInterface entry = (UserInterface) userList.get(i);
                Trace.verbose(this, "admin_userlist.jsp", "show entry for " + i + ") " + entry.getName());
                %>
                <tr>
                    <td nowrap="nowrap" align="center">
                        <div class="table-normal-text">
                            <% if(entry.getName().equals(aui.username)) { %>
                                   &nbsp;
                            <% } else { %>
                                  <input type="checkbox" 
                                      name="user"
                                      value="<%=entry.getName()%>" 
                                      <% if(readOnly) {%> disabled <% } %>>
                            <% } %>
                        </div>
                    </td>
                    <td align="left" nowrap="nowrap"> 
                        <div class="table-normal-text">
                            <%=entry.getName()%>
                        </div>
                    </td>
                    <td align="left" nowrap="nowrap">
                        <div class="table-normal-text">
                            <bean:message key='<%=entry.getRole().getKey()%>' />
                        </div> 
                    </td>
                </tr>
                <%
              } catch (Throwable x) {
              	Trace.verbose(this, "admin_userlist.jsp", x);
              }
          }
          Trace.verbose(this, "admin_userlist.jsp", "Done looping thru entries");
          %>
          
        </table>
      </td>
    </tr>
  </table>
  </td>
  </tr>
  <tr>
      <td width="100%">
          <%@include file="/layout/prevnext.jsp"%>
      </td>
  </tr>
  </table>

  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td>
        <%@include file="/layout/spacer.jsp"%>
      </td>
    </tr>
  </table>

</div>

</html:form>
</body>
</html>
