/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.sp.StorEdge_6x20FilterList;
import com.sun.netstorage.array.mgmt.sp.StorEdge_6x20IPHeadersFilter;
import com.sun.netstorage.array.mgmt.util.StorEdge_AssociationProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.CIMInstanceProvider;

public class StorEdge_6x20EntriesInFilterList
extends StorEdge_AssociationProvider
implements CIMInstanceProvider {
    private static final String DEFAULT_FW_CONFIG_FILE = "/opt/SUNWsespfw/repository";
    private static final String DELIMITER = ":";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String PROP_GROUP_COMPONENT = "GroupComponent";
    private static final String PROP_PART_COMPONENT = "PartComponent";
    private static final String PROP_ENTRY_SEQUENCE = "EntrySequence";
    private static final int ENTRY_SEQUENCE_VAL = 0;
    private static final HashMap DIRECTION_PORT_MAP = new HashMap();
    private static final String CLASSNAME = "StorEdge_6x20EntriesInFilterList";

    public String getClassName() {
        return CLASSNAME;
    }

    public CIMInstance[] references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        block19: {
            String METHOD = "references";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "references" + " entered"));
            this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "references");
            try {
                Vector keys = objectName.getKeys();
                if (assocName != null && !assocName.getObjectName().equalsIgnoreCase(this.getClassName())) break block19;
                CIMInstance[] ret = new CIMInstance[]{};
                if (objectName.getObjectName().equalsIgnoreCase(new StorEdge_6x20FilterList().getClassName())) {
                    String portDirection = null;
                    int i = 0;
                    while (i < keys.size()) {
                        CIMProperty prop = (CIMProperty)keys.elementAt(i);
                        if (prop.getName().equalsIgnoreCase("Name")) {
                            portDirection = (String)prop.getValue().getValue();
                            break;
                        }
                        ++i;
                    }
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Direction is " + portDirection));
                    Vector portsConnected = null;
                    try {
                        portsConnected = this.readConfigValue(DEFAULT_FW_CONFIG_FILE, (Vector)DIRECTION_PORT_MAP.get(portDirection));
                    }
                    catch (Exception e) {
                        WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    ret = new CIMInstance[portsConnected.size()];
                    int i2 = 0;
                    while (i2 < portsConnected.size()) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Building FilterList -> IPHeadersFilter "));
                        String connectedPort = (String)portsConnected.get(i2);
                        CIMInstance ipHeadersFilter = StorEdge_6x20IPHeadersFilter.getIPHeadersFilterInstance(connectedPort, (CIMOMHandle)this.getCimomHandle(), objectName.getNameSpace());
                        if (ipHeadersFilter == null) {
                            throw new CIMException("CIM_ERR_FAILED");
                        }
                        ret[i2] = this.buildComponent(objectName, ipHeadersFilter.getObjectPath(), assocName.getNameSpace());
                        ret[i2].filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Identity created."));
                        ++i2;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(new StorEdge_6x20IPHeadersFilter().getClassName())) {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Building IPHeadersFilter -> " + " FilterList Identity"));
                    String portDescription = null;
                    int i = 0;
                    while (i < keys.size()) {
                        CIMProperty prop = (CIMProperty)keys.elementAt(i);
                        if (prop.getName().equalsIgnoreCase("Name")) {
                            portDescription = (String)prop.getValue().getValue();
                            break;
                        }
                        ++i;
                    }
                    String listDirection = this.getDirection(portDescription);
                    Vector portsConnected = null;
                    Vector<String> descriptionVector = new Vector<String>();
                    descriptionVector.add(portDescription);
                    try {
                        portsConnected = this.readConfigValue(DEFAULT_FW_CONFIG_FILE, descriptionVector);
                    }
                    catch (Exception e) {
                        WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    if (portsConnected != null && portsConnected.size() > 0) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Building IPHeadersFilter -> FilterList "));
                        ret = new CIMInstance[1];
                        CIMInstance filterList = StorEdge_6x20FilterList.getFilterListInstance(listDirection, (CIMOMHandle)this.getCimomHandle(), objectName.getNameSpace());
                        if (filterList == null) {
                            throw new CIMException("CIM_ERR_FAILED");
                        }
                        ret[0] = this.buildComponent(filterList.getObjectPath(), objectName, assocName.getNameSpace());
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Identity created."));
                        ret[0].filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                    }
                } else {
                    CIMException ex = new CIMException("CIM_ERR_NOT_SUPPORTED");
                    throw ex;
                }
                return ret;
            }
            catch (CIMException ex) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + " unknown failure."), (Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + " Exception " + e.getMessage()), (Throwable)e);
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
        return null;
    }

    private boolean isEnabled(String portDesc) throws CIMException, IOException, FileNotFoundException {
        String METHOD = "isEnabled";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "isEnabled" + " entered"));
        boolean result = false;
        Vector<String> portDescVector = new Vector<String>();
        portDescVector.add(portDesc);
        Vector connectedPort = null;
        try {
            connectedPort = this.readConfigValue(DEFAULT_FW_CONFIG_FILE, portDescVector);
        }
        catch (FileNotFoundException fnfe) {
            String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
            WBEMDebug.trace1((String)(this.getClassName() + "." + "isEnabled" + " " + fnfe.getMessage()), (Throwable)fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
            throw ioe;
        }
        if (connectedPort != null && connectedPort.size() > 0) {
            if (portDesc.equals((String)connectedPort.get(0))) {
                result = true;
            } else {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "isEnabled" + " Something wrong with reading Config values."));
                String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
                LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
        return result;
    }

    private String getDirection(String description) {
        String METHOD = "getDirection";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getDirection" + " entered"));
        String result = null;
        Set keySet = DIRECTION_PORT_MAP.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Vector keyValue = (Vector)DIRECTION_PORT_MAP.get(key);
            if (!keyValue.contains(description)) continue;
            result = key;
            break;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector readConfigValue(String configFileName, Vector configEntryNames) throws FileNotFoundException, IOException {
        String METHOD = "readConfigValues";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "readConfigValues" + " entered"));
        Vector<String> result = new Vector<String>();
        if (configEntryNames == null) return result;
        if (configEntryNames.size() <= 0) return result;
        WBEMDebug.trace2((String)(this.getClassName() + "." + "readConfigValues" + " entry is " + configEntryNames.get(0)));
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(configFileName));
                String currLine = null;
                block5: while ((currLine = reader.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(currLine, DELIMITER);
                    if (tokenizer.countTokens() != 2) continue;
                    String portDesc = tokenizer.nextToken();
                    String state = tokenizer.nextToken();
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "readConfigValues" + " state for " + portDesc + " is " + state));
                    int i = 0;
                    while (i < configEntryNames.size()) {
                        String entry = (String)configEntryNames.get(i);
                        if (portDesc != null && portDesc.equalsIgnoreCase(entry)) {
                            if (!ENABLED.equalsIgnoreCase(state)) continue block5;
                            result.add(entry);
                            continue block5;
                        }
                        ++i;
                    }
                }
            }
            catch (FileNotFoundException ex) {
                String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
                LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
                WBEMDebug.trace1((String)(this.getClassName() + "." + "readConfigValues" + " " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
            catch (IOException ioe) {
                String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
                LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
                WBEMDebug.trace1((String)(this.getClassName() + "." + "readConfigValues" + " " + ioe.getMessage()), (Throwable)ioe);
                throw ioe;
            }
            Object var13_16 = null;
            if (reader == null) return result;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
        return result;
    }

    private void togglePortState(String portName, boolean enable) throws CIMException, InterruptedException, IOException, Exception {
        String METHOD = "togglePortState";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "togglePortState" + " entered"));
        StringBuffer cmd = new StringBuffer("/usr/local/bin/FW_config --toggle_port_state ");
        if (!this.isValidPort(portName)) {
            throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY");
        }
        cmd.append(portName);
        try {
            int returnCode = this.runScript(cmd.toString());
            if (returnCode != 0) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "togglePortState" + " Error running FW command: " + cmd));
                throw new Exception("Error running FW command");
            }
        }
        catch (InterruptedException ie) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "togglePortState" + " " + ie.getMessage()), (Throwable)ie);
            throw ie;
        }
        catch (IOException ioe) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "togglePortState" + " " + ioe.getMessage()), (Throwable)ioe);
            throw ioe;
        }
    }

    private boolean isValidPort(String port) {
        String METHOD = "isValidPort";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "isValidPort" + " entered"));
        boolean result = false;
        if (port != null) {
            Set possibleKeys = StorEdge_6x20IPHeadersFilter.PORT_MAP.keySet();
            result = possibleKeys.contains(port.trim());
        }
        WBEMDebug.trace2((String)(this.getClassName() + "." + "isValidPort" + " port " + port + " is valid = " + result));
        return result;
    }

    private int runScript(String cmdStr) throws InterruptedException, IOException {
        String METHOD = "runScript";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "runScript" + " entered"));
        WBEMDebug.trace2((String)(this.getClassName() + "." + "runScript" + " Calling FW config script: " + cmdStr));
        int returnCode = 0;
        try {
            Process p = Runtime.getRuntime().exec(cmdStr);
            p.waitFor();
            returnCode = p.exitValue();
        }
        catch (InterruptedException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "runScript" + " exception"), (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "runScript" + " exception"), (Throwable)ex);
            throw ex;
        }
        return returnCode;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String METHOD = "enumerateInstanceNames";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerateInstanceNames" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "enumerateInstanceNames");
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "enumerateInstances";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerateInstances" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "enumerateInstances");
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        CIMObjectPath cop;
        block11: {
            String METHOD = "createInstance";
            this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "createInstance");
            WBEMDebug.trace3((String)(this.getClassName() + "." + "createInstance" + " entered"));
            cop = null;
            try {
                CIMObjectPath partPath = (CIMObjectPath)ci.getProperty(PROP_PART_COMPONENT).getValue().getValue();
                CIMObjectPath groupPath = (CIMObjectPath)ci.getProperty(PROP_GROUP_COMPONENT).getValue().getValue();
                WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Part path is " + partPath));
                WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Group path is" + groupPath));
                String ipHeadersFilterDesc = null;
                Vector partKeys = partPath.getKeys();
                Enumeration en = partKeys.elements();
                while (en.hasMoreElements()) {
                    CIMProperty prop = (CIMProperty)en.nextElement();
                    if (!prop.getName().equalsIgnoreCase("Name")) continue;
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Part Name is " + prop.getName() + "=" + prop.getValue().getValue()));
                    ipHeadersFilterDesc = (String)prop.getValue().getValue();
                }
                String filterListDirection = null;
                Vector groupKeys = groupPath.getKeys();
                Enumeration en2 = groupKeys.elements();
                while (en2.hasMoreElements()) {
                    CIMProperty prop = (CIMProperty)en2.nextElement();
                    if (!prop.getName().equalsIgnoreCase("Name")) continue;
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Group Name is " + prop.getName() + "=" + prop.getValue().getValue()));
                    filterListDirection = (String)prop.getValue().getValue();
                }
                if (filterListDirection != null && ipHeadersFilterDesc != null && this.isAssociationPossible(ipHeadersFilterDesc, filterListDirection)) {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " trying to connect " + filterListDirection + " and " + ipHeadersFilterDesc));
                    try {
                        if (this.isEnabled(ipHeadersFilterDesc)) {
                            WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " port " + ipHeadersFilterDesc + " is already enabled"));
                        } else {
                            WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " toggling " + ipHeadersFilterDesc));
                            this.togglePortState(ipHeadersFilterDesc, true);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " One of the props is not set or " + " association is not possible "));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException cim) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + cim.getMessage()), (Throwable)cim);
                throw cim;
            }
            catch (ClassCastException cce) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + cce.getMessage()), (Throwable)cce);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (Exception ex) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + ex.getMessage()), (Throwable)ex);
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
        return cop;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        block16: {
            String METHOD = "deleteInstance";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "deleteInstance" + " entered"));
            this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "deleteInstance");
            try {
                Vector keys = op.getKeys();
                CIMObjectPath partPath = null;
                CIMObjectPath groupPath = null;
                Enumeration en = keys.elements();
                while (en.hasMoreElements()) {
                    CIMProperty prop = (CIMProperty)en.nextElement();
                    if (prop.getName().equalsIgnoreCase(PROP_PART_COMPONENT)) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " Part component is  " + prop.getName() + "=" + prop.getValue().getValue()));
                        partPath = (CIMObjectPath)prop.getValue().getValue();
                        continue;
                    }
                    if (!prop.getName().equalsIgnoreCase(PROP_GROUP_COMPONENT)) continue;
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " Group component is " + prop.getName() + "=" + prop.getValue().getValue()));
                    groupPath = (CIMObjectPath)prop.getValue().getValue();
                }
                if (partPath != null && groupPath != null) {
                    Vector partKeys = partPath.getKeys();
                    String partKey = null;
                    String groupKey = null;
                    int i = 0;
                    while (i < partKeys.size()) {
                        CIMProperty prop = (CIMProperty)partKeys.get(i);
                        if (prop.getName().equals("Name")) {
                            partKey = (String)prop.getValue().getValue();
                            break;
                        }
                        ++i;
                    }
                    Vector groupKeys = groupPath.getKeys();
                    int i2 = 0;
                    while (i2 < groupKeys.size()) {
                        CIMProperty prop = (CIMProperty)groupKeys.get(i2);
                        if (prop.getName().equals("Name")) {
                            groupKey = (String)prop.getValue().getValue();
                            break;
                        }
                        ++i2;
                    }
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " trying to disconnect " + partKey + " and " + groupKey));
                    if (this.isAssociationPossible(partKey, groupKey)) {
                        try {
                            if (!this.isEnabled(partKey)) {
                                WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " already disabled"));
                            } else {
                                this.togglePortState(partKey, false);
                                WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " disabling " + partKey));
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + e.getMessage()), (Throwable)e);
                            throw e;
                        }
                    }
                    WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + "  " + "the connection was not possible between " + partKey + " and " + groupKey));
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " Keys are not set properly :" + " partPath =" + partPath + " groupPath = " + groupPath));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException cim) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + cim.getMessage()), (Throwable)cim);
                throw cim;
            }
            catch (ClassCastException cce) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + cce.getMessage()), (Throwable)cce);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (Exception ex) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + ex.getMessage()), (Throwable)ex);
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
    }

    private boolean isAssociationPossible(String port, String direction) throws CIMException {
        String METHOD = "isAssociationPossible";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "isAssociationPossible" + " entered"));
        boolean result = false;
        Vector directionPorts = (Vector)DIRECTION_PORT_MAP.get(direction);
        if (directionPorts == null) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "isAssociationPossible" + " Direction " + direction + " does not exist."));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        result = directionPorts.contains(port.trim());
        return result;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        String METHOD = "execQuery";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "execQuery" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "execQuery");
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private void updateConfigValue(String configFileName, String portName) throws FileNotFoundException, IOException {
        String METHOD = "updateConfigValue";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "updateConfigValue" + " entered"));
        Set keySet = StorEdge_6x20IPHeadersFilter.PORT_MAP.keySet();
        Vector<String> allPorts = new Vector<String>();
        Iterator iterator = keySet.iterator();
        WBEMDebug.trace2((String)(this.getClassName() + "." + "updateConfigValue" + " Class for the key set is " + keySet.getClass().getName()));
        while (iterator.hasNext()) {
            allPorts.addElement((String)iterator.next());
        }
        Vector portsConnected = this.readConfigValue(DEFAULT_FW_CONFIG_FILE, allPorts);
        if (portsConnected.contains(portName)) {
            portsConnected.remove(portName);
        } else {
            portsConnected.add(portName);
        }
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(configFileName));
                Enumeration en = allPorts.elements();
                while (en.hasMoreElements()) {
                    String nextPort = (String)en.nextElement();
                    StringBuffer line = new StringBuffer(nextPort + DELIMITER);
                    if (portsConnected.contains(nextPort)) {
                        line.append(ENABLED);
                    } else {
                        line.append(DISABLED);
                    }
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "updateConfigValue" + " wrote line " + line));
                    out.println(line);
                }
            }
            catch (FileNotFoundException ex) {
                String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
                LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
                WBEMDebug.trace1((String)(this.getClassName() + "." + "updateConfigValue" + " " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
            catch (IOException ioe) {
                String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
                LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
                WBEMDebug.trace1((String)(this.getClassName() + "." + "updateConfigValue" + " " + ioe.getMessage()), (Throwable)ioe);
                throw ioe;
            }
            Object var13_16 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    static {
        Vector<String> inputList = new Vector<String>();
        inputList.add("sm_http");
        inputList.add("sm_https");
        inputList.add("svc_http");
        inputList.add("svc_https");
        inputList.add("ssh");
        inputList.add("cim_http");
        Vector<String> outputList = new Vector<String>();
        outputList.add("ntp");
        outputList.add("patchpro");
        Vector<String> bothList = new Vector<String>();
        bothList.add("snmp");
        DIRECTION_PORT_MAP.put("Input", inputList);
        DIRECTION_PORT_MAP.put("Output", outputList);
        DIRECTION_PORT_MAP.put("Both", bothList);
    }
}

