/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.dm.util.authorization;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AuthorizationUtility
implements Runnable {
    private static AuthorizationUtility auth = new AuthorizationUtility();
    private static final String GUEST_OPERATIONS = "GuestOperations.properties";
    private static final String STORAGE_OPERATIONS = "StorageOperations.properties";
    private static final String ADMIN_OPERATIONS = "AdminOperations.properties";
    private static final String USER_ROLES = "/opt/se6x20/resources/user.properties";
    private static final boolean ALWAYS_AUTHORIZE_ROOT = false;
    private Properties guestOps;
    private Properties storageOps;
    private Properties adminOps;
    private Properties userRoles;
    private Thread updater;

    public static AuthorizationUtility getInstance() {
        return auth;
    }

    private AuthorizationUtility() {
        try {
            this.load();
        }
        catch (IOException e) {
            System.err.println("Authorization: Unable to load initial data.");
            e.printStackTrace();
        }
        this.updater = new Thread(this);
        try {
            this.updater.setDaemon(true);
            this.updater.setName("StorEdge 6120 Authorization data loader");
            this.updater.setPriority(1);
        }
        catch (Exception e) {
            System.err.println("Authorization: Unable to modify current thread params.");
            e.printStackTrace();
        }
        this.updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        InputStream guestFile = this.getClass().getResourceAsStream(GUEST_OPERATIONS);
        InputStream storageFile = this.getClass().getResourceAsStream(STORAGE_OPERATIONS);
        InputStream adminFile = this.getClass().getResourceAsStream(ADMIN_OPERATIONS);
        FileInputStream userFile = new FileInputStream(USER_ROLES);
        Properties localUserRoles = new Properties();
        localUserRoles.load(userFile);
        Properties localGuestOps = new Properties();
        Properties localStorageOps = new Properties();
        Properties localAdminOps = new Properties();
        localGuestOps.load(guestFile);
        localStorageOps.load(storageFile);
        localAdminOps.load(adminFile);
        AuthorizationUtility authorizationUtility = this;
        synchronized (authorizationUtility) {
            this.userRoles = localUserRoles;
            this.guestOps = localGuestOps;
            this.storageOps = localStorageOps;
            this.adminOps = localAdminOps;
        }
    }

    public void run() {
        long sleepTime = Long.MAX_VALUE;
        while (true) {
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                try {
                    this.load();
                    sleepTime = Long.MAX_VALUE;
                    continue;
                }
                catch (IOException e2) {
                    sleepTime = 5000L;
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAuthName(String user, String operation) {
        String role = null;
        boolean ret = false;
        Properties localUserRoles = null;
        Properties localGuestOps = null;
        Properties localStorageOps = null;
        Properties localAdminOps = null;
        int i = 0;
        while (i <= 1) {
            ret = false;
            AuthorizationUtility authorizationUtility = this;
            synchronized (authorizationUtility) {
                localUserRoles = this.userRoles;
                localGuestOps = this.guestOps;
                localStorageOps = this.storageOps;
                localAdminOps = this.adminOps;
            }
            if (localUserRoles == null || localGuestOps == null || localStorageOps == null || localAdminOps == null) {
                try {
                    this.load();
                }
                catch (IOException e) {
                    System.err.println("Authorization: Unable to reload data.");
                    e.printStackTrace();
                }
            } else {
                role = localUserRoles.getProperty(user);
                if (role == null) {
                    ret = false;
                } else if (role.toLowerCase().equals("guest")) {
                    if (localGuestOps.getProperty(operation) != null) {
                        ret = true;
                    }
                } else if (role.toLowerCase().equals("storage")) {
                    if (localStorageOps.getProperty(operation) != null) {
                        ret = true;
                    }
                } else if (role.toLowerCase().equals("admin") && localAdminOps.getProperty(operation) != null) {
                    ret = true;
                }
                if (ret) {
                    try {
                        this.updater.interrupt();
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                    return ret;
                }
                try {
                    this.load();
                }
                catch (IOException e) {
                    System.err.println("Authorization: Unable to reload data.");
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return false;
    }

    public String getRole(String user) {
        return this.userRoles.getProperty(user);
    }
}

