/*
 * Decompiled with CFR 0.152.
 */
package com.sun.providers.tests.t4;

import com.sun.providers.tests.t4.CIMTesterBase;
import java.net.InetAddress;
import java.util.Enumeration;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class CIMDeleteStoragePool
extends CIMTesterBase {
    public String extraArgs() {
        return "<arrayname> <poolname>";
    }

    public static void main(String[] args) {
        try {
            CIMDeleteStoragePool test = new CIMDeleteStoragePool(args);
        }
        catch (CIMException e) {
            System.err.println("FAILED: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public CIMDeleteStoragePool(String[] args) throws CIMException {
        super(args);
        if (args.length != this.baseArgs() + 2) {
            this.usage();
            System.exit(1);
        }
        String ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(args[4]).getHostAddress();
            System.out.println("DEBUG: hostname " + args[4] + " = " + ipAddr);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CIMObjectPath cop = new CIMObjectPath("StorEdge_6120StorageConfigurationService");
        System.out.println("DEBUG: Enumerating " + cop);
        Enumeration services = this.client.enumerateInstances(cop, false, false, true);
        CIMInstance conf = null;
        CIMObjectPath init = null;
        while (services.hasMoreElements()) {
            conf = (CIMInstance)services.nextElement();
            if (conf.getProperty("SystemName").getValue().getValue().toString().equalsIgnoreCase(ipAddr)) {
                System.out.println("DEBUG: Found match for instance of ConfService " + conf.toString());
                init = conf.getObjectPath();
                System.out.println("DEBUG: ObjectPath for instance found is : " + init.toString());
                break;
            }
            System.out.println("DEBUG: ConfService: " + conf.toString() + " does not match");
        }
        CIMObjectPath poolCop = new CIMObjectPath("StorEdge_6120StoragePool");
        System.out.println("DEBUG: Enumerating " + poolCop);
        Enumeration pools = this.client.enumerateInstances(poolCop, false, false, true);
        while (pools.hasMoreElements()) {
            CIMInstance pool = (CIMInstance)pools.nextElement();
            if (pool == null || ipAddr == null) continue;
            System.out.println("DEBUG: Instance " + pool);
            String poolName = args[5];
            if (pool.getProperty("ElementName").getValue().getValue().toString().equalsIgnoreCase(poolName)) {
                System.out.println("Pool found!  " + poolName + " matched\n " + pool.toString());
                CIMArgument[] inArgs = new CIMArgument[1];
                CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
                inArgs[0] = new CIMArgument("Pool", new CIMValue((Object)pool.getObjectPath()));
                CIMValue results = null;
                try {
                    results = this.client.invokeMethod(init, "DeleteStoragePool", inArgs, outArgs);
                }
                catch (Exception e) {
                    System.out.println("DEBUG: Exception caught: \n");
                    e.printStackTrace();
                    return;
                }
                System.out.println("PASS: Results are: " + results);
                break;
            }
            System.out.println("Element name of pool: " + pool.getProperty("ElementName").getValue().getValue().toString());
        }
    }
}

