/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.util;

import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StorEdge_PersistentStorage {
    private static StorEdge_PersistentStorage singleton = new StorEdge_PersistentStorage();
    private static final String CLASSNAME = "StorEdge_PersistentStorage";
    public static final boolean AUTO_SAVE = true;
    private static final String DELIMITER = ":";
    public static final boolean MANUAL_SAVE = false;
    private Properties properties;
    private static final String PERSISTENT_FILE = "/opt/se6x20/data";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private StorEdge_PersistentStorage() {
        block12: {
            String METHOD = "constructor";
            this.properties = new Properties();
            File file = new File(PERSISTENT_FILE);
            if (file.exists()) {
                FileInputStream in = null;
                in = new FileInputStream(file);
                this.properties.load(in);
                Object var6_4 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block12;
                }
                catch (IOException ioe) {}
                break block12;
                {
                    catch (Exception e) {
                        WBEMDebug.trace1("StorEdge_PersistentStorage.constructor Exception while reading the persistent file /opt/se6x20/data");
                        Object var6_5 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                            break block12;
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public static StorEdge_PersistentStorage getInstance() {
        String METHOD = "getInstance";
        WBEMDebug.trace3("StorEdge_PersistentStorage.getInstance Method entered. ");
        return singleton;
    }

    public String getPersistentString(String key) {
        String METHOD = "getPersistentString";
        WBEMDebug.trace3("StorEdge_PersistentStorage.getPersistentString Method entered. ");
        return this.properties.getProperty(key);
    }

    public byte[] getPersistentEncodedString(String key) throws Exception {
        String METHOD = "getPersistentEncodedString";
        WBEMDebug.trace3("StorEdge_PersistentStorage.getPersistentEncodedString Method entered. ");
        String strValue = this.properties.getProperty(key);
        byte[] result = null;
        if (strValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(strValue, DELIMITER);
            int byteNumber = tokenizer.countTokens();
            result = new byte[byteNumber];
            int i = 0;
            while (i < byteNumber) {
                try {
                    String next = tokenizer.nextToken();
                    Byte nextByte = new Byte(next);
                    result[i] = nextByte;
                    WBEMDebug.trace2("StorEdge_PersistentStorage.getPersistentEncodedString Read encoded value " + nextByte);
                }
                catch (NumberFormatException nfe) {
                    WBEMDebug.trace1(" Persisted encoded string not of  expected format");
                    throw new Exception(" Persisted encoded string not valid");
                }
                ++i;
            }
        }
        return result;
    }

    public Vector getPersistentArray(String key) {
        String METHOD = "getPersistentArray";
        WBEMDebug.trace3("StorEdge_PersistentStorage.getPersistentArray Method entered. ");
        Vector<String> result = new Vector<String>();
        int index = 0;
        boolean searchMore = true;
        while (searchMore) {
            if (this.properties.containsKey(key + "." + index)) {
                result.addElement(this.properties.getProperty(key + "." + index));
                ++index;
                continue;
            }
            searchMore = false;
        }
        return result;
    }

    public synchronized void setPersistentString(String key, String value, boolean autoSave) {
        String METHOD = "setPersistentString";
        WBEMDebug.trace3("StorEdge_PersistentStorage.setPersistentString Method entered. ");
        this.removePersistentArray(key, false);
        if (value != null) {
            this.properties.setProperty(key, value);
        }
        if (autoSave) {
            this.save();
        }
    }

    public synchronized void setPersistentEncodedString(String key, byte[] value, boolean autoSave) {
        String METHOD = "setPersistentEncodedString";
        WBEMDebug.trace3("StorEdge_PersistentStorage.setPersistentEncodedString Method entered. ");
        this.removePersistentArray(key, false);
        if (value != null) {
            StringBuffer strValue = new StringBuffer("");
            int i = 0;
            while (i < value.length) {
                Byte element = new Byte(value[i]);
                strValue.append(element.toString());
                if (i != value.length - 1) {
                    strValue.append(DELIMITER);
                }
                ++i;
            }
            WBEMDebug.trace3("StorEdge_PersistentStorage.setPersistentEncodedString Persisting encoded value " + strValue);
            if (value != null) {
                this.properties.setProperty(key, strValue.toString());
            }
        }
        if (autoSave) {
            this.save();
        }
    }

    public synchronized void removePersistentString(String key, boolean autoSave) {
        String METHOD = "setPersistentString";
        WBEMDebug.trace3("StorEdge_PersistentStorage.setPersistentString Method entered. ");
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
        if (autoSave) {
            this.save();
        }
    }

    public synchronized void removePersistentEncodedString(String key, boolean autoSave) {
        String METHOD = "setPersistentEncodedString";
        WBEMDebug.trace3("StorEdge_PersistentStorage.setPersistentEncodedString Method entered. ");
        this.removePersistentString(key, autoSave);
    }

    public synchronized void setPersistentArray(String key, Vector values, boolean autoSave) {
        String METHOD = "setPersistentArray";
        WBEMDebug.trace3("StorEdge_PersistentStorage.setPersistentArray Method entered. ");
        this.removePersistentArray(key, false);
        if (values != null) {
            int index = values.size();
            int i = 0;
            while (i < values.size()) {
                String value = (String)values.get(i);
                this.properties.setProperty(key + "." + i, value);
                ++i;
            }
        }
        if (autoSave) {
            this.save();
        }
    }

    public synchronized void removePersistentArray(String key, boolean autoSave) {
        String METHOD = "setPersistentArray";
        WBEMDebug.trace3("StorEdge_PersistentStorage.setPersistentArray Method entered. ");
        int index = 0;
        boolean searchMore = true;
        while (searchMore) {
            if (this.properties.containsKey(key + "." + index)) {
                this.properties.remove(key + "." + index);
                ++index;
                continue;
            }
            searchMore = false;
        }
        if (autoSave) {
            this.save();
        }
    }

    public void save() {
        String METHOD = "save";
        File file = new File(PERSISTENT_FILE);
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.properties.store(out, null);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            WBEMDebug.trace1("StorEdge_PersistentStorage.save Exception trying to store  to a file /opt/se6x20/data");
        }
    }

    public Set getAvailableProperties() {
        String METHOD = "getAvailableProperties";
        WBEMDebug.trace3("StorEdge_PersistentStorage.getAvailableProperties Method entered. ");
        return this.properties.keySet();
    }
}

