/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class ProviderLogger {
    private static final String PROPS = "/opt/se6x20/resources/StorEdge_6120.properties";
    private static String DEFAULT_LOG_FILE_NAME = "/var/tmp/6x20LogFile";
    private static String DEFAULT_LOG_FILE_SIZE = "1000000";
    private static String DEFAULT_NUMBER_OF_LOG_FILES = "5";
    private static String DEFAULT_CHECK_INTERVAL = "60000";
    private static String DEFAULT_LOG_LEVEL = Level.SEVERE.getName();
    private static String LOG_LEVEL_KEY = "Log.Level";
    private static String LOG_FILE_NAME_KEY = "Log.FileName";
    private static String LOG_FILE_SIZE_KEY = "Log.FileSize";
    private static String LOG_FILE_CHECK_INTERVAL_KEY = "Log.CheckInterval";
    private static String NUMBER_OF_LOG_FILES_KEY = "Log.NumberOfFiles";
    private static String logLevel = DEFAULT_LOG_LEVEL;
    private static String logFileName = DEFAULT_LOG_FILE_NAME;
    private static int logFileSize;
    private static int numLogFiles;
    private static long lastInterval;
    private static long dynamicLogCheckInterval;
    private static StreamHandler handler;
    private static Timer timer;
    private static DynamicLoggerTask checker;
    private static ProviderLogger inst;
    private static Logger ourLogger;

    public static ProviderLogger getInstance() {
        if (inst == null) {
            inst = new ProviderLogger();
        }
        return inst;
    }

    private ProviderLogger() {
        if (ourLogger == null) {
            ourLogger = Logger.getLogger("com.sun.netstorage.array.mgmt.util");
            checker = new DynamicLoggerTask(ourLogger, PROPS);
            timer.scheduleAtFixedRate((TimerTask)checker, 0L, dynamicLogCheckInterval);
        }
    }

    public static void log(Level loglevel, String message) {
        ourLogger.log(loglevel, message);
    }

    public static void log(Level loglevel, String message, Throwable stackmsg) {
        ourLogger.log(loglevel, message, stackmsg);
    }

    static {
        dynamicLogCheckInterval = lastInterval = Long.parseLong(DEFAULT_CHECK_INTERVAL);
        handler = null;
        timer = new Timer(true);
        checker = null;
        ourLogger = null;
    }

    private static class DynamicLoggerTask
    extends TimerTask {
        private final File file;
        private long lastModified;
        private boolean fileExists;
        private boolean firstRun;
        private boolean hasBeenUpdated;
        private final Logger logger;

        public DynamicLoggerTask(Logger aLogger, String fileName) {
            this.file = new File(fileName);
            this.fileExists = this.file.exists();
            this.hasBeenUpdated = true;
            this.lastModified = 0L;
            this.logger = aLogger;
        }

        public DynamicLoggerTask(Logger aLogger, File aFile) {
            this.file = aFile;
            this.fileExists = this.file.exists();
            this.hasBeenUpdated = true;
            this.lastModified = 0L;
            this.logger = aLogger;
        }

        public void run() {
            if (this.logger != null) {
                try {
                    this.check();
                }
                catch (IOException ioe) {
                    this.logger.throwing(this.getClass().getName(), "run", ioe);
                }
                catch (SecurityException se) {
                    this.logger.throwing(this.getClass().getName(), "run", se);
                }
            } else {
                this.cancel();
            }
        }

        public void check() throws IOException, SecurityException {
            String logFileSizeString = DEFAULT_LOG_FILE_SIZE;
            String numLogFilesString = DEFAULT_NUMBER_OF_LOG_FILES;
            String checkIntervalString = DEFAULT_CHECK_INTERVAL;
            String logMsg = null;
            Exception logException = null;
            if (this.logger == null) {
                return;
            }
            if (!this.fileExists) {
                this.fileExists = this.file.exists();
            }
            if (this.fileExists) {
                long testTime = this.file.lastModified();
                if (testTime != this.lastModified) {
                    this.hasBeenUpdated = true;
                    this.lastModified = testTime;
                    Properties props = new Properties();
                    try {
                        props.load(new FileInputStream(this.file));
                        checkIntervalString = props.getProperty(LOG_FILE_CHECK_INTERVAL_KEY, DEFAULT_CHECK_INTERVAL);
                        logLevel = props.getProperty(LOG_LEVEL_KEY, DEFAULT_LOG_LEVEL);
                        logFileName = props.getProperty(LOG_FILE_NAME_KEY, DEFAULT_LOG_FILE_NAME);
                        logFileSizeString = props.getProperty(LOG_FILE_SIZE_KEY, DEFAULT_LOG_FILE_SIZE);
                        numLogFilesString = props.getProperty(NUMBER_OF_LOG_FILES_KEY, DEFAULT_NUMBER_OF_LOG_FILES);
                    }
                    catch (FileNotFoundException fnfe) {
                        logMsg = "No Provider Property File, using defaults";
                        logException = fnfe;
                    }
                    catch (IOException ioe) {
                        logMsg = "Error Reading Provider Property File, using defaults";
                        logException = ioe;
                    }
                    catch (SecurityException se) {
                        logMsg = "No Access to Property File, using defaults";
                        logException = se;
                    }
                }
            } else {
                logLevel = DEFAULT_LOG_LEVEL;
                logFileName = DEFAULT_LOG_FILE_NAME;
                logFileSizeString = DEFAULT_LOG_FILE_SIZE;
                numLogFilesString = DEFAULT_NUMBER_OF_LOG_FILES;
                checkIntervalString = DEFAULT_CHECK_INTERVAL;
            }
            if (this.hasBeenUpdated) {
                this.hasBeenUpdated = false;
                try {
                    logFileSize = Integer.parseInt(logFileSizeString);
                }
                catch (NumberFormatException nfe) {
                    logFileSize = Integer.parseInt(DEFAULT_LOG_FILE_SIZE);
                }
                try {
                    numLogFiles = Integer.parseInt(numLogFilesString);
                }
                catch (NumberFormatException nfe) {
                    numLogFiles = Integer.parseInt(DEFAULT_NUMBER_OF_LOG_FILES);
                }
                try {
                    dynamicLogCheckInterval = Long.parseLong(checkIntervalString);
                }
                catch (NumberFormatException nfe) {
                    dynamicLogCheckInterval = Long.parseLong(DEFAULT_CHECK_INTERVAL);
                }
                if (lastInterval != dynamicLogCheckInterval) {
                    this.logger.severe("Updated Logger Config:  Interval: " + dynamicLogCheckInterval);
                    this.cancel();
                    checker = new DynamicLoggerTask(this.logger, this.file);
                    timer.scheduleAtFixedRate((TimerTask)checker, 0L, dynamicLogCheckInterval);
                    lastInterval = dynamicLogCheckInterval;
                    return;
                }
                if (handler != null) {
                    this.logger.removeHandler(handler);
                    handler.flush();
                    handler.close();
                }
                try {
                    handler = new FileHandler(logFileName, logFileSize, numLogFiles);
                }
                catch (IllegalArgumentException iae) {
                    logMsg = "Bad Value, Number of Log Files: " + numLogFiles;
                    logException = iae;
                    numLogFiles = Integer.parseInt(DEFAULT_NUMBER_OF_LOG_FILES);
                    handler = new FileHandler(logFileName, logFileSize, numLogFiles);
                }
                handler.setFormatter(new SimpleFormatter());
                this.logger.addHandler(handler);
                try {
                    this.logger.setLevel(Level.parse(logLevel.toUpperCase()));
                }
                catch (IllegalArgumentException iae1) {
                    logMsg = "Bad Value, Log Level: " + LOG_LEVEL_KEY;
                    logException = iae1;
                    logLevel = DEFAULT_LOG_LEVEL;
                    this.logger.setLevel(Level.parse(DEFAULT_LOG_LEVEL));
                }
                if (logMsg != null) {
                    this.logger.warning(logMsg);
                    if (logException != null) {
                        this.logger.throwing(this.getClass().getName(), "check", logException);
                    }
                }
                this.logger.config("Updated Logger Config:  Level: " + logLevel + " File: " + logFileName + " Size: " + logFileSize + " Number: " + numLogFiles);
            }
        }
    }
}

